(**
 *
 *  Module:       dearcunp.pas
 *  Description:  unPacking routines (run-length encoding)
 *
 *  Revision History:
 *    7-26-88: unitized for Turbo v4.0
 *
**)


unit dearcunp;

interface

uses
  dearcglb,
  dearcabt,
  dearcio;

  procedure putc_unp(c : integer);
  procedure putc_ncr(c : integer);
  function getc_unp : integer;


implementation

(*
 *  definitions for unpack
 *)
Const
  DLE = $90;

Var
  lastc  : integer;

(**
 *
 *  Name:         procedure putc_unp
 *  Description:  put one character to extracted file,  update CRC
 *  Parameters:   value -
 *                  c : integer - value to write
 *
**)
procedure putc_unp(c : integer);
begin
  crcval := ((crcval shr 8) and $00FF) xor crctab[(crcval xor c) and $00FF];
  put_ext(c)
end; (* proc putc_unp *)


(**
 *
 *  Name:         procedure putc_ncr
 *  Description:  put one char,  checking for run-length compression
 *  Parameters:   value -
 *                  c : integer - value to write
 *
**)
procedure putc_ncr(c : integer);
begin
  case state of
    NOHIST :
      if c = DLE then
        state := INREP
      else
        begin
          lastc := c;
          putc_unp(c)
        end;

    INREP  :
      begin
        if c = 0 then
          putc_unp(DLE)
        else
          begin
            c := c - 1;
            while (c <> 0) do
              begin
                putc_unp(lastc);
                c := c - 1
              end
            end;

        state := NOHIST
      end
  end  (* case *)
end; (* proc putc_ncr *)


(**
 *
 *  Name:         function getc_unp : integer
 *  Description:  get one character from archive
 *  Parameters:   none
 *  Returns:      character read
 *
**)
function getc_unp : integer;
begin
  if size = 0.0 then
    getc_unp := -1
  else
    begin
      size := size - 1;
      getc_unp := get_arc
    end;
end; (* func getc_unp *)

end.

