
/* Output typedefs for the u32_8 union
 *
 * Copyright (C) 1998 by Willem Monsuwe
 *    Faculteit Informatica, Technische Universiteit Eindhoven
 *    email: willem@stack.nl
 */

#include <stdio.h>
#include "u32_16.h"
typedef unsigned char	byte;	/* 8-bit unsigned integer */

/* Struct for correctly addressing the bytes of a longword */
typedef union {
	u32 l;
	struct {
		byte b1;
		byte b2;
		byte b3;
		byte b4;
	} b;
	struct {
		u16 w1;
		u16 w2;
	} w;
} u32_8;

void main(void)
{
	u32_8 t;

	puts(
"/* File generated by u32_8.c\n"
" *\n"
" * Byte-order dependant stuff\n"
" * Copyright (C) 1998 by Willem Monsuwe\n"
" *    Faculteit Informatica, Technische Universiteit Eindhoven\n"
" *    email: willem@stack.nl */\n\n"
"/* Struct for correctly addressing the bytes of a longword */\n"
"typedef union {\n"
"\tu32 l;");
	t.l = 0x04030201L;
	printf(
"\tstruct {\n"
"\t\tbyte b%d;\n"
"\t\tbyte b%d;\n"
"\t\tbyte b%d;\n"
"\t\tbyte b%d;\n"
"\t} b;\n", t.b.b1, t.b.b2, t.b.b3, t.b.b4);
	t.l = 0x00020001L;
	printf(
"\tstruct {\n"
"\t\tu16 w%d;\n"
"\t\tu16 w%d;\n"
"\t} w;\n"
"} u32_8;\n" , t.w.w1, t.w.w2);
	exit(0);
}
