
/* Output typedefs for u32, u16
 *
 * Copyright (C) 1998 by Willem Monsuwe
 *    Faculteit Informatica, Technische Universiteit Eindhoven
 *    email: willem@stack.nl
 */

#include <stdio.h>

void main(void)
{
	puts(
"/* File generated by u32_16.c\n"
" *\n"
" * Correctly sized integers\n"
" * Copyright (C) 1998 by Willem Monsuwe\n"
" *    Faculteit Informatica, Technische Universiteit Eindhoven\n"
" *    email: willem@stack.nl */\n");
	if (sizeof(int) == 4)
		puts("typedef unsigned int u32;\t/* 32-bit unsigned integer */");
	else if (sizeof(long) == 4)
		puts("typedef unsigned long u32;\t/* 32-bit unsigned integer */");
	else if (sizeof(long int) == 4)
		puts("typedef unsigned long int u32;\t/* 32-bit unsigned integer */");
	else if (sizeof(long long) == 4)
		puts("typedef unsigned long long u32;\t/* 32-bit unsigned integer */");
	else {
		fprintf(stderr, "Couldn't find 32-bit integer!\n");
		exit(1);
	}
	
	if (sizeof(int) == 2)
		puts("typedef unsigned int u16;\t/* 16-bit unsigned integer */");
	else if (sizeof(short) == 2)
		puts("typedef unsigned short u16;\t/* 16-bit unsigned integer */");
	else if (sizeof(short int) == 2)
		puts("typedef unsigned short int u16;\t/* 16-bit unsigned integer */");
	else {
		fprintf(stderr, "Couldn't find 16-bit integer!\n");
		exit(1);
	}
	if (sizeof(void *) <= 4)
		puts("\n#define HAVE_32_BIT_POINTERS\t/* Pointers are 32 bit */\n");
	exit(0);
}
