VERSION 5.00
Begin VB.Form Form2 
   Caption         =   "Password protected Windows Networks access sample"
   ClientHeight    =   6405
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6765
   LinkTopic       =   "Form2"
   LockControls    =   -1  'True
   ScaleHeight     =   6405
   ScaleWidth      =   6765
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton Command4 
      Caption         =   "Disconnect enumerated Network paths"
      Height          =   495
      Left            =   360
      TabIndex        =   12
      Top             =   4440
      Width           =   6015
   End
   Begin VB.ListBox List1 
      Height          =   1035
      Left            =   360
      TabIndex        =   11
      Top             =   5040
      Width           =   6015
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Enumerate Network paths connected"
      Height          =   495
      Left            =   360
      TabIndex        =   10
      Top             =   3840
      Width           =   6015
   End
   Begin VB.TextBox Text3 
      Height          =   285
      Left            =   360
      TabIndex        =   9
      Text            =   "Username"
      Top             =   1080
      Width           =   3135
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Disconnect"
      Height          =   495
      Left            =   360
      TabIndex        =   7
      Top             =   3240
      Width           =   6015
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Connect to the share path / Logon on the Winnt - Win 2000 machine"
      Height          =   495
      Left            =   360
      TabIndex        =   4
      Top             =   2640
      Width           =   6015
   End
   Begin VB.TextBox Text2 
      Height          =   285
      IMEMode         =   3  'DISABLE
      Left            =   360
      PasswordChar    =   "*"
      TabIndex        =   3
      Text            =   "Password"
      Top             =   1680
      Width           =   3135
   End
   Begin VB.TextBox Text1 
      Height          =   285
      Left            =   360
      TabIndex        =   1
      Text            =   "\\servername\sharename"
      Top             =   480
      Width           =   3135
   End
   Begin VB.Label Label5 
      Caption         =   "Enter user name ( Only required if the target machine is Winnt or Windows 2000 )"
      Height          =   255
      Left            =   360
      TabIndex        =   8
      Top             =   840
      Width           =   6135
   End
   Begin VB.Label Label4 
      Height          =   495
      Left            =   960
      TabIndex        =   6
      Top             =   2040
      Width           =   5535
   End
   Begin VB.Label Label3 
      Caption         =   "Status : "
      Height          =   255
      Left            =   360
      TabIndex        =   5
      Top             =   2040
      Width           =   615
   End
   Begin VB.Label Label2 
      Caption         =   "Enter read only or full access password / Enter Winnt - Windows 2000 password"
      Height          =   255
      Left            =   360
      TabIndex        =   2
      Top             =   1440
      Width           =   6135
   End
   Begin VB.Label Label1 
      Caption         =   "Enter the Network path , and you can use the name or IP address of the machine"
      Height          =   255
      Left            =   360
      TabIndex        =   0
      Top             =   240
      Width           =   6135
   End
End
Attribute VB_Name = "Form2"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Private Sub Command1_Click()

Label4.Caption = ""
Dim RetError As Long
Dim RetErrorDescription As String
Dim DriveLetter As String

'The SetNetworkPassword function can access Windows 95/98 and Winnt 4.0/Windows 2000 password protecteds based Networks without problems

'You only need to define the sharepath and the username and password to access the resources

'If you are accessing a Windows 95/98 system , then the username doesnot matter , only the password is required in order to connect to the share path

'If you are accessing a Windows NT/ Windows 2000 system , then you need to enter the username and password in order to access the share path
'but after accessing the first share path in a Winnt machine , all others share paths will be accessible without entering the user name or password again , the user name and password are used to logon in the Windows NT or Windows 2000 machine( if the share path applies to the same user , of course )

'Notice that the password , username and share paths are not case sensitive , and you can pass the IP address instead the share path name

'And any error will be explained in the RetError and RetErrorDescription variables that will return from the functions

'The recommendation of the use of the SetNetworkPassword function is to connect to the share path before the compression or decompression , and disconnect the share path after the execution

'Obviously , if the the share path is read only , you will be unable to write to it or to define the share path as a temporary folder
'Indeed , the temp folder function verifies whether the temp path passed is read only or not , if read only an error will be reported

'If you are using the read only share path only to read files to the compression , then it will work without problems

'And you need to call the SetNetworkPassword function to each password protected share path used in the compression or decompression function
'And the sharepaths used may have different passwords without problems
Dim ret As Boolean
ret = Form1.MaqZip1.SetNetworkPassword(Text2.Text, Text3.Text, Text1.Text, RetError, RetErrorDescription)
'The RetErrorDescription variable  will retrieve the description of the SetNetworkPassword function
'If an error occur , it will explain why

'The function need to map the drive in order to ensure access to the remote path

Label4.Caption = RetErrorDescription

'After the compression or decompression function , just remove the connection with the DisconnectNetwork function

If RetError = 0 Then
Command2.Caption = "Disconnect " & Text1.Text
Else
Command2.Caption = "Disconnect "
End If

End Sub

Private Sub Command2_Click()

Label4.Caption = ""
Dim RetError As Long
Dim RetErrorDescription As String

If Text1.Text <> "" Then

'You need to disconnect the drive or the connection will remain available in the system

'the argument Force of the DisconnectNetwork function will define whether you will force the disconnection of the share path if some files are openned and being used

'0 to dont force , 1 to force the disconnection

ret = Form1.MaqZip1.DisconnectNetwork(Text1.Text, 1, RetError, RetErrorDescription)

Label4.Caption = RetErrorDescription

End If

End Sub

Private Sub Command3_Click()

List1.Clear

Dim Drives() As String

Dim Network() As String

Dim NumberofItens As Long

ret = Form1.MaqZip1.EnumerateNetworkSharePaths(Network(), Drives(), NumberofItens)

If NumberofItens <> 0 Then
For I = 0 To UBound(Network())
List1.AddItem Network(I) & vbTab & vbTab & "Drive letter : " & Drives(I)
Next I
Else
List1.AddItem "No itens to add"
End If

End Sub

Private Sub Command4_Click()

Dim Drives() As String

Dim Network() As String

Dim NumberofItens As Long

Dim RetError As Long
Dim RetErrorDescription As String
ret = Form1.MaqZip1.EnumerateNetworkSharePaths(Network(), Drives(), NumberofItens)

If NumberofItens <> 0 Then
For I = 0 To UBound(Network())


            If InStr(1, Network(I), "$", vbBinaryCompare) = 0 Then  'dont disconnect if a $ is in the share path , it may cause Network problems if disconnected ( IPC$ )
                ret = Form1.MaqZip1.DisconnectNetwork(Network(I), 1, RetError, RetErrorDescription)
                If ret <> 0 Then
                MsgBox RetErrorDescription
                End If
            End If
        
            If Drives(I) <> "" Then
                    ret = Form1.MaqZip1.DisconnectNetwork(Drives(I), 1, RetError, RetErrorDescription)
                    If ret <> 0 Then
                    MsgBox RetErrorDescription
                    End If
            End If

Next I

Else
MsgBox "No itens to disconnect "
End If

'Call the command3 button to refresh the list1 with the remaining sharepaths

Command3_Click

End Sub

