/***********************************************
	BRLZ
   			compresseur dcompresseur  avec archiveur
            selon la mthode LZW

   fichier principal
***********************************************/

/*** Les fichiers entte ***/
#include <time.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <sys/stat.h>

#include "lzw.h"
#include "comp_lzw.h"

Element *Archive;						//- tableau contenant tous les lments de l'archive
int Nb_Fichier_Archive;				//- Nombre d'lment de ce tableau
int Taille_Archive;					//- Nombre d'lments que peut contenir ce tableau
char Nom_Archive[50];				//- Nombre du fichier archive
FILE *Archive_Fich;					//- pointeur FILE sur ce fichier

Entete_Archive Entete;

unsigned long Fin_Fichier;			//- Fin du fichier archive
BOOL Recursif;							//- pour savoir si il faut faire les sous-rpertoires


//----- Les prototypes de fonctions ------
int Ajouter_Fichier_Archive( Element *El );
void Syntaxe( void );
int Ouvrir_Archive( int Mode, char *Com );
int Initialiser_Archive( void );
void Vider_Archive( void );
int Ecrire_Element_Archive( FILE *Fich_Out, int Pos );
int Mise_A_Jour_Element( FILE *Fich_Out, int Pos );
int Mise_A_Jour_Entete( FILE *Fich_Out );
int Compresser_Recur( char *Nom_Fich, char *Rep, BOOL Recur );
int Traiter_Commande( char *Com, BOOL Recur );
int Traiter_Commande2( char *Com, BOOL Recur );
BOOL Identifier_Fichier( char *Com, char *Nom );



//--------------------------------------
int Mise_A_Jour_Entete( FILE *Fich_Out )
{
Entete.Nb_Fichier=Nb_Fichier_Archive;
fseek( Archive_Fich, 0, SEEK_SET );
if( (fwrite( &Entete, 1, sizeof(Entete_Archive), Fich_Out))!=sizeof(Entete_Archive) )
	return( ERR_ECRITURE_ARCHIVE );

return( OK );
}

//-----------------------------
int Mise_A_Jour_Element( FILE *Fich_Out, int Pos )
{
fseek( Fich_Out, Archive[Pos].Position, SEEK_SET );
if( (fwrite(&Archive[Pos].Suivant, 1, sizeof( unsigned long)*3, Fich_Out)) != sizeof( unsigned long)*3 )
		return( ERR_ECRITURE_ARCHIVE );

fseek( Fich_Out, Archive[Pos].Suivant, SEEK_SET );

return( OK );
}


//---------------------------------------------------
int Ecrire_Element_Archive( FILE *Fich_Out, int Pos )
{
if( (fwrite(&Archive[Pos].Suivant, 1, sizeof( unsigned long)*3, Fich_Out)) != sizeof( unsigned long)*3 )
   return( ERR_ECRITURE_ARCHIVE );

if( (fwrite(&Archive[Pos].L_Nom, 1, sizeof( unsigned char ), Fich_Out)) != sizeof( unsigned char ) )
	return( ERR_ECRITURE_ARCHIVE );

if( (fwrite(&Archive[Pos].Nom, 1, Archive[Pos].L_Nom, Fich_Out)) != Archive[Pos].L_Nom )
	return( ERR_ECRITURE_ARCHIVE );

if( (fwrite(&Archive[Pos].L_Rep, 1, sizeof( unsigned char ), Fich_Out)) != sizeof( unsigned char ) )
	return( ERR_ECRITURE_ARCHIVE );

if( (fwrite(&Archive[Pos].Repertoire, 1, Archive[Pos].L_Rep, Fich_Out)) != Archive[Pos].L_Rep )
	return( ERR_ECRITURE_ARCHIVE );
return( OK );
}

//------------------------
void Vider_Archive( void )
{
if( Archive != NULL )
	free( Archive );
Taille_Archive=0;
}

//-----------------------
int Creer_Archive( void )
{
int temp;

//** Cration du fichier
if( (Archive_Fich=fopen( Nom_Archive, "w+b" )) == NULL )
  	return( ERR_OUVERTURE_ARCHIVE_W );

//** Initialisation du tableau Archive pour la structure du fichier archive
if( (temp=Initialiser_Archive()) != OK )
	return( temp );

Fin_Fichier=sizeof(Entete_Archive);

//** criture de l'entete
Entete.Identificateur=BRLZ_IDENTIFICATEUR;
Entete.Nb_Fichier=0;
if( (fwrite( &Entete, 1, sizeof(Entete_Archive), Archive_Fich))!=sizeof(Entete_Archive) )
	return( ERR_ECRITURE_ARCHIVE );

return( OK );
}


//-----------------------------
int Initialiser_Archive( void )
{
if( Taille_Archive != 0 )
	Vider_Archive();

if( (Archive=(Element*)malloc( sizeof(Element)*PAS_ARCHIVE )) == NULL )
	return( ERR_MEMOIRE_ARCHIVE );

Taille_Archive=PAS_ARCHIVE;
Nb_Fichier_Archive=0;

return( OK );
}



//---------------------------------------
int Ouvrir_Archive( int Mode, char *Com )
/* Ouvre le fichier Nom_Archive, lit la structure de fichier,
et la range dans Archive
Mode = Mode_Lecture: ouverture en lecture pour dcompression
Mode = Mode_Ecriture: ouverture( ou cration si inexistant) en criture (compression)
Mode = Mode_Listage: ouuverutre en lecture et affichage de la structure
			--> affiche seulement les fichiers correspondant  Com  (*.* ....) */
{
int i;
int temp;
int Taux;
unsigned long TNormalT=0;
unsigned long TCompressT=0;
Element El;

//** Ouverture  proprement parler
if( Mode == MODE_LECTURE || Mode == MODE_LISTAGE )
	{
   if( (Archive_Fich=fopen( Nom_Archive, "rb" )) == NULL )
   	return( ERR_OUVERTURE_ARCHIVE_R );
   }
else if( Mode == MODE_ECRITURE )
	{
   if( (Archive_Fich=fopen( Nom_Archive, "r+b" )) == NULL )
   	return( ERR_OUVERTURE_ARCHIVE_W );
   }

//** Lecture de l'entte
if( (fread(&Entete, 1, sizeof(Entete), Archive_Fich)) != sizeof(Entete) )
	return( ERR_LECTURE_ARCHIVE );
else
	{
   //** vrification du type avec l'identificateur
   if( Entete.Identificateur != BRLZ_IDENTIFICATEUR )
   	return( ERR_IDENTIFICATEUR );

   //** Initialisation du tableau Archive pour la structure du fichier archive
   if( (temp=Initialiser_Archive()) != OK )
   	return( temp );

   if( Mode == MODE_LISTAGE )
   	{
      AFFICHER_INFO();
      AFFICHER_SEPARATION();
      }

   //** Lecture de toutes les structuress relatives aux fichiers de l'archive
   for( i=0; i<Entete.Nb_Fichier; i++ )
   	{
      El.Position=(unsigned long)ftell( Archive_Fich );

      if( (fread(&El.Suivant, 1, sizeof( unsigned long)*3, Archive_Fich)) != sizeof( unsigned long)*3 )
			return( ERR_LECTURE_ARCHIVE );

      if( (fread(&El.L_Nom, 1, sizeof( unsigned char ), Archive_Fich)) != sizeof( unsigned char ) )
			return( ERR_LECTURE_ARCHIVE );

      if( (fread(&El.Nom, 1, El.L_Nom, Archive_Fich)) != El.L_Nom )
			return( ERR_LECTURE_ARCHIVE );
      El.Nom[El.L_Nom]='\0';

      if( (fread(&El.L_Rep, 1, sizeof( unsigned char ), Archive_Fich)) != sizeof( unsigned char ) )
			return( ERR_LECTURE_ARCHIVE );

      if( (fread(&El.Repertoire, 1, El.L_Rep, Archive_Fich)) != El.L_Rep )
			return( ERR_LECTURE_ARCHIVE );
      El.Repertoire[El.L_Rep]='\0';

      Ajouter_Fichier_Archive( &El );

      //** On passe au fichier suivant
      fseek( Archive_Fich, El.Suivant, SEEK_SET );

      //** affichage des informations si on est en mode listage
      if( Mode == MODE_LISTAGE && Identifier_Fichier( Com, Archive[Nb_Fichier_Archive-1].Nom)  )
      	{
         Taux=(int)(long)(((long)El.Taille_Normale-(long)El.Taille_Compressee)*100/(long)El.Taille_Normale);
         printf( "  %-13s  %9ld  %9ld  %3d%%  %s  %lu %lu\n", El.Nom, El.Taille_Normale, El.Taille_Compressee, Taux, El.Repertoire, El.Position, El.Suivant );

         TNormalT+=El.Taille_Normale;
         TCompressT+=El.Taille_Compressee;
         }
      }

   if( Mode == MODE_LISTAGE )
   	{
	   AFFICHER_SEPARATION();
      Taux=(int)(long)(((long)TNormalT-(long)TCompressT)*100/(long)TNormalT);
	   printf( " %  3d fichiers    %9ld  %9ld  %3d%%", Nb_Fichier_Archive, TNormalT, TCompressT, Taux );
      }
   Fin_Fichier=Archive[Nb_Fichier_Archive-1].Suivant;
   }

return( OK );
}

//------------------
void Syntaxe( void )
{
printf( "Syntaxe:   BRLZ [commande] [nom_archive] [nom(s)_fichier(s)]\n"
		  " commandes :\n"
        "   a: ajouter fichier(s)  l'archive.\n"
        "   r: ajouter fichier(s) avec sous rpertoire.\n"
        "   e: extraire fichier(s) de l'archive.\n"
        "   x: extraire fichier(s) avec respect sos rpertoire.\n"
        "   l: lister les fichiers de l'archive.\n" );
}



//----------------------------------------
int Ajouter_Fichier_Archive( Element *El )
{
Archive[Nb_Fichier_Archive].Suivant=El->Suivant;
Archive[Nb_Fichier_Archive].Taille_Compressee=El->Taille_Compressee;
Archive[Nb_Fichier_Archive].Taille_Normale=El->Taille_Normale;
Archive[Nb_Fichier_Archive].L_Nom=El->L_Nom;
Archive[Nb_Fichier_Archive].L_Rep=El->L_Rep;
Archive[Nb_Fichier_Archive].Position=El->Position;
strcpy( Archive[Nb_Fichier_Archive].Nom, El->Nom );
strcpy( Archive[Nb_Fichier_Archive].Repertoire, El->Repertoire );

Nb_Fichier_Archive++;

//** Reallocation de mmoire si le tableau est plein
if( Nb_Fichier_Archive >= Taille_Archive )
	{
   if( Nb_Fichier_Archive >= MAX_FICHIER_ARCHIVE )
   	return( ERR_ARCHIVE_PLEINE );

   Taille_Archive+=PAS_ARCHIVE;
   if( (Archive=(Element*)realloc( Archive, sizeof(Element)*Taille_Archive))==NULL )
   	return( ERR_REALLOC_ARCHIVE );
   }
return( OK);
}

//-----------------------------------------------------------
int Compresser_Recur( char *Nom_Fich, char *Rep, BOOL Recur )
{
DIR *Dir;
struct dirent *DirEnt;
struct stat statbuf;
int temp;
Element El;

//!!!!! Penser  la date et heures des fichiers
char *Rep2;
FILE* Fich;

if( (Rep2=(char*)malloc( 200 )) == NULL )
	return( 201 );


if( (Dir=opendir(Rep)) == NULL )
  	return( ERR_OPEN_DIR );

while( (DirEnt=readdir(Dir)) != NULL  )
  	{
   if( strcmp( DirEnt->d_name, "." ) & strcmp( DirEnt->d_name, ".." ) )
     	{
      sprintf( Rep2, "%s%s", Rep, DirEnt->d_name );
      if( stat( Rep2, &statbuf ) != 0)
        	{
         printf( "Problme fstat!!!!!!!!!!!!!!!!!\n" );
         printf( "Rep: %s", Rep2 );
         return( 500 );
         }
      //---- si l'entre de ce rpertoire en est un autre on appelle le fonction dessus
      if( (statbuf.st_mode & S_IFDIR) )
        	{
         if( Recur )
         	{
            temp=strlen(Rep2);
	         Rep2[temp]=CARAC_SEPARATION;
            Rep2[temp+1]='\0';
   	 	   Compresser_Recur( Nom_Fich, Rep2, TRUE );
            }
         }
      //---- sinon, c'est un fichier: on le compresse
	   else if( Identifier_Fichier( Nom_Fich, DirEnt->d_name ) )
        	{
         if( (Fich = fopen( Rep2, "rb" )) == NULL )
	       	{
   	     	printf( "Impossible d'ouvrir %s.\n", Rep2 );
	         return( ERR_OUVERTURE_FICHIER_R );
            }
	      if( !strcmp( Rep2, Nom_Archive) )
   	     	{
   	      }
	      else
   	     	{
				El.Position=ftell( Archive_Fich );
		      El.L_Nom=strlen( DirEnt->d_name );
	         strcpy( El.Nom, DirEnt->d_name );

	     	   El.L_Rep=strlen( Rep );
		      strcpy( El.Repertoire, Rep );

				if( (temp=Ajouter_Fichier_Archive( &El )) != OK )
   	   	  	{
	      	   printf( "COMP RECUR: erreur appel Ajouter_Fichier_Archive (ERR %d).\n", temp );
   	       	return( temp );
      	      }

				if( (temp=Ecrire_Element_Archive( Archive_Fich, Nb_Fichier_Archive-1 )) != OK )
   		     	{
      		   printf( "COMP RECUR: erreur appel Ecrire_Element (ERR %d).\n", temp );
         		return( temp );
	           	}
   	      Archive[Nb_Fichier_Archive-1].Taille_Normale=statbuf.st_size;

				if( (temp=Compresser( Fich, Archive_Fich, Archive[Nb_Fichier_Archive-1].Taille_Normale )) != OK )
   		     	{
	      	   printf( "COMP RECUR: erreur appel Compresser (ERR %d).\n", temp );
   	         return( temp );
      	     	}
	         Fin_Fichier=Archive[Nb_Fichier_Archive-1].Suivant=ftell( Archive_Fich );
				Archive[Nb_Fichier_Archive-1].Taille_Compressee=Archive[Nb_Fichier_Archive-1].Suivant-Archive[Nb_Fichier_Archive-1].Position;
      	   printf( "\r   %s :  %d%%   \n", Archive[Nb_Fichier_Archive-1].Nom, ((Archive[Nb_Fichier_Archive-1].Taille_Normale-Archive[Nb_Fichier_Archive-1].Taille_Compressee)*100/Archive[Nb_Fichier_Archive-1].Taille_Normale) );

	         if( (temp=Mise_A_Jour_Element( Archive_Fich, Nb_Fichier_Archive-1 )) != OK )
   	        	{
      	      printf( "COMP RECUR: erreur appel Mise_A_Jour_Element (ERR %d).\n", temp );
	            return( temp );
   	         }
   		   }
         fclose( Fich );
   	   }
      }
   }
free( Rep2 );
return( OK );
}


//-------------------------------------------
int Traiter_Commande( char *Com, BOOL Recur )
{
char *Ptr1, *Ptr2;
char Buf[256];
int temp;

Ptr2=Com;

#ifdef DOS
strupr( Com );
#endif

while( (Ptr1=strchr(Ptr2, CARAC_SEPARATION ))!=NULL )
   Ptr2=Ptr1+1;

strncpy( Buf, Com, (int)(Ptr2-Com) );
Buf[(int)(Ptr2-Com)]='\0';

if( (temp=Initialisation_Dico())!= OK )
	{
   printf( "TRAITER_COMMANDE  erreur appel Initialisation_Dico (ERR %d).\n", temp );
   return( temp );
   }

#ifdef UNIX
if( Buf == NULL || Buf[0]=='\0' )
	temp=Compresser_Recur( Ptr2, "./", Recur);
else
#endif
	temp=Compresser_Recur( Ptr2, Buf, Recur);
Effacer_Dico();
return(temp);
}






//------------------------------------------------------------
//--- Traitement de la ligne de commande pour l'extraction ---
int Traiter_Commande2( char *Com, BOOL Recur )
{
int i;
int temp;
FILE *Fich_Out;
char Nom[250];

#ifdef DOS
strupr( Com );
#endif

Initialisation_Dico_Decomp();


for( i=0; i<Nb_Fichier_Archive; i++ )
	{
   if( Identifier_Fichier( Com, Archive[i].Nom ) )
   	{
      if( Recur )
      	sprintf( Nom, "%s%s", Archive[i].Repertoire, Archive[i].Nom );
      else
      	sprintf( Nom, "%s", Archive[i].Nom );

      if( (Fich_Out=fopen( Nom, "rb" )) != NULL )
      	{
         char Touche;
         fclose( Fich_Out );
         printf( "Voulez vous remplacer le fichier %s (o/n) ?", Nom );
         while( 1==1 )
         	{
				Touche=getchar();

            if( Touche == 'o' || Touche == 'O' )
            	{
               printf( "\r" );
               if( (Fich_Out=fopen( Nom, "wb" )) == NULL )
               	{
                  printf( "Erreur cration de %s\n", Nom );
                  return( ERR_OUVERTURE_FICHIER_W );
                  }

               fseek( Archive_Fich, Archive[i].Position + Archive[i].L_Nom + Archive[i].L_Rep
         			+ sizeof(unsigned long)*3 + sizeof(unsigned char)*2, SEEK_SET );


               if( (temp=Decompresser( Archive_Fich, Fich_Out, Archive[i].Taille_Normale )) != OK )
               	{
                  printf( "Erreur appel Decomp (%d).\n", temp );
                  fclose( Fich_Out );
                  return( temp );
                  }
               fclose( Fich_Out );
               printf( "\r %s  Ok         \n", Archive[i].Nom );
               break;
               }
            else if( Touche == 'n' || Touche == 'N' )
            	{
              	printf( " Ok on touche pas\n" );
               break;
               }
            }
         }
      else
      	{
         if( (Fich_Out=fopen( Nom, "wb" )) == NULL )
           	{
            printf( "Erreur cration de %s\n", Nom );
            return( ERR_OUVERTURE_FICHIER_W );
            }

         fseek( Archive_Fich, Archive[i].Position + Archive[i].L_Nom + Archive[i].L_Rep
         			+ sizeof(unsigned long)*3 + sizeof(unsigned char)*2, SEEK_SET );

         if( (temp=Decompresser( Archive_Fich, Fich_Out, Archive[i].Taille_Normale )) != OK )
          	{
            printf( "Erreur appel Decomp (%d).\n", temp );
            fclose( Fich_Out );
            return( temp );
            }


			fclose( Fich_Out );
         printf( "\r %s  Ok         \n", Archive[i].Nom );
         }
      }
   }
Effacer_Dico_Decomp();
return( OK );
}



//-----------------------------------------
BOOL Identifier_Fichier( char *Com, char *Nom )
/* Vrifie si le fichier ni correspond  la ligne de commande Com
		--> prend en compte les * et ? */

{
int j, k;

//- Si rien n'est spcifi en ligne de commande
//-  cela quivaut alors  *.*
if( Com == NULL )
	return( TRUE );

#ifdef DOS
strupr( Com );
#endif

//-- Pour pouvoir utiliser les * sans que UNIX remplace par les fichiers du rpertoire
if( Com[0] == '=' )
	j=1;
else
	j=0;

for( k=0; ; j++,k++ )
 	{
   if( Com[j] != '?' )
     	{
      if( Com[j]=='\0' )
        	{
         if( Nom[k]=='\0' )
   			return( TRUE );
         else
         	return( FALSE );
         }
	   if( j>0 && Com[j-1]=='.' && Com[j]=='*' )
   		return( TRUE );

	   if( Com[j]=='.' && Com[j+1]=='\0' && Nom[k]=='\0' )
			return( TRUE );

	   if( Com[j]=='\0' && Nom[k]=='.' && Nom[k]=='\0' )
   	  	return( TRUE );

	   if( Com[j]=='.' && Com[j+1]=='*' )
   	   if( Nom[k] == '\0' || Nom[k] == '.' )
				return( TRUE );

	   if( Com[j] == '*' )
   	  	{
      	if( Com[j+1] == '\0' )
				return( TRUE );

	      while( Nom[k] != '.' && Nom[k] != '\0' )
   	     	k++;
	      k--;
   	   }
	   else if( Nom[k] != Com[j] )
			return( FALSE );
      }
   else
     	{
    	if( Nom[k] == '.' || Nom[k] == '\0' )
			return( FALSE );
      }
   }
}




/*******************************/
int main( int argc, char **argv )
{
int temp,i;
clock_t t1, t2;

AFFICHER_INVITE();

if( argc < 2 )
	{
   Syntaxe();
   return( ERR_SYNTAXE );
   }

if( argv[1][1]!='\0' )
	{
   //**** Afficher une archive : l
  	strcpy( Nom_Archive, argv[1] );
   if( (temp=Ouvrir_Archive(MODE_LISTAGE, argv[2] ))!=OK )
     	{
     	printf( "Ne peut ouvrir le fichier archive %s (ERR %d).\n", Nom_Archive, temp );
      return(temp);
      }
   fclose( Archive_Fich );
   }
else
	{
   if( argc < 3 )
   	{
      Syntaxe();
      return( ERR_SYNTAXE );
      }
  	strcpy( Nom_Archive, argv[2] );

   #ifdef DOS
   strupr( Nom_Archive );
   #endif

   switch( toupper(argv[1][0]) )
   	{
      case AJOUT_RECUR_CARAC:
      	Recursif=TRUE;

      case AJOUT_CARAC:
         if( (temp=Ouvrir_Archive(MODE_ECRITURE, NULL ))!=OK )
         	{
            if( temp == ERR_IDENTIFICATEUR )
            	{
               printf( "Le fichier %s n'est pas une archive BRLZ (ERR %d).\n", Nom_Archive, temp );
               return( temp );
               }
         	if( (temp=Creer_Archive())!=OK )
            	{
               printf( "Impossible de crer l'archive %s (ERR %d).\n", Nom_Archive, temp );
               return( temp );
               }
            }

         t1=clock();
         for( i=3; i<argc; i++ )
         	{
            fseek( Archive_Fich, Fin_Fichier, SEEK_SET );
	         if( (temp=Traiter_Commande( argv[i], Recursif )) != OK )
	         	{
   	         printf( "Erreur pendant la compression de(s) fichier(s)  (ERR %d).\n", temp );
      	      return( temp );
         	   }
	         Mise_A_Jour_Entete( Archive_Fich );
            }
         t2=clock();
         fclose( Archive_Fich );
         printf( "Temps coul: %.2f s (%d).\n", (float)((float)(t2-t1)/CLK_TCK), t2-t1 );
      	break;


	   case EXTRAIT_RECUR_CARAC:
   	   	Recursif=TRUE;

      case EXTRAIT_CARAC:
         if( (temp=Ouvrir_Archive(MODE_LECTURE, NULL))!=OK )
         	{
            printf( "Main: Erreur appel OUVRIR_ARCHIVE ( ERR %d ).\n", temp );
            return( temp );
            }
         fseek( Archive_Fich, Fin_Fichier, SEEK_SET );

         if( (temp=Traiter_Commande2( argv[3], Recursif )) != OK )
         	{
            printf( "Erreur pendant la compression de(s) fichier(s)  (ERR %d).\n", temp );
            return( temp );
            }
         fclose( Archive_Fich );
      	break;



      case LISTAGE_CARAC:
          if( (temp=Ouvrir_Archive(MODE_LISTAGE, argv[3] ))!=OK )
         	{
         	printf( "Ne peut ouvrir le fichier archive %s (ERR %d).\n", Nom_Archive, temp );
            return(temp);
            }
         fclose( Archive_Fich );
         break;

      default:
      	Syntaxe();
      }
   }
Vider_Archive();
return( OK );
}




