/*
   fich.cpp

   			opration d'entree/sortie dans les fichiers
*/
#define MODULE_FICH
#include <stdio.h>

#include "comp.h"

unsigned int Pos_Entree;
unsigned int Pos_Sortie;
unsigned int Taille_Entree;

int Nb_Bits_Ref;


unsigned char *Tampon_Entree=NULL;
unsigned char *Tampon_Sortie=NULL;
unsigned long Taille_Fichier;
unsigned long Nb_Tampon_Lu;

// variable de crire rfrence
unsigned char Oct_A_Ecrire=0;		/* L'octet que l'on prepare  l'criture */
unsigned char Bit_Actuel=0;			/* Bit de l'octet sur lequel on travaille */


//---------------------------------------
unsigned int Lire_Octet ( FILE *Fich_In )
{
if( Pos_Entree >= Taille_Entree )
	{
	if( !feof( Fich_In ) )
		{
		Taille_Entree = fread( Tampon_Entree, 1, BUFFER_ENTREE, Fich_In );
		if( Taille_Entree == 0 )
			return( CD_FIN_FICHIER );
		Pos_Entree = 0;
		Nb_Tampon_Lu++;
   	printf( "\r  avancement: %.d%%", (int)(Nb_Tampon_Lu*BUFFER_ENTREE*100/Taille_Fichier) );
		}
	else
		return( CD_FIN_FICHIER );
	}
Pos_Entree++;
return( Tampon_Entree[Pos_Entree-1] );
}


//------------------------------------------
unsigned int Lire_Reference( FILE *Fich_In )
{
static unsigned char Lu;				/* Dernier octet lu */
static unsigned char Bit_Actuel=8;		/*  Bit de l'octet en cours de traitement */

int i, bit, temp;
unsigned Reference;
BOOL Fin;

Reference = 0;
Fin = FALSE;

for( i=0; i<Nb_Bits_Ref; i++ )
	{
	if( Bit_Actuel == 8 || Taille_Entree==0 )
		{
		Bit_Actuel=0;
		if( (temp = Lire_Octet( Fich_In )) == CD_FIN_FICHIER )
			Fin=TRUE;
		else
			Lu=temp;
		}

	if( !Fin )
		{
		Reference <<=1;
		bit = Lu & 128;
		Lu <<=1;
		Bit_Actuel++;

		if( bit != 0 )
			Reference |= 1;
		}
	}

if( !Fin )
	return( Reference );
else
	return( CD_FIN_FICHIER );
}


//------------------------------------------------------------
int Ecrire_Reference( unsigned int Reference, FILE *Fich_Out )
{
int i;
for( i=Nb_Bits_Ref-1; i>=0; i-- )
	{
	Oct_A_Ecrire <<=1;
	if( Reference & (1 << i ) )
		Oct_A_Ecrire |=1;
	Bit_Actuel++;

	if( Bit_Actuel == 8 )
		{
		Bit_Actuel=0;
		Tampon_Sortie[Pos_Sortie]=Oct_A_Ecrire;
		Pos_Sortie++;

		if( Pos_Sortie >= BUFFER_SORTIE )
			{
			if( (fwrite( Tampon_Sortie, 1, BUFFER_SORTIE, Fich_Out )) != BUFFER_SORTIE )
         	return( ERR_ECRITURE_ARCHIVE );
			Pos_Sortie=0;
			}
		}
	}
return( OK );
}



//-----------------------------------------------------------------------
unsigned char Ecrire_Chaine( Element_Dico_Decomp *Noeud, FILE* Fich_Out )
{
unsigned char Carac;

if( Noeud->Precedent!=NULL )
	Carac=Ecrire_Chaine( Noeud->Precedent, Fich_Out );
else
	Carac=Noeud->Carac;

Tampon_Sortie[Pos_Sortie]=Noeud->Carac;
Pos_Sortie++;

if( Pos_Sortie >= BUFFER_SORTIE )
	{
	if( (fwrite( Tampon_Sortie, 1, BUFFER_SORTIE, Fich_Out )) != BUFFER_SORTIE )
   	{
      printf( "Erreur ECRIRE_CHAINE.\n" );
     	return( 0 );
      }
   Nb_Tampon_Lu++;
 	printf( "\r  avancement: %.d%%", (int)(Nb_Tampon_Lu*BUFFER_SORTIE*100/Taille_Fichier) );

	Pos_Sortie=0;
   }
return( Carac );
}
