/*
	decomp.cpp

   		fichier contenant le code du dcompresseur
     		( pour des questions d'optimisation (en vitesse) le code du dcompresseur
          est diffrent de celui du compresseur: organisation du dico diffrente )
*/

#define MODULE_DECOMP

//---- Les fichiers entte -----
#include <stdio.h>
#include <stdlib.h>

#include "comp.h"

//----- Les variables globales -----
Element_Dico_Decomp **DicoD=NULL;
int Pos_DicoD;

//----- Les variables externes -----
extern int Nb_Bits_Ref;
extern unsigned char *Tampon_Entree;
extern unsigned char *Tampon_Sortie;
extern unsigned int Pos_Entree;
extern unsigned int Pos_Sortie;
extern unsigned int Taille_Entree;
extern unsigned long Taille_Fichier;
extern unsigned long Nb_Tampon_Lu;


//------------------------------------
int Initialisation_Dico_Decomp( void )
{
unsigned int i;
//- Cration du dictionnaire
if( (DicoD=(Element_Dico_Decomp**)malloc( sizeof(Element_Dico_Decomp*)*MAX_DICO )) == NULL )
  	return( ERR_CREATION_DICO_DECOMP );

//- Initialisation de chaque cellule
for( i=0; i<256; i++ )
	{
   if( (DicoD[i]=(Element_Dico_Decomp*)malloc( sizeof( Element_Dico_Decomp))) == NULL )
   	{
      while(i) { i--; free( DicoD[i] ); }
   	return( ERR_MEMOIRE_DICO );
      }
   DicoD[i]->Carac=(unsigned char)i;
   DicoD[i]->Val=(unsigned)i;
   DicoD[i]->Precedent=NULL;
   }

for( ;i<MAX_DICO; i++ )
	DicoD[i]=NULL;

Pos_DicoD=DEBUT_DICO;
Nb_Bits_Ref=9;

//- Initialisation des tampons d'entre et de sortie
if( (Tampon_Entree=(unsigned char*)malloc( BUFFER_ENTREE )) == NULL )
    return( ERR_MEMOIRE_T_ENTREE );
Pos_Entree=0;
Taille_Entree=0;

if( (Tampon_Sortie=(unsigned char*)malloc( BUFFER_SORTIE )) == NULL )
    return( ERR_MEMOIRE_T_SORTIE );
Pos_Sortie=0;

return( OK );
}


//---------------------------------------
void Reinitialisation_Dico_Decomp( void )
{
Pos_DicoD=DEBUT_DICO;
Nb_Bits_Ref=9;
}

//------------------------------
void Effacer_Dico_Decomp( void )
{
int i;
if( DicoD != NULL )
	{
	for( i=0; i<MAX_DICO; i++ )
      if( DicoD[i] != NULL )
      	{
			free( DicoD[i] );
   	   DicoD[i]=NULL;
         }
	free( DicoD );
   DicoD=NULL;
   }

if( Tampon_Entree != NULL )
   {
	free( Tampon_Entree );
   Tampon_Entree=NULL;
   }

if( Tampon_Sortie != NULL )
   {
	free( Tampon_Sortie );
   Tampon_Sortie=NULL;
   }
}

//-----------------------------------------------------------------------------
int Ajouter_Noeud_Decomp( Element_Dico_Decomp *N_Courant, unsigned char Carac )
{

if( DicoD[Pos_DicoD] == NULL )
	if( (DicoD[Pos_DicoD]=(Element_Dico_Decomp*)malloc( sizeof(Element_Dico_Decomp) )) == NULL )
   	return( ERR_MEMOIRE_DICO );

DicoD[Pos_DicoD]->Val=(unsigned)Pos_DicoD;
DicoD[Pos_DicoD]->Carac=Carac;
DicoD[Pos_DicoD]->Precedent=N_Courant;

Pos_DicoD++;

return( OK );
}


//---------------------------------------------------------------
int Decompresser( FILE *Fich_In, FILE *Fich_Out, unsigned long Taille )
{
unsigned int Ref;
unsigned int Ancien_Ref;
unsigned int Carac;

//- Partie initialisation de l'algorithme
Reinitialisation_Dico_Decomp();
Pos_Entree=0;
Pos_Sortie=0;
Taille_Entree=0;

Taille_Fichier=Taille;
Nb_Tampon_Lu=0;


Ref=Lire_Reference(Fich_In);
//printf( "Premire rference: %d", Ref );
Carac=Ecrire_Chaine( DicoD[Ref], Fich_Out );
while( 1==1 )
	{
 	Ancien_Ref=Ref;
   Ref=Lire_Reference(Fich_In);
   if( Ref == CD_INIT_DICO )
   	{
      Reinitialisation_Dico_Decomp();
      Ref=Lire_Reference(Fich_In);
		Carac=Ecrire_Chaine( DicoD[Ref], Fich_Out );
      }
	else  if( Ref == CD_FIN_FICHIER )
   	{
      break;
      }
   else if( Ref == CD_AJOUTER_BIT )
   	{
      Nb_Bits_Ref++;
      Ref=Ancien_Ref;
      }
   else
   	{
      if( Ref >= Pos_DicoD )
      	{
	      printf( "!" );
         }
      else
      	{
		  	Carac=Ecrire_Chaine( DicoD[Ref], Fich_Out );
        	Ajouter_Noeud_Decomp( DicoD[Ancien_Ref], Carac );
         }
      }
   }

//-- On vide le tampon de sortie --
if( Pos_Sortie > 0 )
	fwrite( Tampon_Sortie, 1, Pos_Sortie, Fich_Out );

return( OK );
}


