/**

	COMP.H

   		fichier entte utiliser par les modules de compression
         ( COMP.C DECOMP.C et FICH.C )

**/


/*** Les constantes ***/
	/*** Correspondances compresseur dcompresseur ***/
	#define DEBUT_DICO					260			//- premiere indice du dictinnaire
   #define MAX_DICO					  4096			//- Nombre maximum d'entre dans le dico	
	#define CD_FIN_FICHIER				256			//- code : fin du fichier en cours
	#define CD_NOUVEAU_FICHIER			257			//-		  nouveau fichier
   #define CD_INIT_DICO					258			//-        il faut rinitialiser le dico
   #define CD_AJOUTER_BIT				259			//-        les rfrences prennent 1 bit de plus


   /*** Constantes plus gnrales ***/
   #define BUFFER_ENTREE				8192        //- Taille des buffers d'entre
   #define BUFFER_SORTIE            8192        //-             et de sortie pour la (d)compression


/*** Les constantes correspondant aux erreurs ***/
#define OK									  1
#define ERR_OUVERTURE_ARCHIVE_R		101
#define ERR_OUVERTURE_ARCHIVE_W     102
#define ERR_LECTURE_ARCHIVE         103
#define ERR_IDENTIFICATEUR          104
#define ERR_MEMOIRE_ARCHIVE			105
#define ERR_ECRITURE_ARCHIVE			106
#define ERR_REALLOC_ARCHIVE			107
#define ERR_ARCHIVE_PLEINE				108
#define ERR_SYNTAXE						109
#define ERR_OUVERTURE_FICHIER_R		110
#define ERR_OUVERTURE_FICHIER_W		111
#define ERR_CREATION_DICO				112
#define ERR_CREATION_DICO_DECOMP		113
#define ERR_MEMOIRE_DICO				114
#define ERR_MEMOIRE_T_ENTREE			115
#define ERR_MEMOIRE_T_SORTIE			116
#define ERR_FIN_INATTENDUE				117





/*** Dfintions des diffrents types de donnes utiliss ***/
	//- Structure des lements de l'arbre dictionnaire
typedef struct S_Element_Dico {
		unsigned char Carac;
      unsigned int Val;
      struct S_Element_Dico *Frere;
      struct S_Element_Dico *Fils;
      } Element_Dico;

typedef struct S_Element_Dico_Decomp {
		unsigned char Carac;
      unsigned int Val;
      struct S_Element_Dico_Decomp *Precedent;
      } Element_Dico_Decomp;

typedef char BOOL;
#define TRUE	1
#define FALSE	0



//*** Les prototypes de fonctions
	//*** module compression
int Ajouter_Noeud( Element_Dico *N_Courant, unsigned char Carac );
void Reinitialisation_Dico( void );
Element_Dico *Chercher_Dico( Element_Dico *N_Courant, unsigned char Carac );

	//*** module decompression
int Ajouter_Noeud_Decomp( Element_Dico_Decomp *N_Courant, unsigned char Carac );
void Reinitialisation_Dico_Decomp( void );

	//*** module In/OUT
unsigned int Lire_Octet ( FILE *Fich_In );
unsigned int Lire_Reference( FILE *Fich_In );
int Ecrire_Reference( unsigned int Reference, FILE *Fich_Out );
unsigned char Ecrire_Chaine( Element_Dico_Decomp *Noeud, FILE* Fich_Out );
