//#define DEBUG

/*

	Comp.cpp
   				Fichier contenant le code du compresseur
     		( pour des questions d'optimisation (en vitesse) le code du dcompresseur
          est diffrent de celui du compresseur: organisation du dico diffrente )

*/


//---- Les fichiers entte -----
#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>

#include "COMP.H"

//----- Les variables globales -----
Element_Dico **Dico=NULL;
int Pos_Dico;

//----- Les variables externes
extern int Nb_Bits_Ref;
extern unsigned char *Tampon_Entree;
extern unsigned char *Tampon_Sortie;
extern unsigned int Pos_Entree;
extern unsigned int Pos_Sortie;
extern unsigned int Taille_Entree;
extern unsigned long Taille_Fichier;
extern unsigned long Nb_Tampon_Lu;
extern unsigned char Oct_A_Ecrire;
extern unsigned char Bit_Actuel;



//-----------------------------
int Initialisation_Dico( void )
{
unsigned int i;
//- Cration du dictionnaire
if( (Dico=(Element_Dico**)malloc( sizeof(Element_Dico*)*MAX_DICO )) == NULL )
  	return( ERR_CREATION_DICO );

//- Initialisation de chaque cellule
for( i=0; i<256; i++ )
	{
   if( (Dico[i]=(Element_Dico*)malloc( sizeof( Element_Dico))) == NULL )
   	{
      while(i) { i--; free( Dico[i] ); }
   	return( ERR_MEMOIRE_DICO );
      }
   Dico[i]->Carac=(unsigned char)i;
   Dico[i]->Val=(unsigned)i;
   Dico[i]->Fils=NULL;
   Dico[i]->Frere=NULL;
   }

for( ;i<MAX_DICO; i++ )
	Dico[i]=NULL;

Pos_Dico=DEBUT_DICO;
Nb_Bits_Ref=9;

//- Initialisation des tampons d'entre et de sortie
if( (Tampon_Entree=(unsigned char*)malloc( BUFFER_ENTREE )) == NULL )
    return( ERR_MEMOIRE_T_ENTREE );
Pos_Entree=0;
Taille_Entree=0;

if( (Tampon_Sortie=(unsigned char*)malloc( BUFFER_SORTIE )) == NULL )
    return( ERR_MEMOIRE_T_SORTIE );
Pos_Sortie=0;

return( OK );
}


//--------------------------------
void Reinitialisation_Dico( void )
{
int i;
for( i=0; i<MAX_DICO; i++ )
	if( Dico[i] != NULL )
   	{
		Dico[i]->Frere=NULL;
   	Dico[i]->Fils=NULL;
	   }
Pos_Dico=DEBUT_DICO;
Nb_Bits_Ref=9;
}

//-----------------------
void Effacer_Dico( void )
{
int i;

if( Dico != NULL )
	{
	for( i=0; i<MAX_DICO; i++ )
      if( Dico[i] != NULL )
      	{
			free( Dico[i] );
   	   Dico[i]=NULL;
         }
	free( Dico );
   Dico=NULL;
   }

if( Tampon_Entree != NULL )
   {
	free( Tampon_Entree );
   Tampon_Entree=NULL;
   }

if( Tampon_Sortie != NULL )
   {
	free( Tampon_Sortie );
   Tampon_Sortie=NULL;
   }

}

//---------------------------------------------------------------
int Ajouter_Noeud( Element_Dico *N_Courant, unsigned char Carac )
{

if( Dico[Pos_Dico] == NULL )
	if( (Dico[Pos_Dico]=(Element_Dico*)malloc( sizeof(Element_Dico) )) == NULL )
   	return( ERR_MEMOIRE_DICO );

Dico[Pos_Dico]->Val=(unsigned)Pos_Dico;
Dico[Pos_Dico]->Carac=Carac;
Dico[Pos_Dico]->Frere=N_Courant->Fils;
Dico[Pos_Dico]->Fils=NULL;
N_Courant->Fils=Dico[Pos_Dico];

Pos_Dico++;

return( OK );
}



//-------------------------------------------------------------------------
Element_Dico *Chercher_Dico( Element_Dico *N_Courant, unsigned char Carac )
{
Element_Dico *El;

El=N_Courant->Fils;

while( El != NULL )
	{
   if( El->Carac == Carac )
   	{
// ????????????????????????,
// Ajouter la prise en compte de l'exeption

      if( El->Val == Pos_Dico-1 )
      	{
      	return( NULL );
         }
      else
	   	return( El );
      }
   El=El->Frere;
   }
return( NULL );
}



//-------------------------------------------------------------------
int Compresser( FILE* Fich_In, FILE* Fich_Out, unsigned long Taille )
{
Element_Dico *TempD;
unsigned int Carac;
Element_Dico *LatentD;
BOOL Fin;


//- Partie initialisation de l'algorithme
Reinitialisation_Dico();
Pos_Entree=0;
Pos_Sortie=0;
Taille_Entree=0;
Oct_A_Ecrire=0;
Bit_Actuel=0;

Taille_Fichier=Taille;
Nb_Tampon_Lu=0;

//- Le premier caractre lu forme la chaine latente.
if( (Carac = Lire_Octet(Fich_In)) < 256 )
	{
	LatentD = Dico[Carac];
   Fin=FALSE;
   }
else
	Fin=TRUE;

//- Debut de la boucle de l'algorithme:
while( !Fin )
	{
	//- On lit un caractre ...
   if( (Carac=Lire_Octet(Fich_In)) != CD_FIN_FICHIER )
   	{
      //-  ... si la nouvelle chaine forme n'est pas dans le dico
      if( (TempD=Chercher_Dico(LatentD, (unsigned char)Carac))==NULL )
      	{
         //- ... on crit la rfrence de l'ancienne
         if( Ecrire_Reference( LatentD->Val, Fich_Out ) != OK )
            return( ERR_ECRITURE_ARCHIVE );

      	//- ... si le dico est satur, on le vide
         if( Pos_Dico >= MAX_DICO )
         	{
            if( Ecrire_Reference( CD_INIT_DICO, Fich_Out ) != OK )
         	   return( ERR_ECRITURE_ARCHIVE );
            Reinitialisation_Dico();
            }
         else
         	{
	         //- ... sinon ajoute la nouvelle chaine au dico
				if( Ajouter_Noeud( LatentD, (unsigned char)Carac ) != OK )
         	   return( ERR_MEMOIRE_DICO );
            }

         //- ... on vrifie que le nombre de bit est toujours suffisant pour le nombre de rfrence
         if( Pos_Dico >= (1<<Nb_Bits_Ref) )
         	{
            if( Ecrire_Reference( CD_AJOUTER_BIT, Fich_Out ) != OK )
            	return( ERR_ECRITURE_ARCHIVE );
         	Nb_Bits_Ref++;
            }

			//- ... et la chaine latente devient le dernier caractre lu.
	      LatentD=Dico[Carac];
         }
		//- Si la nouvelle chaine appartient au dico alors
      else
      	//- elle devient l'ancienne chaine latente
      	LatentD=TempD;
      }
   else
   	Fin=TRUE;
   }

//- On vide ensuite le tampon de sortie
if( Taille !=  0 )
	{
   Ecrire_Reference( LatentD->Val, Fich_Out );
	Ecrire_Reference( CD_FIN_FICHIER, Fich_Out );   // On l'crit 2 fois pour tre sur
 	Ecrire_Reference( CD_FIN_FICHIER, Fich_Out );	// que au moins 1 des deux sera ecrit toytalement

	fwrite( Tampon_Sortie, 1, Pos_Sortie, Fich_Out );
   }

return( OK );
}

