@rem disk1 is read-only, has a copy of \BIN\ (no REN - to avoid LFN conflicts).
@rem disk2 is large, all archives, *.tst and *.dir files are created there.
@rem All archivers and DO_*.BATs are in one of the %path% directories.

@set disk1=c:\bi2
@set disk2=d:
@set dir0=\BIN\
@set dir1=%dir0%astronmy\
@set dir2=%dir0%chem\
@set dir3=%dir0%font\
@set dir4=%dir0%graphics\
@set dir5=%dir0%lang\
@set dir6=%dir0%mapping\
@set dir7=%dir0%proj\
@set dir8=%dir0%science\
@set dir9=%dir0%winhelp\
@set dira=%dir0%xwindows\

%disk2%
@cd %dir0%
@if "%1"=="" goto main
@if "%2"=="" goto DIRnDEL
@if "%3"=="" goto RENAME
@if not "%8"=="" goto COMPRESS

@rem         If seven parameters given - EXTRACT process starts
:EXTRACT
call %0 %1 %2 %3 %4 %5 %6 %7 -
fc/b %dir1%*.bin %disk1%%dir1%*.bin >>!_%6.tst
fc/b %dir2%*.bin %disk1%%dir2%*.bin >>!_%6.tst
fc/b %dir3%*.bin %disk1%%dir3%*.bin >>!_%6.tst
fc/b %dir4%*.bin %disk1%%dir4%*.bin >>!_%6.tst
fc/b %dir5%*.bin %disk1%%dir5%*.bin >>!_%6.tst
fc/b %dir6%*.bin %disk1%%dir6%*.bin >>!_%6.tst
fc/b %dir7%*.bin %disk1%%dir7%*.bin >>!_%6.tst
fc/b %dir8%*.bin %disk1%%dir8%*.bin >>!_%6.tst
fc/b %dir9%*.bin %disk1%%dir9%*.bin >>!_%6.tst
fc/b %dira%*.bin %disk1%%dira%*.bin >>!_%6.tst
call %0 bin
@goto end

@rem         If two parameters given - RENAME process starts
:RENAME
ren %dir1%*.%1 *.%2
ren %dir2%*.%1 *.%2
ren %dir3%*.%1 *.%2
ren %dir4%*.%1 *.%2
ren %dir5%*.%1 *.%2
ren %dir6%*.%1 *.%2
ren %dir7%*.%1 *.%2
ren %dir8%*.%1 *.%2
ren %dir9%*.%1 *.%2
ren %dira%*.%1 *.%2
@goto end

@rem         If one parameter given - DIR'n'DEL process starts
:DIRnDEL
dir /s/on %dir3%*.%1 >>!_%1.dir
dir /s/on %dira%*.%1 >>!_%1.dir
dir /s/on %dir0%*.%1 >>!_%1.dir
del %dir1%*.%1
del %dir2%*.%1
del %dir3%*.%1
del %dir4%*.%1
del %dir5%*.%1
del %dir6%*.%1
del %dir7%*.%1
del %dir8%*.%1
del %dir9%*.%1
del %dira%*.%1
@goto end



@rem         If no parameters given - MAIN process starts
:main
@goto cont6
@rem       %1    %2   %p3% %p4% %p5%   %p6%     %p7%  %8  %9

:cont3
call %0  imp98     a   -2   -s4  -mm   .im2     .bin -
call %0   szip    -o10 -b41 -    -     .bin     .s10 -
call %0   szip    -o0  -b41 -    -     .bin     .sz0 -
call %0   ba      -k   -50  -j   -     .bin     .bin.ba bin.ba bin.baj
call %0   ba      -k   -50  -    -     .bin     .bin.ba  -
call %0 bin
call %0 call do_xtrct imp98 e    -     .im2     .bin
call %0   szip    -d   -    -    -     .s10     .bin
call %0   szip    -d   -    -    -     .sz0     .bin
call %0   ba      -dk  -    -    -     .bin.baj .bin
call %0   ba      -dk  -    -    -     .bin.ba  .bin
goto end

:cont4
call %0 call  do_777  777  -mu32 -mg   .777     .bin -
call %0   dc     e  -       -    -     .bin     .dc0 -
call %0   dc     e  -b16300 -mb5 -     .bin     .dc5 -
call %0   rk    -mx3 -B9000 -    -     .rk4     .bin -
call %0   rk    -mx3   -    -    -     .rk3     .bin -
call %0   boa    -m15  -    -    -     .b58     .bin -
call %0   arh      a   -1   -2   -mm   .lg3     .bin -
call %0 bin
call %0 call do_xtrct boa  -x    -     .b58     .bin
call %0 call do_xtrct arh   x    -     .lg3     .bin
call %0 call do_xtrct 777   x    -     .777     .bin
call %0   rk     -x    -    -    -     .rk4     .bin
call %0   rk     -x    -    -    -     .rk3     .bin
call %0   dc      x    -    -    -     .dc0     .bin
call %0   dc      x    -    -    -     .dc5     .bin
goto end

:cont2
call %0  pkzip   -exx  -    -    -     .pkz     .bin -
call %0  imp98     a   -1   -m3  -mm   .im1     .bin -
call %0  bix       a  -m9 -mdg   -     .bx9     .bin -
call %0 bin
call %0 call do_xtrct pkunzip -e -     .pkz     .bin
call %0 call do_xtrct imp98 e    -     .im1     .bin
call %0 call do_xtrct  bix  x    -     .bx9     .bin
goto end



@rem ARTest-23

call %0   ace32   a   -m5 -d4096 -std  .ace     .bin -
call %0   zzip    a   -mx  -30m  -a    .zz      .bin -
call %0 bin
call %0 call do_xtrct ace32 x    -     .ace     .bin
call %0   zzip    x    -    -    -     .zz      .bin

call %0 eri       a   -a    -m3  -     .e51     .bin -
call %0 eri       a   -a    -    -     .n51     .bin -
call %0 qlfc      a   -     -    -     .gq      .bin -
call %0 bin
call %0 eri       x   -a    -    -     .e51     .bin
call %0 eri       x   -a    -    -     .n51     .bin
call %0 call do_xtrct qlfc  x    -     .gq      .bin

call %0  7za      a   -tzip -mx  -     .7zi     .bin -
call %0  gcac     a   -     -    -     .gca     .bin -
call %0 bin
call %0 call do_xtrct gcac  e    -     .gca     .bin
call %0 call do_xtrct 7za   x    -     .7zi     .bin



@rem ARTest-24

call %0 call ery-e     b   o16   -     -        .bin enb e16
call %0 call ery-e     b   o32   -     -        .bin enb e32
call %0 call ery-e     b   o64   -     -        .bin enb e64
call %0 call ery-e     b   o128  -     -        .bin enb e80
call %0 bin
call %0 call ery-d     b    -    -     .e16     .bin
call %0 call ery-d     b    -    -     .e32     .bin
call %0 call ery-d     b    -    -     .e64     .bin

call %0 ppmonstr  e  -o32  -m250 -     .bin     .pmm pmm o32
call %0 ppmonstr  e  -o64  -m250 -     .bin     .pmm pmm o64
call %0 ppmonstr  e  -o128 -m250 -     .bin     .pmm pmm o80
call %0 bin
call %0 call do_xtrct ppmonstr d -     .o80     .bin
call %0 call do_xtrct ppmonstr d -     .o64     .bin
call %0 call do_xtrct ppmonstr d -     .o32     .bin

call %0 ppmd      e  -o16  -m250 -     .bin     .pmd pmd d16
call %0  bzip2    -k   -9   -    -     .bin     .bin.bz2 -
call %0 bin
call %0   bzip2   -dk  -    -    -     .bin.bz2 .bin
call %0 call do_xtrct ppmd     d -     .d16     .bin

call %0 ppmy     /o9 /m220  -    -     .bin     .pmy -
call %0 compcl    c  -b15   -    -      -       .bin -
call %0 ppmn_km   e  -o9   -m:50 -     .bin     .pmn -
call %0 bin
call %0 ppmn_km   d    -    -    -     .pmn     .bin
call %0 call do_xtrct compcl e   -     .car     .bin
call %0 call do_xtrct ppmy_d -   -     .pmy     .bin

call %0  sbc      c   -m3  -b63  -     .sb3     .bin -
call %0  sbc      c   -m3  -b63  -ad   .sba     .bin -
call %0  sbc      c   -m2  -b63  -     .sb2     .bin -
call %0 bin
call %0 call do_xtrct sbc   x    -     .sb3     .bin
call %0 call do_xtrct sbc   x    -     .sba     .bin
call %0 call do_xtrct sbc   x    -     .sb2     .bin




@rem ARTest-25

call %0  ybs_d  -m16mu -    -    -     .ybd     .bin -
call %0  ybs    -m16mu -    -    -     .y16     .bin -
call %0  ybs    -m16mu -r   -    -     .ybr     .bin -
call %0 bin
call %0 call do_xtrct ybs   -d   -     .ybr     .bin
call %0 call do_xtrct ybs   -d   -     .y16     .bin
call %0 call do_xtrct ybs_d -d   -     .ybd     .bin

call %0 slim      a  -d32  -w22  -     -        .bin -
call %0 call do_xtrct paq1  -    -     .paq     .bin -
call %0 bin
call %0 call do_xtrct slim  x    -     .fb      .bin
call %0 call paqxtrct paq1  -    -     .paq     .bin

call %0 call do_xtrct abc13 -c   -     .bin     .bin abc ab1
call %0 call do_xtrct abc24 -c   -     .bin     .bin abc ab2
call %0 call 7z_bcj2 LZMA   d   16m    .7zl     .bin -
call %0 call 7z_bcj2 PPMD   o   32     .7zp     .bin -
call %0 bin
call %0 call do_xtrct 7za   x    -     .7zp     .bin
call %0 call do_xtrct 7za   x    -     .7zl     .bin
call %0 call abcxtrct abc13 -e   -     .ab1     .bin
call %0 call abcxtrct abc24 -e   -     .ab2     .bin

call %0 ppmy70  /o16 /m220  -    -     .bin     .pmy -
call %0  rar      a   -m5 -mc16:128t - .rax     .bin -
call %0  rar      a   -m5 -mc63:128t - .rxx     .bin -
call %0 bin
call %0 call do_xtrct rar   x    -     .rax     .bin
call %0 call do_xtrct rar   x    -     .rxx     .bin
call %0 call do_xtrct ppmy70_d - -     .pmy     .bin

call %0 call epm-m240 epm7  c    -     .bin     .ep7 -
call %0 call epm-m240 epm7  c024 -     .bin     .e24 -
call %0 call epm-m240 epm7  c032 -     .bin     .e32 -
call %0 call epm-m240 epm7  c048 -     .bin     .e48 -
call %0 call epm-m240 epm7  c064 -     .bin     .e64 -
call %0 bin
call %0 call epm-m240 epm7  d    -     .ep7     .bin
call %0 call epm-m240 epm7  d032 -     .e32     .bin
call %0 call epm-m240 epm7  d064 -     .e64     .bin

call %0  bee      a  -m3   -d9   -      -       .bin -
call %0 call do_xtrct paq1sse -  -     .paq     .bin -
call %0  uharc    a -md32768 -mx -     .uhx     .bin -
call %0 bin
call %0 call do_xtrct uharc x    -     .uhx     .bin
call %0 call paqxtrct paq1sse -  -     .paq     .bin
call %0  bee      x   -    -     -     .bee     .bin


call %0 durilca   e  -o32  -m230 -t3   .bin     .dur dur du3
call %0 durilca   e  -o32  -m230 -t1   .bin     .dur dur du1
call %0 bin
call %0 call do_xtrct durilca  d -     .du3     .bin
call %0 call do_xtrct durilca  d -     .du1     .bin


@rem ARTest-26
call %0 call uhb30.bat  e    -m3 -     .bin     .uh3 -
call %0 call uhb30.bat  e    -m2 -     .bin     .uh2 -
call %0 call uhb30.bat  e    -m1 -     .bin     .uh1 -
call %0 bin
call %0  uhbc   d   -       -    -     .uh3     .bin
call %0  uhbc   d   -       -    -     .uh2     .bin
call %0  uhbc   d   -       -    -     .uh1     .bin






call %0 durilca   e  -o32  -m230 -t3   .bin     .dur dur du3
call %0 durilca   e  -o32  -m230 -t1   .bin     .dur dur du1
call %0 durilca   e  -o32  -m230 -     .bin     .dur dur du0
call %0 call d13.bat -o32  -m230 -     .bin     .dur dur d13
call %0 bin
call %0 call do_xtrct durilca  d -     .du3     .bin
call %0 call do_xtrct durilca  d -     .du1     .bin
call %0 call do_xtrct durilca  d -     .du0     .bin
call %0 call do_xtrct durilca  d -     .d13     .bin


call %0 call d13.bat -o16  -m230 -     .bin     .dur dur d16
call %0 call d13.bat -o64  -m230 -     .bin     .dur dur d64
call %0 call d13.bat -o128 -m230 -     .bin     .dur dur d99


call %0  bee      a  -m3   -d6   -      -       .bin -
call %0 call do_xtrct paq4v2 -   -     .paq     .bin -
call %0 bin
call %0  bee      x   -     -    -     .bee     .bin
call %0 call paqxtrct paq4v2 -   -     .paq     .bin



call %0 ash     /o16 /m220 /s128 -     .bin     .ash -
call %0 ash     /o16 /m220 /s255 -     .bin     .aff -
call %0 bin
call %0 ash     /d   -      -    -     .aff     .bin


call %0 call d14.bat -o64  -m230 -     .bin     .dur dur t14
call %0 call d16.bat -o64  -m230 -     .bin     .dur dur t16
call %0 ash     /o16 /m220 /s64  -     .bin     .a40 -
call %0 ash     /o16 /m220 /s32  -     .bin     .a20 -
call %0 ash     /o16 /m220 /s16  -     .bin     .a10 -
call %0 ash     /o16 /m220 /s8   -     .bin     .a08 -


call %0 ash     /o16 /m220 /s12  -     .bin     .a12 -
call %0 ash     /o16 /m220 /s24  -     .bin     .a24 -
call %0 bin
call %0 ash     /d   -      -    -     .a24     .bin


call %0 call 7z_bcj2 LZMA   d   16m    .7zl     .bin -
call %0 call 7z_bcj2 PPMD   o   32     .7zp     .bin -
call %0 bin
call %0 call do_xtrct 7za   x    -     .7zp     .bin
call %0 call do_xtrct 7za   x    -     .7zl     .bin



call %0 call grzip2.bat  e -m1    -    .bin     .gr1 -
call %0 call grzip2.bat  e -m1S   -    .bin     .g1s -
call %0 call grzip2.bat  e -m2    -    .bin     .gr2 -
call %0 call grzip2.bat  e -m3    -    .bin     .gr3 -
call %0 bin
call %0 GRzipII   d   -     -    -     .gr1     .bin
call %0 GRzipII   d   -     -    -     .g1s     .bin
call %0 GRzipII   d   -     -    -     .gr2     .bin
call %0 GRzipII   d   -     -    -     .gr3     .bin


call %0 call grzip3.bat e -m4    -     .bin     .gr4 -
call %0 call grzip2.bat e -d     -     .bin     .grd -
call %0 call grzip2.bat e -l     -     .bin     .grl -
call %0 call grzip2.bat e -p     -     .bin     .grp -
call %0 bin
call %0 GRzipII   d   -     -    -     .gr4     .bin
call %0 GRzipII   d   -     -    -     .grd     .bin
call %0 GRzipII   d   -     -    -     .grl     .bin
call %0 GRzipII   d   -     -    -     .grp     .bin


call %0 ash     /o16 /m220 /s16  -     .bin     .a16 -
call %0 ash     /o32 /m220 /s16  -     .bin     .a32 -
call %0 bin
call %0 ash     /d   -      -    -     .a16     .bin
call %0 ash     /d   -      -    -     .a32     .bin

call %0  rar      a   -m5 -mc16:128t - .rax     .bin -
call %0 call 7z_bcj2 LZMA   d   16m    .7zl     .bin -
call %0 call 7z_bcj2 PPMD   o   32     .7zp     .bin -
call %0 bin
call %0 call do_xtrct 7za   x    -     .7zl     .bin
call %0 call do_xtrct 7za   x    -     .7zp     .bin
call %0 call do_xtrct rar   x    -     .rax     .bin



call %0 paq6b -6      -      -   -     .paq     .bin -
call %0 bin
call %0 call paqxtrct paq6b  -   -     .paq     .bin

:cont6
call %0 slim      a  -d32  -w22  -     -        .bin -
call %0 bin
call %0 call do_xtrct slim  x    -     .fb      .bin
goto end



@rem         If more than seven parameters given - COMPRESS process starts
:COMPRESS
@set p3=%3
@set p4=%4
@set p5=%5
@set p6=%6
@set p7=%7
@if "%3"=="-" set p3=
@if "%4"=="-" set p4=
@if "%5"=="-" set p5=
@if "%6"=="-" set p6=
@if "%7"=="-" set p7=
@if "%1"=="rk" goto lfname
@if "%1"=="boa" goto lfname
@if "%3"=="777" goto lfname
@if "%3"=="abc1" goto lfname
@if "%3"=="abc2" goto lfname
@if "%1"=="slim" goto lfname
@if "%3"=="slim" goto lfname
@if "%1"=="ppmd" goto lfname
@if "%3"=="ppmd" goto lfname
@if "%1"=="ppmonstr" goto lfname
@if "%3"=="ppmonstr" goto lfname
@if "%1"=="durilca" goto lfname
@if "%3"=="durilca" goto lfname
@if "%2"=="d13.bat" goto lfname
@if "%2"=="d14.bat" goto lfname
@if "%2"=="d16.bat" goto lfname

cd %dir1%

%1 %2 %p3% %p4% %p5% ___IBM~1%p6%       ___IBM~1%p7%
@rem abort if something is wrong
@rem if not exist ___IBM~1%p6% goto finish
@rem if not exist ___IBM~1%p7% goto finish
%1 %2 %p3% %p4% %p5% ___SPE~1%p6%       ___SPE~1%p7%
%1 %2 %p3% %p4% %p5% ___TES~1%p6%       ___TES~1%p7%
%1 %2 %p3% %p4% %p5% ___TES~2%p6%       ___TES~2%p7%
%1 %2 %p3% %p4% %p5% __H~1%p6%          __H~1%p7%
%1 %2 %p3% %p4% %p5% _-H~1%p6%          _-H~1%p7%
%1 %2 %p3% %p4% %p5% _ACKGR~1%p6%       _ACKGR~1%p7%
%1 %2 %p3% %p4% %p5% _AKEF~10%p6%       _AKEF~10%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~1%p6%       _AKEFI~1%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~2%p6%       _AKEFI~2%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~3%p6%       _AKEFI~3%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~4%p6%       _AKEFI~4%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~5%p6%       _AKEFI~5%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~6%p6%       _AKEFI~6%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~7%p6%       _AKEFI~7%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~8%p6%       _AKEFI~8%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~9%p6%       _AKEFI~9%p7%
%1 %2 %p3% %p4% %p5% _ALLIS~1%p6%       _ALLIS~1%p7%
%1 %2 %p3% %p4% %p5% _ALLIS~2%p6%       _ALLIS~2%p7%
%1 %2 %p3% %p4% %p5% _ALLIS~3%p6%       _ALLIS~3%p7%
%1 %2 %p3% %p4% %p5% _AP_DR~1%p6%       _AP_DR~1%p7%
%1 %2 %p3% %p4% %p5% _APC~1%p6%         _APC~1%p7%

...
etc.
see full version: artest26.zip
...

goto finish

:lfname

cd %dir1%

%1 %2 %p3% %p4% %p5% ___IBM~1%p6%       ___IBMPC.C%p7%
@rem abort if something went wrong
@rem if not exist ___IBM~1%p6% goto finish
@rem if not exist ___IBMPC.C%p7% goto finish
%1 %2 %p3% %p4% %p5% ___SPE~1%p6%       ___SPEC.C%p7%
%1 %2 %p3% %p4% %p5% ___TES~1%p6%       ___TEST.C%p7%
%1 %2 %p3% %p4% %p5% ___TES~2%p6%       ___TEST.MAK%p7%
%1 %2 %p3% %p4% %p5% __H~1%p6%          __.H%p7%
%1 %2 %p3% %p4% %p5% _-H~1%p6%          _-.H%p7%
%1 %2 %p3% %p4% %p5% _ACKGR~1%p6%       _ACKGRND.PBM%p7%
%1 %2 %p3% %p4% %p5% _AKEF~10%p6%       _AKEFILE.X%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~1%p6%       _AKEFIL_.TAM%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~2%p6%       _AKEFIL_.X%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~3%p6%       _AKEFIL2.TAM%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~4%p6%       _AKEFIL2.X%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~5%p6%       _AKEFIL3.MGR%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~6%p6%       _AKEFIL3.TAM%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~7%p6%       _AKEFILE.%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~8%p6%       _AKEFILE.MGR%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~9%p6%       _AKEFILE.TAM%p7%
%1 %2 %p3% %p4% %p5% _ALLIS~1%p6%       _ALLISTO.FD%p7%
%1 %2 %p3% %p4% %p5% _ALLIS~2%p6%       _ALLISTO.SFS%p7%
%1 %2 %p3% %p4% %p5% _ALLIS~3%p6%       _ALLISTO.SPD%p7%
%1 %2 %p3% %p4% %p5% _AP_DR~1%p6%       _AP_DR.C%p7%
%1 %2 %p3% %p4% %p5% _APC~1%p6%         _AP.C%p7%

...
etc.
see full version: artest26.zip
...


:finish
cd %dir0%
if "%8"=="-" goto end
if "%8"=="" goto end
dir /s/on %dir0%*.%8 >>0_%8.dir
call %0 %8 %9
:end
