#include <io.h>
#include <string.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <dir.h>

#define	ST_VETKA		1
#define	ST_END_TREE     	2

#define NUM_BYTES_IN_CODE	8

#define STF_NULL_BITS		0
#define STF_EMPTY		100
#define	STF_LESS		-2
#define STF_NORMAL		-1

#define STARG_FILE		0
#define STARG_END		1

typedef unsigned char	BYTE;
typedef unsigned long	DWORD;
typedef unsigned int	WORD;

typedef struct ffblk	FFBLK;
typedef struct ftime	FTIME;

typedef struct _BFILE
{
	FILE	*fpFile;
	int	iMask;
	int	iChar;
} BFILE;

typedef struct _CODE
{
	int	iNumBits;
	BYTE	byCodeOfChar[NUM_BYTES_IN_CODE];
} CODE;
CODE	coCharAr[256],coPath;

typedef struct _TREE_ELEM
{
	BYTE	byStatus;
	BYTE	byChar;
	struct _TREE_ELEM *ptNext[2];
} TREE_ELEM;

typedef struct _APPLE_TREE_ELEM
{
	BYTE	byStatus;
	BYTE	byChar;
	struct	_APPLE_TREE_ELEM  *patNext[2];
	long	lVer;
} APPLE_TREE_ELEM;

typedef struct _FOOR_ELEM
{
	BYTE	byChar;
	int	iFloor;
}FLOOR_ELEM;
FLOOR_ELEM	feElem[256];

typedef struct _MYFBLK
{
	char	szName[13];
	WORD    biSec	:5;
	WORD    biMin	:6;
	WORD    biHour	:5;
	WORD    biDay	:5;
	WORD    biMonth	:4;
	WORD    biYear	:7;
}MYFBLK;

char		buf1[16384],buf2[16384];
char		szPath[80],szDrive[3],szDir[66],szName[9],szExt[5];
char		szFullName[90],szTmpName[90],szTmpSimpleName[18];
char		szToPath[80],szFileMask[20];
DWORD		dwLenFile,dwLenArchive,dwSumLenFile,dwSumLenArchive;
DWORD		dwNumFiles,adwVer[256];
TREE_ELEM	*ptBeg;
int		nCur;
FFBLK		fblInfo;
FTIME		ftTime;
MYFBLK		mfInfo;

BFILE	*OpenInputFile(char *szFileName);
BFILE	*OpenOutputFile(char *szFileName);
void	PutBit(BFILE *bFile,int iBit);
int	GetBit(BFILE *bFile);
void	PutByte(BFILE *bFile,int iByte);
int	GetByte(BFILE *bFile);
void	PutDoubleWord(BFILE *bfOutput,DWORD dw);
DWORD	GetDoubleWord(BFILE *bfInput);
void	PutWord(BFILE *bfOutput,WORD w);
WORD	GetWord(BFILE *bfInput);
void	PutBits(BFILE *bfOutput,int iChar,int iNumBits);
int	GetBits(BFILE *bfInput,int iNumBits);

void	CloseInputFile(BFILE *bFile);
void	CloseOutputFile(BFILE *bFile);

TREE_ELEM*	 GetPointTree(void);
APPLE_TREE_ELEM* GetPointAppleTree(void);
void	DeleteTree(TREE_ELEM *ptBeg);
void	DeleteAppleTree(APPLE_TREE_ELEM *patBeg);

void	CompresFile(char *szInputFile,char *szOutputFile);
void	SaveFileInfo(BFILE *bfOutput,FFBLK *pfblInfo);
void	LoadFileInfo(BFILE *bfInput,MYFBLK *pmfInfo);
void	CountVer(FILE *fpInput);
int	MakeCodeArray(BFILE *bfFile);
int	FindMinNumberBits(void);
void	Travel(int iFloor,TREE_ELEM *ptCur);
void	AddBitInPath(int iBit);
void	DeleteBitInPath(void);
void	TravelAndSaveFloor(int iFloor,APPLE_TREE_ELEM *patCur);
int	CompAppleTreeElem(APPLE_TREE_ELEM **ppat1,APPLE_TREE_ELEM **ppat2);
void	SendBytes(FILE *fpInput,BFILE *bOutput);
void 	PutCodeByte(BFILE *bFile,int iByte);
void	PrintRatio(DWORD dwLenArchive,DWORD dwLenFile);

void	DeCompresFile(char *szInputFile,char szToPath,char *szMask,int n);
void	NextFloor(int iFloor,TREE_ELEM *ptCur);
int	GetCharOnFloor(int iloor);
int	MakeTree(BFILE *bfInput);
void	FatalError(char *szMessage);
int	CompFloorElem(FLOOR_ELEM *f1,FLOOR_ELEM *f2);
void	ListFile(char *szArchive,char *szMask,int n);
void	MakeTime(FTIME *pftTime,MYFBLK *pmfInfo);
int	CheckFileMask(char *szMask,char *szName);
int	FormatCommand(char *szMaybePath,char *szMaybeMask,int n);

void	MakeArchiveExtension(char *szPath);
void	MakeTmpExtension(char *szPath);
void	MakeSimpleName(char *szSimpleName,char *szPath);
void	MakeFullName(char *szFullName,char *szSimpleName,char *szPathName);

void	SmallHelp(void);
void	FatalError(char *szMessage)
{
	printf(szMessage);
	exit(1);
}

BFILE	*OpenInputFile(char *szFileName)
{
	BFILE *bFile;
	bFile=(BFILE*)calloc(1,sizeof(BFILE));
	if((bFile->fpFile=fopen(szFileName,"rb"))==NULL)
		return (NULL);
	bFile->iMask=0;
	return (bFile);
}

BFILE	*OpenOutputFile(char *szFileName)
{
	BFILE *bFile;
	bFile=(BFILE*)calloc(1,sizeof(BFILE));
	if((bFile->fpFile=fopen(szFileName,"wb"))==NULL)
		return (NULL);
	bFile->iChar=0;
	bFile->iMask=1;
	return (bFile);
}

void	CloseInputFile(BFILE *bFile)
{
	fclose(bFile->fpFile);
	free((char *)bFile);
}

void	CloseOutputFile(BFILE *bFile)
{
	if(bFile->iMask!=1)
		fputc(bFile->iChar,bFile->fpFile);
	fclose(bFile->fpFile);
	free((char *)bFile);
}

int	GetBit(BFILE *bFile)       /* iMask=Number of bits */
{
	if(bFile->iMask&=7)	bFile->iChar>>=1;
	else            	bFile->iChar=fgetc(bFile->fpFile);
	bFile->iMask++;
	return (bFile->iChar&1);
}

int	GetByte(BFILE *bFile)
{
	bFile->iMask=0;
	return (fgetc(bFile->fpFile));
}

void	PutBit(BFILE *bFile,int iBit)
{
	if (iBit)
		bFile->iChar|=bFile->iMask;
		if((bFile->iMask<<=1)==256)
		{
			fputc(bFile->iChar,bFile->fpFile);
			bFile->iChar=0;
			bFile->iMask=1;
		}
}

void	PutByte(BFILE *bFile,int iByte)
{
	if (bFile->iMask!=1)
		fputc(bFile->iChar,bFile->fpFile);
	bFile->iChar=0;
	bFile->iMask=1;
	fputc(iByte,bFile->fpFile);
}

void	PutCodeByte(BFILE *bFile,int iChar)
{
	int	i=0,iCountBytes=0;
	int	iByte;
	while(1)
	{
		iByte=coCharAr[iChar].byCodeOfChar[iCountBytes++];
		do
		{
			PutBit(bFile,iByte&1);
			iByte>>=1;
			if(++i==coCharAr[iChar].iNumBits)return;
		}
		while(i&7);
	}
}

void	PutDoubleWord(BFILE *bfOutput,DWORD dw)
{
	PutByte(bfOutput,dw&0xFF);
	PutByte(bfOutput,((dw>>8)&0xFF));
	PutByte(bfOutput,((dw>>16)&0xFF));
	PutByte(bfOutput,((dw>>24)&0xFF));
}

DWORD	GetDoubleWord(BFILE *bfInput)
{
	int	t,i;
	DWORD	dw=0;
	for(t=i=0;i<4;i++,t+=8)
		dw+=(((DWORD)(GetByte(bfInput)))<<t);
	return (dw);
}
void	PutWord(BFILE *bfOutput,WORD w)
{
	PutByte(bfOutput,w&0xFF);
	PutByte(bfOutput,((w>>8)&0xFF));
}

WORD	GetWord(BFILE *bfInput)
{
	int	t,i;
	WORD	w=0;
	for(t=i=0;i<2;i++,t+=8)
		w+=(((WORD)(GetByte(bfInput)))<<t);
	return (w);
}

void	PutBits(BFILE *bfOutput,int iChar,int iNumBits)
{
	for(;iNumBits>0;iNumBits--)
	{
		PutBit(bfOutput,iChar&1);
		iChar>>=1;
	}
}

int	GetBits(BFILE *bfInput,int iNumBits)
{
	int	iChar=0,iMask=1;
	for(;iNumBits>0;iNumBits--)
	{
		if(GetBit(bfInput))
			iChar|=iMask;
		iMask<<=1;
	}
	return (iChar);
}

TREE_ELEM *GetPointTree(void)
{
	TREE_ELEM *ptr;
	if( (ptr=(TREE_ELEM *)(malloc( sizeof(TREE_ELEM))))==NULL )
		FatalError("There is no dinamic memory");
	return (ptr);
}

APPLE_TREE_ELEM *GetPointAppleTree(void)
{
	APPLE_TREE_ELEM *ptr;
	if( (ptr=(APPLE_TREE_ELEM *)(malloc( sizeof(APPLE_TREE_ELEM))))==NULL )
		FatalError("There is no dinamic memory");
	return (ptr);
}

void	DeleteTree(TREE_ELEM *ptCur)
{
	if(ptCur->byStatus==ST_VETKA)
	{
		DeleteTree(ptCur->ptNext[0]);
		DeleteTree(ptCur->ptNext[1]);
	}
	free(ptCur);
}

void	DeleteAppleTree(APPLE_TREE_ELEM *patCur)
{
	if(patCur->byStatus==ST_VETKA)
	{
		DeleteAppleTree(patCur->patNext[0]);
		DeleteAppleTree(patCur->patNext[1]);
	}
	free(patCur);
}

void	NextFloor(int iFloor,TREE_ELEM *ptCur)
{
	int	iChar;
	if((iChar=GetCharOnFloor(iFloor))>255)
	{
		ptCur->byStatus=ST_VETKA;
		iFloor++;
		NextFloor(iFloor,ptCur->ptNext[0]=GetPointTree());
		NextFloor(iFloor,ptCur->ptNext[1]=GetPointTree());
	}
	else
	{
		ptCur->byStatus=ST_END_TREE;
		ptCur->byChar=iChar;
	}
}

int	GetCharOnFloor(int iFloor)
{
	if(feElem[nCur].iFloor!=iFloor)
		return (256);
	return (feElem[nCur++].byChar);
}

void	CompressFile(char *szArchive,char *szFile)
{
	FILE	*fpInput;
	BFILE	*bfOutput;
	int	iTmp;
	DWORD   dw;

	strcpy(szTmpName,szArchive);
	MakeTmpExtension(szTmpName);

	if((bfOutput=OpenOutputFile(szTmpName))==NULL)
	{
		printf("Can not open    %s\n",szArchive);
		FatalError("");
	}
	MakeSimpleName(szTmpSimpleName,szTmpName);
	setvbuf(bfOutput->fpFile,buf1,_IOFBF,16384);

	if(findfirst(szFile,&fblInfo,FA_RDONLY))
	{
		printf("Can not find    %s\n",szFile);
		FatalError("");
	}
	printf("Creating archive : %s\n",szArchive);
	do
	{
		strupr(fblInfo.ff_name);
		if(strcmp(szTmpSimpleName,fblInfo.ff_name)==0)
			continue;
		MakeFullName(szFullName,fblInfo.ff_name,szFile);
		if((fpInput=fopen(szFullName,"rb"))==NULL)
		{
			printf("Can not open     %s\n",szFullName);
			FatalError("");
		}

		setvbuf(fpInput,buf2,_IOFBF,16384);
		printf("Adding %s    ",szFullName);
		CountVer(fpInput);
		PutByte(bfOutput,STARG_FILE);
		SaveFileInfo(bfOutput,&fblInfo);
		PutDoubleWord(bfOutput,dwLenFile);
		if(dwLenFile==0)
		{
			dwLenArchive=0;
			PutDoubleWord(bfOutput,dwLenArchive);
		}
		else if ((iTmp=MakeCodeArray(bfOutput))>=0)
		     {
			dwLenArchive=2;
			PutDoubleWord(bfOutput,dwLenArchive);
			PutByte(bfOutput,STF_NULL_BITS);
			PutByte(bfOutput,iTmp);
		     }
		     else if(iTmp==STF_LESS)
			  {
				dwLenArchive=dwLenFile;
				PutDoubleWord(bfOutput,dwLenArchive);
				rewind(fpInput);
				for(dw=0;dw<dwLenFile;dw++)
					PutByte(bfOutput,fgetc(fpInput));
			  }
			  else	SendBytes(fpInput,bfOutput);

		PrintRatio(dwLenArchive,dwLenFile);
		printf("\n");
		setvbuf(fpInput,buf2,_IONBF,16384);
		fclose(fpInput);
	}
	while(findnext(&fblInfo)==0);

	PutByte(bfOutput,STARG_END);
	fclose(fpInput);
	CloseOutputFile(bfOutput);
	remove(szArchive);
	rename(szTmpName,szArchive);
	remove(szTmpName);
}

void	PrintRatio(DWORD dwLenArchive,DWORD dwLenFile)
{
	int	i;
	if(dwLenFile==0)
		i=100;
	else if(dwLenFile<10000000)
		i=(int)(dwLenArchive*100/(dwLenFile));
	else  i=(int)(dwLenArchive/(dwLenFile/100));
	printf("%5d\%",i);
}
void	SaveFileInfo(BFILE *bfOutput,FFBLK *pfblInfo)
{
	int	i;
	for (i=0;i<13;i++)
		PutByte(bfOutput,pfblInfo->ff_name[i]);
		PutWord(bfOutput,pfblInfo->ff_ftime);
		PutWord(bfOutput,pfblInfo->ff_fdate);
}

void	LoadFileInfo(BFILE *bfInput,MYFBLK *pmfInfo)
{
	int	i;
	for (i=0;i<13;i++)
		pmfInfo->szName[i]=(BYTE)GetByte(bfInput);
		pmfInfo->biSec=GetBits(bfInput,5);
		pmfInfo->biMin=GetBits(bfInput,6);
		pmfInfo->biHour=GetBits(bfInput,5);
		pmfInfo->biDay=GetBits(bfInput,5);
		pmfInfo->biMonth=GetBits(bfInput,4);
		pmfInfo->biYear=GetBits(bfInput,7);
}

void	CountVer(FILE *fpInput)
{
	int i,a;
	for(i=0;i<256;i++)
		adwVer[i]=0;
	while((a=fgetc(fpInput))!=EOF)
		adwVer[(BYTE)a]++;
	for(dwLenFile=i=0;i<256;i++)
		dwLenFile+=adwVer[i];
}

int	MakeCodeArray(BFILE *bfOutput)
{
	APPLE_TREE_ELEM	*apat[256],*patNew;
	int	i,t,iMinBitsForFloor;
	for (i=0;i<256;i++)
	{
		for(t=0;t<NUM_BYTES_IN_CODE;t++)
			coCharAr[i].byCodeOfChar[t]=0;
		apat[i]=GetPointAppleTree();
		apat[i]->lVer=adwVer[i];
		apat[i]->byChar=(BYTE)i;
		apat[i]->byStatus=ST_END_TREE;
	}
	qsort(apat,256,sizeof(APPLE_TREE_ELEM *),CompAppleTreeElem);
	for (t=0;apat[t]->lVer>0;t++);
	for (i=t;i<256;i++)
		DeleteAppleTree(apat[i]);
	if (t==1)
	{
		i=apat[0]->byChar;
		DeleteAppleTree(apat[0]);
		return (i);
	}

	while(t>1)
	{
		patNew=GetPointAppleTree();
		patNew->byStatus=ST_VETKA;
		patNew->lVer=apat[t-2]->lVer+apat[t-1]->lVer;
		patNew->patNext[0]=apat[t-2];
		patNew->patNext[1]=apat[t-1];

		for(i=t-3;patNew->lVer>apat[i]->lVer&&i>=0;i--)
			apat[i+1]=apat[i];
		apat[i+1]=patNew;
		t--;
	}
	for (i=0;i<256;i++)
	{
		feElem[i].iFloor=0;
		feElem[i].byChar=(BYTE)i;
	}
	TravelAndSaveFloor(0,apat[0]);
	DeleteAppleTree(apat[0]);

	iMinBitsForFloor=FindMinNumberBits();

	dwLenArchive=iMinBitsForFloor*256+8;
	for (i=0;i<256;i++)
		dwLenArchive+=feElem[i].iFloor*adwVer[i];
	dwLenArchive=(dwLenArchive+7)/8;
	if(dwLenArchive>=dwLenFile)
	{
		return(STF_LESS);
	}
	PutDoubleWord(bfOutput,dwLenArchive);

	PutByte(bfOutput,iMinBitsForFloor);
	for(t=i=0;i<256;i++)
	{
		PutBits(bfOutput,feElem[i].iFloor,iMinBitsForFloor);
		if (feElem[i].iFloor!=0)
			feElem[t++]=feElem[i];
	}
	qsort(feElem,t,sizeof(FLOOR_ELEM),CompFloorElem);
	ptBeg=GetPointTree();
	nCur=0;
	NextFloor(0,ptBeg);
	for(i=0;i<NUM_BYTES_IN_CODE;i++)
		coPath.byCodeOfChar[i]=0;
	coPath.iNumBits=0;
	Travel(0,ptBeg);
	DeleteTree(ptBeg);
	return (STF_NORMAL);
}

int	FindMinNumberBits(void)
{
	int	i,max;
	for(i=max=0;i<256;i++)
	{
		if(feElem[i].iFloor>max)
			max=feElem[i].iFloor;
	}
	for(i=0;max>0;i++)
		max>>=1;
	return (i);
}


void	TravelAndSaveFloor(int iFloor,APPLE_TREE_ELEM *patCur)
{
	if(patCur->byStatus==ST_VETKA)
	{
		iFloor++;
		TravelAndSaveFloor(iFloor,patCur->patNext[0]);
		TravelAndSaveFloor(iFloor,patCur->patNext[1]);
	}
	else	feElem[patCur->byChar].iFloor=iFloor;

}

int	CompAppleTreeElem(APPLE_TREE_ELEM **ppat1,APPLE_TREE_ELEM **ppat2)
{
	APPLE_TREE_ELEM	*pat1,*pat2;
	pat1=(APPLE_TREE_ELEM *)*ppat1;
	pat2=(APPLE_TREE_ELEM *)*ppat2;
	if (pat1->lVer > pat2->lVer)  return (-1);
	return(pat1->lVer < pat2->lVer);
}

void	Travel(int iFloor,TREE_ELEM *ptCur)
{
	if(ptCur->byStatus==ST_VETKA)
	{
		iFloor++;
		AddBitInPath(0);
		Travel(iFloor,ptCur->ptNext[0]);
		AddBitInPath(1);
		Travel(iFloor,ptCur->ptNext[1]);
	}
	else coCharAr[ptCur->byChar]=coPath;
	DeleteBitInPath();
}

void	AddBitInPath(int iBit)
{
       	if(iBit)
		coPath.byCodeOfChar[coPath.iNumBits/8]|= 1<<(coPath.iNumBits%8);
	coPath.iNumBits++;
}

void	DeleteBitInPath(void)
{
	coPath.iNumBits--;
	coPath.byCodeOfChar[coPath.iNumBits/8]&=~(1<<(coPath.iNumBits%8));
}

void	SendBytes(FILE *fpInput,BFILE *bOutput)
{
	DWORD	i;
	rewind(fpInput);
	for(i=0;i<dwLenFile;i++)
		PutCodeByte(bOutput,(BYTE)fgetc(fpInput));
}

void	DeCompressFile(char *szArchive,char *szMaybePath,char *szMaybeFileMask,int n)
{
	BFILE		*bfInput;
	FILE		*fpOutput;
	TREE_ELEM	*ptCur;
	DWORD		i;
	char		szLoadName[95];
	int		iMask,iStatus,iTmp;

	iMask=FormatCommand(szMaybePath,szMaybeFileMask,n);

	dwNumFiles=0;
	if((bfInput=OpenInputFile(szArchive))==NULL)
		FatalError("\nCan not open archive file");
	setvbuf(bfInput->fpFile,buf1,_IOFBF,16384);
	printf("Processing archive  : %s\n",szArchive);
	while(GetByte(bfInput)==STARG_FILE)
	{
		LoadFileInfo(bfInput,&mfInfo);
		strcpy(szLoadName,szToPath);
		strcat(szLoadName,mfInfo.szName);

		dwLenFile=GetDoubleWord(bfInput);
		dwLenArchive=GetDoubleWord(bfInput);

		if(iMask)
			if(CheckFileMask(szFileMask,mfInfo.szName)==0)
			{
				fseek(bfInput->fpFile,dwLenArchive,SEEK_CUR);
				continue;
			}

		if((fpOutput=fopen(szLoadName,"wb"))==NULL)
			FatalError("\nCan not open file");
		dwNumFiles++;
		MakeTime(&ftTime,&mfInfo);

		setvbuf(fpOutput,buf2,_IOFBF,16384);
		printf("Extracting %s%-18s",szToPath,mfInfo.szName);

		iStatus=MakeTree(bfInput);
		if(iStatus==STF_EMPTY)
		{
		}
		else	if(iStatus==STF_NULL_BITS)
			{
				iTmp=GetByte(bfInput);
				for(i=0;i<dwLenFile;i++)
					fputc(iTmp,fpOutput);
			}
			else if(iStatus==STF_LESS)
			     {
				for(i=0;i<dwLenArchive;i++)
					fputc(GetByte(bfInput),fpOutput);
			     }
			     else
			     {
				for (i=0;i<dwLenFile;i++)
				{
					ptCur=ptBeg;
					while(ptCur->byStatus!=ST_END_TREE)
						ptCur=ptCur->ptNext[GetBit(bfInput)];
					fputc(ptCur->byChar,fpOutput);
				}
				DeleteTree(ptBeg);
			     }
		printf("OK\n");
		fflush(fpOutput);
		setftime(fpOutput->fd,&ftTime);
		setvbuf(fpOutput,buf2,_IONBF,16384);
		fclose(fpOutput);
	}
	CloseInputFile(bfInput);
	printf("%6ld files\n",dwNumFiles);
}


int     CheckFileMask(char *szMask,char *szName)
{
	char	cMask,cName;
	int	i=0,t=0;
	do
	{
		cName=szName[i++];
		cMask=szMask[t];
		if(cName=='.' && cMask=='*')
				cMask=szMask[++t];
		if(cMask=='*')
			continue;
		t++;
		if(cMask=='?')
			continue;
		if(cName!=cMask)
			return (0);
	}
	while( cName!='\0');
	if(cMask=='\0' ||cMask=='*')	return(1);
	return (0);
}

int	FormatCommand(char *szMaybePath,char *szMaybeMask,int n)
{
	char	*szPoint;
	int iMask=0;
	if(n==0)
		strcpy(szToPath,"");
	else
	{
		strcpy(szToPath,szMaybePath);
		if(n==2)
		{
			iMask=1;
			strcpy(szFileMask,szMaybeMask);
			szPoint=szToPath+strlen(szToPath)-1;
			if(*szPoint!='\\')
			{
					*(szPoint+1)='\\';
					*(szPoint+2)='\0';
			}
		}
		if(n==1)
		{
			if(strchr(szToPath,'\\')==NULL)
			{
				strcpy(szFileMask,szToPath);
				iMask=1;
				strcpy(szToPath,"");
			}
			else
			{
				szPoint=szToPath+strlen(szToPath)-1;
				if(*szPoint!='\\')
					*(szPoint+1)='\\';
					*(szPoint+2)='\0';
			}
		}
	}	
	return (iMask);
}

void	MakeTime(FTIME *pftTime,MYFBLK *pmfInfo)
{
	pftTime->ft_tsec=pmfInfo->biSec;
	pftTime->ft_min=pmfInfo->biMin;
	pftTime->ft_hour=pmfInfo->biHour;
	pftTime->ft_day=pmfInfo->biDay;
	pftTime->ft_month=pmfInfo->biMonth;
	pftTime->ft_year=pmfInfo->biYear;
}

int	MakeTree(BFILE *bfInput)
{
	int	iStatus,iTmp,i,t;

	if(dwLenFile==0)
		return(STF_EMPTY);
	if(dwLenArchive==dwLenFile)
		return(STF_LESS);
	iStatus=GetByte(bfInput);
	if(iStatus==STF_NULL_BITS)
		return(iStatus);

	for(i=t=0;i<256;i++)
	{
		iTmp=GetBits(bfInput,iStatus);
		if (iTmp)
		{
			feElem[t].iFloor=iTmp;
			feElem[t].byChar=i;
			t++;
		}
	}
	qsort(feElem,t,sizeof(FLOOR_ELEM),CompFloorElem);
	ptBeg=GetPointTree();
	nCur=0;
	NextFloor(0,ptBeg);
	return(iStatus);
}
int	CompFloorElem(FLOOR_ELEM *f1,FLOOR_ELEM *f2)
{
	if (f1->iFloor<f2->iFloor)  return (-1);
	if (f1->iFloor>f2->iFloor)  return (1);
	if (f1->byChar<f2->byChar)  return (-1);
	return (f1->byChar>f2->byChar);
}
void	ListFile(char *szArchive,char *szMaybeMask,int n)
{
	BFILE		*bfInput;
	char		szLoadName[13];
	int		iMask;
	
	dwNumFiles=0;
	if((bfInput=OpenInputFile(szArchive))==NULL)
		FatalError("\nCan not open archive file");
	setvbuf(bfInput->fpFile,buf1,_IOFBF,1024);
	
	strcpy(szFileMask,szMaybeMask);
	if(n==0)
		iMask=0;
	printf("Processing archive  : %s\n",szArchive);
	printf("Filename       Original Compressed  Ratio\n"
	       "------------ ---------- ---------- ------\n");
	dwSumLenArchive=dwSumLenFile=0;
	while(GetByte(bfInput)==STARG_FILE)
	{
		LoadFileInfo(bfInput,&mfInfo);
		strcpy(szLoadName,mfInfo.szName);
		dwLenFile=GetDoubleWord(bfInput);
		dwLenArchive=GetDoubleWord(bfInput);

		if(iMask)
			if(CheckFileMask(szFileMask,szLoadName)==0)
			{
				fseek(bfInput->fpFile,dwLenArchive,SEEK_CUR);
				continue;
			}
			dwNumFiles++;
			dwSumLenFile+=dwLenFile;
			dwSumLenArchive+=dwLenArchive;
	
			printf("%-12s %10ld %10ld ",szLoadName,dwLenFile,dwLenArchive);
			PrintRatio(dwLenArchive,dwLenFile);
			printf("\n");
		fseek(bfInput->fpFile,dwLenArchive,SEEK_CUR);
	}
	CloseInputFile(bfInput);
	printf("------------ ---------- ---------- ------\n"
	      "%6ld files %10ld %10ld ",dwNumFiles,dwSumLenFile,
						dwSumLenArchive);
	PrintRatio(dwSumLenArchive,dwSumLenFile);
	printf("\n");
}

void	MakeArchiveExtension(char *szPath)
{
	int	iFlags;
	iFlags=fnsplit(szPath,szDrive,szDir,szName,szExt);
	if (!(iFlags & EXTENSION))
	{
		strcpy(szExt,".ARG");
		fnmerge(szPath,szDrive,szDir,szName,szExt);
	}
}
void	MakeTmpExtension(char *szPath)
{
	fnsplit(szPath,szDrive,szDir,szName,szExt);
	strcpy(szExt,".$$$");
	fnmerge(szPath,szDrive,szDir,szName,szExt);
}

void	MakeSimpleName(char *szSimpleName,char *szPath)
{
	fnsplit(szPath,NULL,NULL,szName,szExt);
	fnmerge(szSimpleName,"","",szName,szExt);
}

void	MakeFullName(char *szFullName,char *szSimpleName,char *szPathName)
{
	fnsplit(szPathName,szDrive,szDir,NULL,NULL);
	fnsplit(szSimpleName,NULL,NULL,szName,szExt);
	fnmerge(szFullName,szDrive,szDir,szName,szExt);
}

void main(int nArg,char *aszArgv[])
{
	int	i;
	printf("ARG 1.00.001 BETA. Jun 5 1994."
	       "For any use\n\n");
	for(i=1;i<nArg;i++)
		strupr(aszArgv[i]);
	if(nArg<3)
		SmallHelp();
	strcpy(szPath,aszArgv[2]);
	MakeArchiveExtension(szPath);
	if(*aszArgv[1]=='A')
		CompressFile(szPath,aszArgv[3]);
	else	
	{
		if(nArg>5)
			SmallHelp();
		if(*aszArgv[1]=='E')
			DeCompressFile(szPath,aszArgv[3],aszArgv[4],nArg-3);
		else 
		{
			if(nArg>4)
				SmallHelp();
			if(*aszArgv[1]=='L')
	        		ListFile(szPath,aszArgv[3],nArg-3);
			else	SmallHelp();
		}
	}
	exit(0);
}

void	SmallHelp(void)
{
	printf("Usage:     ARG <command> <archive_name> [<file_names>...]\n"
	       "Examples:  ARG a archive file*.doc, ARG e archive\n");
	printf("<Commands>\n"
	       "  a: Add files to archive\n"
	       "  e: Extract files in archive\n"
	       "  l: List contents of archive\n");
	exit (0);
}


