// addzip.h
//
// C/C++ header file for addZIP compression libraries
//
// Copyright  1995,1997 Stephen Darlington. All rights reserved.

#ifndef _ADDZIP_H_
#define _ADDZIP_H_

typedef unsigned char BYTE;
typedef unsigned short UINT16;
typedef unsigned long UINT32;
typedef char CHAR;
typedef short INT16;
typedef long INT32;

typedef INT16 (CALLBACK *CALLBACKFN)(INT16, INT16, char *);

#ifdef __cplusplus
extern "C"
{
#endif
INT16 addZIP(void);
INT16 CALLBACK _export addZIP_ArchiveName(LPSTR);
INT16 CALLBACK _export addZIP_ClearAttributes(INT16);
INT16 CALLBACK _export addZIP_Comment(LPSTR);
INT16 CALLBACK _export addZIP_Delete(INT16);
INT16 CALLBACK _export addZIP_DeleteComment(INT16);
INT16 CALLBACK _export addZIP_DisplayComment(INT16);
INT16 CALLBACK _export addZIP_Encrypt(LPSTR);
INT16 CALLBACK _export addZIP_Exclude(LPSTR);
INT16 CALLBACK _export addZIP_ExcludeListFile(LPSTR);
INT16 CALLBACK _export addZIP_GetLastError(void);
INT16 CALLBACK _export addZIP_GetLastWarning(void);
INT16 CALLBACK _export addZIP_Include(LPSTR);
INT16 CALLBACK _export addZIP_IncludeFilesNewer(char *cDate);
INT16 CALLBACK _export addZIP_IncludeFilesOlder(char *cDate);
INT16 CALLBACK _export addZIP_IncludeArchive(INT16 iFlag);
INT16 CALLBACK _export addZIP_IncludeDirectoryEntries(INT16 flag);
INT16 CALLBACK _export addZIP_IncludeHidden(INT16 iFlag);
INT16 CALLBACK _export addZIP_IncludeReadOnly(INT16 iFlag);
INT16 CALLBACK _export addZIP_IncludeSystem(INT16 iFlag);
INT16 CALLBACK _export addZIP_IncludeListFile(LPSTR);
INT16 CALLBACK _export addZIP_InstallCallback(CALLBACKFN cbFunction);
INT16 CALLBACK _export addZIP_Overwrite(INT16);
INT16 CALLBACK _export addZIP_Register(LPSTR, UINT32);
INT16 CALLBACK _export addZIP_Recurse(INT16);
INT16 CALLBACK _export addZIP_SaveAttributes(INT16);
INT16 CALLBACK _export addZIP_SaveStructure(INT16);
INT16 CALLBACK _export addZIP_SetArchiveDate(INT16);
INT16 CALLBACK _export addZIP_SetCompressionLevel(INT16);
INT16 CALLBACK _export addZIP_SetParentWindowHandle(HWND);
INT16 CALLBACK _export addZIP_SetTempDrive(LPSTR);
INT16 CALLBACK _export addZIP_SetWindowHandle(HWND);
INT16 CALLBACK _export addZIP_Span(INT16);
INT16 CALLBACK _export addZIP_Store(LPSTR);
INT16 CALLBACK _export addZIP_UseLFN(INT16);
INT16 CALLBACK _export addZIP_View(INT16);
#ifdef __cplusplus
}
#endif

// constants for addZIP_SetCompressionLevel(...)
#define azCOMPRESSION_NONE    0x00
#define azCOMPRESSION_MINIMUM 0x01
#define azCOMPRESSION_NORMAL  0x02
#define azCOMPRESSION_MAXIMUM 0x03

// constants for addZIP_SaveStructure(...)
#define azSTRUCTURE_NONE     0x00
#define azSTRUCTURE_RELATIVE 0x01
#define azSTRUCTURE_ABSOLUTE 0x02

// constants for addZIP_Overwrite(...)
#define azOVERWRITE_QUERY 0x0a
#define azOVERWRITE_ALL   0x0b
#define azOVERWRITE_NONE  0x0c

// constants for addZIP_SetArchiveDate();
#define DATE_ORIGINAL  0x00
#define DATE_TODAY     0x01
#define DATE_OLDEST    0x02
#define DATE_NEWEST    0x03

// constants for addZIP_IncludeXXX attribute functions
#define azNEVER  0x00  // files must never have this attribute set
#define azYES    0x01  // files may or may not have this attribute set
#define azALWAYS 0xff  // files must always have this attribute set

// constants for addZIP_ClearAttributes(...)
#define azATTR_NONE 0
#define azATTR_READONLY 1
#define azATTR_HIDDEN 2
#define azATTR_SYSTEM 4
#define azATTR_ARCHIVE 32
#define azATTR_ALL 39

// constants used in messages to identify library
#define azLIBRARY_ADDZIP 0

//
#define AM_SEARCHING      0x0a
#define AM_ZIPCOMMENT     0x0b
#define AM_ZIPPING        0x0c
#define AM_ZIPPED         0x0d
#define AM_UNZIPPING      0x0e
#define AM_UNZIPPED       0x0f
#define AM_TESTING        0x10
#define AM_TESTED         0x11
#define AM_DELETING       0x12
#define AM_DELETED        0x13
#define AM_DISKCHANGE     0x14
#define AM_VIEW           0x15
#define AM_ERROR          0x16
#define AM_WARNING        0x17
#define AM_QUERYOVERWRITE 0x18
#define AM_COPYING        0x19
#define AM_COPIED         0x1a
//#define AM_REPAIRING      0x1b
//#define AM_FILECOMMENT    0x1c
//#define AM_PASSWORD       0x1d
#define AM_ABORT          0xff

// Constants for compression method in AM_VIEW
#define azCM_NONE 0              0x00
#define azCM_SHRUNK              0x0a
#define azCM_REDUCED_1           0x14
#define azCM_REDUCED_2           0x1e
#define azCM_REDUCED_3           0x28
#define azCM_REDUCED_4           0x32
#define azCM_IMPLODED            0x3c
#define azCM_TOKENISED           0x46
#define azCM_DEFLATED_NORMAL     0x50
#define azCM_DEFLATED_MAXIMUM    0x51
#define azCM_DEFLATED_FAST       0x52
#define azCM_DEFLATED_SUPERFAST  0x53
#define azCM_UNKNOWN             0xff

//Constants for whether file is encrypted or not in AM_VIEW
#define azFT_NOT_ENCRYPTED 0x00
#define azFT_ENCRYPTED     0x01

//Constants for whether file is text or binary in AM_VIEW
#define azFT_TEXT   0x00
#define azFT_BINARY 0x01

// Constants used in returning from a AM_QUERYOVERWRITE message
#define azOW_YES        0x00
#define azOW_YES_TO_ALL 0x01
#define azOW_NO         0x02
#define azOW_NO_TO_ALL  0x03

#endif
