unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, ComCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    Label1: TLabel;
    Button2: TButton;
    Button3: TButton;
    Label6: TLabel;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var header: record
  sign: dword; // archive identificator
  attr: dword; // attribute of archive
  info:word;   // internal info
  fnl:word;    // lenght of file path in archive
  fctime:filetime;    // creation time
  fatime:filetime;    // access time
  fwtime:filetime;    // write time
  hsize:dword;        // high size of file
  lsize:dword;        // low size of archive
end;

var
  Form1: TForm1;
  XSOURCE:String; // STRING FOR READING PATH FROM ARCHIVE

  implementation

function PACKDATA(A: PCHAR; B: PCHAR; C: PCHAR):integer; stdcall;
external 'aax.dll' name 'Compress';

function UNPACKDATA(A: PCHAR; B: PCHAR):integer; stdcall;
external 'aax.dll' name 'Decompress';



{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
VAR source:array[0..4096] of Char;
VAR destination:array[0..4096] of Char;
S:STRING;
begin

if filelistbox1.FileName='' then begin
showmessage('Please select file from FileListBox');
exit;
end;

s:=filelistbox1.filename;
strpcopy(source,s);
savedialog1.Title:='Type output archive with your own extention';
savedialog1.FileName:='MyArchive.ABC';
if SaveDialog1.Execute then begin
strpcopy(destination,savedialog1.FileName);
Packdata('3',source,destination);
filelistbox1.Refresh;
showmessage('ok - packed');
end;
end;


procedure TForm1.Button2Click(Sender: TObject);
VAR source:array[0..4096] of Char;
VAR destination:array[0..4096] of Char;
s:string;
begin
if filelistbox1.FileName='' then begin
showmessage('Please select archive from FileListBox');
exit;
end;

s:=filelistbox1.filename;
strpcopy(source,s);
savedialog1.Title:='Type output FROM archive';
savedialog1.FileName:='';

if SaveDialog1.Execute then begin
strpcopy(destination,savedialog1.FileName);
UnPackdata(source,destination);
filelistbox1.Refresh;
showmessage('ok - unpacked');
end;

end;

procedure TForm1.Button3Click(Sender: TObject);
var f:tfilestream;
begin
if OpenDialog1.Execute then
f:=tfilestream.Create(opendialog1.FileName,fmOpenRead);
f.Read(header,sizeof(header));
f.Read(xsource[1],header.fnl);
f.free;
showmessage('OK, now are header record filled with archive data.');
end;

end.
