        page    66,80
        TITLE   VMODE! 1.6 Set screen video mode
Comment 
        last updated by Roedy Green 93/06/08
        works with MASM 5.0 and Optasm

  USAGE:

Examples:
*********

VMODE! CO80
VMODE! CO40
VMODE! BW80
VMODE! BW40
VMODE! MONO
VMODE! 7

all set the video mode.

VMODE!
by itself just displays the current video mode.

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.3 1998 November 8
- embed Barker address

Version 1.5 1996 October 25
- embed POB 707 Quathiaski Cove address


Notes on the Equipment Flag
***************************

I have not had a chance to test this all all BIOSes, but with my
Phoenix Rom Bios, in a dual monitor system, if you do 2 VMODE!
(ask BIOS to set the video mode with int 10 function 0) it won't
work unless at some time in since you booted you did a MODE CO80
or MODE BW80 at the DOS C:> level.  It seems as though the BIOS
doesn't know the colour card is there until MODE modifies
location 0040:0010 where BIOS keeps its equipment INT 11 bit
vector to tell the BIOS that the MODE 2 and 3 are safe because
the CGA card is really there.  INT 11 only knows about the mono
card.   Until that time a 2 VMODE! is treated like a 7 VMODE!
However once you have issued the MODE commands you can hop back
and Forth with 7 VMODE! and 3 VMODE!. Typing MODE MONO makes
BIOS forget that a colour card exists and you can no longer
toggle. To bypass this nonsense VMODE! modifies the equipment
byte at 0040:0010.  Might not work in all BIOSes!!!  The DOS
MODE itself works by fiddling the equipment bits prior to
issuing the INT 10 AH=0 set mode.  So in this program we fiddle
the equipment flags to make the mode work.

The equipment flag is as 0040:0010 bits 4 and 5
equip
        bits           Video modes
00=none or EGA/VGA 13 14 15 16
01 40 x 25 CGA 0 1
10 80 x 25 CGA 2 3 4 5 6
11 80 x 25 MDA 7


Register Conventions
********************

Subroutines may trash all registers except those explicity
documented as input or output.

 ; end of comment

;==============================================================

BIOSDATA    segment AT 40h      ; dummy segment in low RAM

                org     10h
BIOSEquipFlag   db      ?       ; BIOS equipment flag
                                ; we need to cheat and tweak it for
                                ; video modes to work
BIOSDATA        ends

stack   segment stack           ; keep MS link happy by providing null stack
stack   ends

CODE    SEGMENT PARA            ; start off in code.

;==============================================================

data    segment byte            ; provide a separate DATA segment
                                ; actually all come after the code
;==============================================================
;  V A R I A B L E S

;               indent a little to make 40-col wrap easier to read

BannerMsg       label   byte
        DB      ' VMODE! 1.6  ۲',13d,10d
        DB      13d,10d
        DB      'Video screen MODE utility',13,10
        DB      'Copyright (c) 1991,1998 Roedy Green Canadian Mind Products',13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.',13,10,13,10
        db      '$'

ModeErrMsg      db ' Error ۲ no such video mode',13,10,13,10
                db '$'

FailMsg         db ' Error ۲ this equipment cannot handle that video mode',13,10
                db '$'

UsageMsg        db 'Try:',13,10
                db 'VMODE!       -- plain displays the current video mode',13,10
                db 'VMODE! BW40  -- for 40 column colour mode 0',13,10
                db 'VMODE! CO40  -- for 40 column colour mode 1',13,10
                db 'VMODE! BW80  -- for 80 column colour mode 2',13,10
                db 'VMODE! CO80  -- for 80 column colour mode 3',13,10
                db 'VMODE! MONO  -- for monochrome mode 7',13,10
                db 'VMODE! 7     -- for monochrome mode 7',13,10
                db 'VMODE! n     -- for mode n',13,10
                db '                where n is a number 0 .. 255',13,10
                db '$'

VModeIsMsg      db 'The video mode is now '
                db '$'

SpaceMsg        db ' '
                db '$'

Pad             db "00000$"
                        ; where numeric output built by SayDec

; Codes for what various words on command line do
; Abbreviations allowed on the command line, and routines to handle them

AbbrItemLen     equ     5       ; length of one table item
AbbrMode        equ     4       ; offset in item of colour code

AbbrTab         Label   Byte
;                       string is name of mode
;                       mode is INT 10 code for that video mode

                                ; al has mode 0,2=gray 1,3=colour 7=mono
                DB      "BW40", 0
                DB      "CO40", 1
                DB      "BW80", 2
                DB      "CO80", 3
                DB      "MONO", 7

; You can add elements to this table.  There is nothing else you need
; to to have them become active keywords.

EndAbbrTab      Label   Byte

DesVMode        DB      0       ; Desired Vmode

GotVMode        DB      0       ; Vmode got, one we have now.

LookFlag        DB      0       ; 0=set video mode
                                ; -1= just look and display current vmode
data            ends

com     group   code,data       ; force data segment to go at the end!

        ASSUME  CS:com,DS:com,ES:com,SS:com
                                ; seg regs cover everything
        ORG     100H            ; in Code segment

;==========================

Start   proc    far

;       M A I N L I N E   R O U T I N E
        Call    Parse           ; parse the command line
                                ; results in LookFlag and DesVMode
;       read or set the mode?
        Test    LookFlag,1
        jnz     ShowMode        ; Show current video mode without change

        Call    FudgeEquip      ; Fudge BIOS equipment flags so
                                ; following set video mode will take
        Call    SetVMode        ; set the video mode
        Call    GetVmode        ; find out what video mode is now
        mov     al,DesVmode
        cmp     al,GotVmode     ; desired vs got?
        je      Done            ; if same, we are done

DidNotTake:
        lea     dx,FailMsg      ; not the same, BIOS refused our new mode
        call    Say             ; complain
                                ; carry on to show the new Vmode

ShowMode:
        Call    GetVmode        ; get video mode
        Call    DisplayVmode    ; display it onscreen as name/number

Done:
        mov     ax,4c00h
        int     21h             ;normal termination

;===============================================================

FudgeEquip      Proc    Near

comment |
Fudge the equipment byte at location 0040:0010 to force the mode
set function to work.  It might be appropriate to quote from
Lady Macbeth about a foul deed that t'were well t'were done
quickly.  This is obscene code.  However it is what DOS MODE
does.  I cannot think of a decent way to accomplish the same
thing.  If there are bugs in VMODE! the fault probably lies in
this routine.  For systems with TWO monitors, there is still
only one equipment byte.  It may be impossible to write proper
code.

        equip binary  modes
        00h = 00=none or EGA/VGA 13 14 15 16, or anything else
        10h = 01 40 x 25 CGA 0 1
        20h = 10 80 x 25 CGA 2 3 4 5 6
        30h = 11 80 x 25 MDA 7
        | ; end of comment

        mov     bh,0
        mov     bl,DesVMode
        cmp     bl,7
        jbe     LookUpFudge
        mov     dl,0                    ; default fudge byte is 0
        jmp     DoFudge

LookUpFudge:
        mov     dl,FudgeTab[bx]

DoFudge:
        push    ES                      ; dl contains fudge byte
        mov     ax,BIOSDATA
        mov     ES,ax
        assume  ES:BIOSDATA
        mov     al,BIOSEquipFlag
        test    al,030h                 ; Suppress fudge for code 0=VGA
        jz      FudgeSuppress

        and     al,(0ffh-030h)          ; mask off old bits 4 and 5
        or      al,dl                   ; or in the fudge bits
        mov     BIOSEquipFlag,al        ; put back modified equip flag.

FudgeSuppress:
        pop     ES
        assume  ES:com
        ret

Fudgetab        label   Byte
                        ; table of equipment bytes needed  for various modes.
        db      10H     ; mode 0 fake in GCA with black and white monitor
        db      10H     ; mode 1
        db      20H     ; mode 2 fake in GCA card
        db      20H     ; mode 3
        db      20H     ; mode 4
        db      20H     ; mode 5
        db      20H     ; mode 6
        db      30H     ; mode 7 fake in monochrome card
                        ; modes 8 to 255 fake in VGA card

EndFudgeTab     Label   byte

FudgeEquip      EndP
;===============================================================

SetVmode        Proc    Near
;       special handling required if this is a Video 7 card
        mov     ax,06f00h       ; is this a video 7?
        xor     bx,bx
        int     10h
        cmp     bx,05637h       ; = 'V7' ?
        jne     SV_NotVideo7

SV_IsVideo7:                    ; use Video 7 proprietary mode set
        mov     bl,DesVmode     ; set with extended video mode
        mov     ax,06f05h
        int     10h
        ret

SV_NotVideo7:
        mov     al,DesVmode
        mov     ah,00h          ; set normal video mode
        int     10h
                                ; bypass bug in some BIOSes.
                                ; that fail to home the cursor
        xor     dx,dx           ; dh=row dl=col  0,0
        xor     bh,bh           ; bh=0 page
        mov     ah,2            ; set cursor pos function
        int     10h
        ret
SetVmode        EndP

;===============================================================

GetVmode        Proc    Near
;       Get current video mode and store in GotVMode
;       special handling required if this is a Video 7 card
        mov     ax,06f00h       ; is this a Video 7 card?
        xor     bx,bx
        int     10h
        cmp     bx,05637h       ; = 'V7' ?
        jne     GV_NotVideo7

GV_IsVideo7:                    ; use Video 7 proprietary mode get
        mov     ax,06f04h
        int     10h
        mov     GotVmode,al     ; AL has extended V7 mode
        ret

GV_NotVideo7:
        mov     ah,0fh          ; get current video mode
        int     10h
                                ; al has plain mode 0,2=gray 1,3=colour 7=mono
        mov     GotVmode,al
        ret
GetVmode        EndP

;===============================================================

DisplayVmode    Proc    Near
;       Display the video mode value of GotVMode
        Lea     dx,VModeIsMsg
        Call    Say
        Call    ShowVModeName   ; display as name e.g. MONO
        mov     ah,0            ; display as number e.g. 7
        mov     al,GotVMode
        Call    SayDec
        ret
DisplayVmode    Endp

;===============================================================

Trouble proc    near
;       Syntax error on the command line

        lea     dx,BannerMsg    ; display the banner
        Call    Say

        lea     dx,ModeErrMsg   ; display Error message
        Call    Say

        lea     dx,UsageMsg     ; display usage message
        Call    Say
abort:
                                ; error exit
        mov  ax, 4c04h          ; ERRORLEVEL = 4
        int     21h             ; DIE
Trouble endp

;===============================================================

ShowVModeName   Proc    Near
;       Display the mode as a name e.g. MONO
;       on entry GotVmode is the mode
;       if there is a matching entry we output that mode name.
;       if no match, do nothing
        lea     si, AbbrTab             ; point to first possibility
SVN_CompLoop:
        mov     al,GotVMode
        cmp     al,[si+AbbrMode]        ; compare two modes
        je      SVN_FoundIt
SVN_NotThisOne:                         ; no match this entry, try next
        add     si,AbbrItemLen          ; point to the next pattern entry
        cmp     si,offset Com:EndAbbrTab
        jb      SVN_CompLoop
        ret                             ; none matched

SVN_FoundIt:
                                        ; si points to 4-char word
        mov     ah,040h                 ; DOS function write file
        mov     bx,1                    ; handle 1 = stdout
        mov     cx,4                    ; write 4 bytes
        mov     dx,si                   ; DS:DX points to string to write
        int     021h                    ; write mode name
        lea     dx,SpaceMsg             ; append a space
        Call    Say
        ret
ShowVModeName   Endp

;===============================================================

Parse   Proc    Near
;       parse the command line and put parms into internal format.
;       returns the video mode in DesVMode
;       returns Flag in Look to tell if looking only.
        call    CommandLine     ; get command line, result ES:DI, len CX
        call    LineToUC        ; convert to all upper case
        mov     bx,1            ; examine just the first parameter.
        call    nthParm         ; look at word, result ES:SI, len CX
        jcxz    NoWords
        mov     di,si           ; mode string e.g. MONO now in ES:DI
        call    GuessWord       ; what word is it? MONO CO80 etc.
                                ; result is DS:SI pointer to AbbrTab
        jc      NoMatch         ; Jmp if not a legal word
        mov     al,[si+AbbrMode]; get video mode number from table
        mov     desVMode,al     ; video mode to set
        mov     LookFlag,0      ; not just looking
        ret                     ; normal return

NoMatch:
                                ; no match, but might be a number
                                ; ES=DS:DI, CX has ascii number string
        mov     si,di           ; Get string in DS:SI, CX
        Call    AsciiToBin      ; returns result in DX:AX
                                ; If not a number will abort directly
                                ; to Trouble.
        or      dx,dx           ; make sure not too big
        jnz     Trouble         ; only al should have anything in it
        or      ah,ah
        jnz     Trouble
        mov     desVMode,al     ; video mode to set
        mov     LookFlag,0      ; not just looking
        ret                     ; normal return

NoWords:                        ; Null Command line
        mov     DesVMode,0
        mov     LookFlag,-1     ; just looking
        ret
Parse   EndP

;==============================================================

GuessWord       Proc    Near
;       on entry ES:DI points to word to guess. CX is length
;       on exit  DS:SI points to matching entry in AbbrTab
;       if no match, sets carry flag
        lea     si, AbbrTab             ; point to first possibility
Guess_CompLoop:
        push    di                      ; save addr, len word
        push    cx
        push    si                      ; save pointer to start of pattern
        cmp     cx,4
        jl      Guess_NotThisOne        ; if word is too short, this isn't it.
        mov     cx,4                    ; just compare the short pattern len
        repe cmpsb                      ; compare two strings
        je      Guess_FoundIt
Guess_NotThisOne:                       ; no match this entry, try next
        pop     si
        pop     cx
        pop     di
        add     si,AbbrItemLen          ; point to the next pattern entry
        cmp     si,offset Com:EndAbbrTab
        jb      Guess_CompLoop
        stc                             ; none matched
                                        ; mark failure
        ret                             ; return

Guess_FoundIt:
        pop     si                      ; entry in table that matched
        pop     cx
        pop     di
        clc                             ; success
        ret
GuessWord       Endp

;==============================================================

CommandLine Proc        Near
;       Gets command line string into ES:DI
;       Command line does not include the program name.
;       ES already set since we are a COM file
                                ; counted string at HEX 80
                                ; contains command line.
                                ; It has no trailing null.
        MOV     DI,81h
        XOR     CH,CH
        MOV     CL,DS:80h       ; CX contains length of command
        RET
CommandLine EndP

;==============================================================

LineToUC        Proc    Near
;       convert command line to all upper case
;       on entry ES:DI points to command line, CX is len
        jcxz    LineDone
        push    di
        push    cx
LineLoop:
        mov     al,ES:[di]
        cmp     al,'a'
        jb      FineAsIs
        cmp     al,'z'
        ja      FineAsIs
        sub     al,20H          ; convert a to A
        mov     ES:[di],al
FineAsIs:
        inc     di
        loop    LineLoop
        pop     cx
        pop     di
LineDone:
        ret
LineToUC        EndP

;==============================================================

NthParm Proc    Near
;       Parses string for Nth Parameter delimited by blanks
;       e.g.  "  bright blue" with BX=1 would give string "bright"
;       ES:DI - string to be parsed for parameters
;       CX - length of string
;       BX - which parm wanted 1=parm1 2=parm2 etc.
;       NthParm only finds one parm per call.
;       On exit ES:SI points to string and CX is its length.
;       If there is no parm, the length will be 0.
;       It also handles multiple leading/trailing blanks on parms.
        MOV     AL,20h          ; AL = blank  -- the search char
ParmLoop:
;       Remove leading blanks on parm
        JCXZ    NullParm        ; jump if null string
        REPE    SCASB           ; scan ES:DI forwards till hit non blank
                                ; DI points just after it
                                ; CX is one too small, or 0 if none found
        JE      NullParm        ; jump if entire string was blank
        INC     CX              ; CX is length of remainder of string
        DEC     DI              ; DI points to non-blank
        MOV     SI,DI           ; remember start of string
;       Search for terminating blank on parm
        JCXZ    NullParm        ; jump if null string
        REPNE   SCASB           ; scan ES:DI forwards till hit blank
                                ; DI points just after it
                                ; CX is one too small, or 0 if none found
        JNE     NoBlank         ; jump if entire string was non blank
        INC     CX              ; CX is length of remainder of string
        DEC     DI              ; backup DI to point to blank at string end
NoBlank:
                                ; DI=addr tail end of command string,
                                ; CX=len tail end of command string
                                ; SI=addr parm just parsed
;       Major loop for each parm
        DEC     BX
        JNZ     ParmLoop        ; loop once for each parm

        MOV     CX,DI
        SUB     CX,SI           ; CX is length of parameter.
        RET
NullParm:                       ; was no nth parameter
        MOV     CX,0
        RET
NthParm EndP

;========================================

ASCIIToBin      PROC    Near
;       on entry DS:SI points to start of decimal ASCII string of digits.
;       String should contain only the decimal digits 0..9.
;       If there are bad chars we abort.
;       CX contains length of string > 0
;       On exit DX:AX contains binary equivalent of string.
        PUSH    BX              ; save regs we will trash
        PUSH    CX
        PUSH    SI
        PUSH    DI
        XOR     AX,AX
        MOV     DX,AX           ; accumulate in DX:AX

OneDigitLoop:

; multiply accumulated number by 10
                                ; Works because 10*X = 2*X + 8*X
                                ; use DI:BX as working register
        SHL     AX,1
        RCL     DX,1            ; DX:AX = x*2
        MOV     BX,AX
        MOV     DI,DX
        SHL     BX,1
        RCL     DI,1
        SHL     BX,1
        RCL     DI,1            ; DI:BX = x*8
        ADD     BX,AX
        ADC     DI,DX           ; DI:BX = x*2 + x*8

; add on the next digit
        XOR     DX,DX
        MOV     AH,DH
        LODSB                   ; get next digit in AL
        SUB     AL,"0"          ; convert 1 digit ASCII to bin
        JB      NumTrouble      ; ensure 0..9
        CMP     AL,9
        JA      NumTrouble
        ADD     AX,BX           ; add it onto accumulated product
        ADC     DX,DI

        LOOP    OneDigitLoop    ; loop once for each digit

        POP     DI              ; restore regs
        POP     SI
        POP     CX
        POP     BX

        RET
NumTrouble:
;       Some problem, give standard Error message.
        jmp     Trouble
ASCIIToBin      ENDP

;==============================================================

SayDec PROC     NEAR
;       call with number in range 0..65535 in ax
;       converts it to ASCII and displays it on the screen
;       If it is 0 shows as 0.
;       leading 0's are suppressed.
;       field is exactly wide enough to hold the number.
;       No leading or trailing spaces.  DISPLAYED IN DECIMAL
        push    di              ; preserve di
        mov     bx,10D
        mov     di,5            ; work right to left building digits at PAD
SayDecLoop:
        dec     di
        xor     dx,dx           ; dx:ax / 10
        div     bx              ; ax=quot dx=remdr
        add     dl,'0'          ; convert digit to ASCII
        mov     pad[di],dl
        or      ax,ax
        jnz     SayDecLoop
SayDecDone:
;       Number is ready
        lea     dx,pad[di]
        call    Say
        pop     di
        ret
SayDec  endp

;==============================================================

Say     Proc
;       on entry DX points to a string to display
        MOV     AH,9
        Int     21h
        ret
Say     EndP


;==============================================================

Start   endp

;==========================
CODE    ends                    ; end of code segment
        end     Start
