unit img_prop;

{
1997 May 10  Allow for the requested file not existing.
1998 Mar 14  Update for revised image reading units
1998 Mar 27  Add GIF transparency info
             Remove obsolete JPEG stuff
1998 Oct 12  Handle JPEG images that have non-unity scale
             Allow for escape on form or button to close the form
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, image_rd, GIFimage;

type
  TfrmProperties = class(TForm)
    btnOK: TButton;
    PageControl1: TPageControl;
    FilePropsSheet: TTabSheet;
    TGAPropertiesSheet: TTabSheet;
    JPEGPropertySheet: TTabSheet;
    grpFileProperties: TGroupBox;
    Label17: TLabel;
    Label18: TLabel;
    lblFilename: TLabel;
    lblFolder: TLabel;
    grpTGAInfo: TGroupBox;
    lblHeight: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    lblIDLength: TLabel;
    Label25: TLabel;
    lblCoMapType: TLabel;
    Label27: TLabel;
    lblImageType: TLabel;
    lblIndex: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    lblLength: TLabel;
    Label33: TLabel;
    lblXOrigin: TLabel;
    lblYOrigin: TLabel;
    Label36: TLabel;
    lblPixelSize: TLabel;
    Label38: TLabel;
    lblBits: TLabel;
    Label40: TLabel;
    Label41: TLabel;
    lblPixelAttributes: TLabel;
    Label43: TLabel;
    lblOrigin: TLabel;
    Label45: TLabel;
    lblInterlace: TLabel;
    lblWidth: TLabel;
    grpImageProperties: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    lblImgWidth: TLabel;
    lblImgHeight: TLabel;
    grpJPEGInfo: TGroupBox;
    Label3: TLabel;
    lblJWidth: TLabel;
    Label4: TLabel;
    lblJHeight: TLabel;
    Label5: TLabel;
    lblJNumComponents: TLabel;
    Label6: TLabel;
    lblJPEGColourSpace: TLabel;
    grpDecompProc: TGroupBox;
    Label7: TLabel;
    lblJOutColourSpace: TLabel;
    Label8: TLabel;
    lblJOutGamma: TLabel;
    Label9: TLabel;
    lblJOutputWidth: TLabel;
    Label10: TLabel;
    lblJOutputHeight: TLabel;
    Label11: TLabel;
    lblJOutColComps: TLabel;
    Label12: TLabel;
    lblJOutComponents: TLabel;
    Label13: TLabel;
    lblJRdcBufHeight: TLabel;
    Label14: TLabel;
    lblInputBits: TLabel;
    Label15: TLabel;
    lblDisplayBits: TLabel;
    Label16: TLabel;
    lblFileSize: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    lblImageBytes: TLabel;
    lblCompression: TLabel;
    GIFPropertiesSheet: TTabSheet;
    GroupBox1: TGroupBox;
    Label24: TLabel;
    Label26: TLabel;
    lblTransparent: TLabel;
    lblTransparentIndex: TLabel;
    procedure btnOKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
    filename: string;
    image: TPicture;
  end;

var
  frmProperties: TfrmProperties;

implementation

uses JPEG;

{$R *.DFM}

procedure TfrmProperties.btnOKClick(Sender: TObject);
begin
  Hide;
end;

procedure TfrmProperties.FormShow(Sender: TObject);

  function bytes_to_word (lo, hi:byte): word;
  var
    w: word;
  begin
    w := hi;
    Result := w shl 8 + lo;
  end;

var
  img_width, img_height, input_bits: word;

  TGA_header: TTGAHeader;
  index, length: word;
  x_origin, y_origin: word;
  AttBits, OrgBit, IntrLve: byte;
  uncompressed, compressed: integer;
  sr: TSearchRec;
  pixel_format: TPixelFormat;
  subsample: integer;
begin
  // Hide the pages we might not be displaying
  JPEGPropertySheet.TabVisible := False;
  TGAPropertiesSheet.TabVisible := False;
  GIFPropertiesSheet.TabVisible := False;
  FilePropsSheet.Visible := False;
  Caption := '(no file currently selected)';

  if FindFirst (filename, faAnyFile, sr) <> 0 then
    begin
    FindClose (sr);
    Exit;
    end;

  // first the format independent things that are to be displayed
  PageControl1.ActivePage := FilePropsSheet;
  lblFilename.Caption := ExtractFilename (filename);
  lblFilename.Hint := lblFilename.Caption;
  lblFolder.Caption := ExtractFilepath (ExpandFileName (filename));
  lblFolder.Hint := lblFolder.Caption;

  Caption := 'Properties for ' + lblFilename.Caption;
  FilePropsSheet.Visible := True;
  compressed := sr.Size;
  FindClose (sr);
  lblFileSize.Caption := IntToStr (compressed) + ' bytes';

  pixel_format := pf8bit;
  input_bits := 8;
  subsample := 1;
  if image.Graphic is Graphics.TBitmap
  then pixel_format := Graphics.TBitmap (image.Bitmap).PixelFormat
  else if image.Graphic is TDJTImage
       then pixel_format := TDJTImage (image.Graphic).InputPixelFormat
       else if image.Graphic is TDJTJPEGImage
            then with TDJTJPEGImage (image.Graphic) do
              begin
              case PixelFormat of
                 jf8bit: pixel_format := pf8bit;
                jf24bit: pixel_format := pf24bit;
              end;
              case Scale of
                jsHalf: subsample := 2;
                jsQuarter: subsample := 4;
                jsEighth: subsample := 8;
              end;
              end;

  lblImgHeight.Caption := IntToStr (image.Height * subsample);
  lblImgWidth.Caption := IntToStr (image.Width * subsample);
  case pixel_format of
     pf8bit: input_bits := 8;
    pf15bit: input_bits := 15;
    pf16bit: input_bits := 16;
    pf24bit: input_bits := 24;
    pf32bit: input_bits := 32;
  end;
  lblInputBits.Caption := IntToStr (input_bits);

  uncompressed := image.Height * subsample *
                  image.Width * subsample * input_bits div 8;
  lblImageBytes.Caption := IntToStr (uncompressed);
  lblCompression.Caption := Format ('%.2n:1', [uncompressed / compressed]);

  lblDisplayBits.Caption := IntToStr (DisplayBitsPerPixel);

  if image.Graphic is TGIF then with TGIF (image.Graphic) do
    begin
    if Transparent
    then
      begin
      lblTransparent.Caption := 'Yes';
      lblTransparentIndex.Caption := IntToStr (TransparentIndex);
      end
    else
      begin
      lblTransparent.Caption := 'No';
      lblTransparentIndex.Caption := 'N/A';
      end;
    GIFPropertiesSheet.TabVisible := True;
    end;

  if image.Graphic is TDJTImage then with TDJTImage (image.Graphic) do
    if GetImageFormat = ifTGA then
      begin
      TGA_header := GetTGAHeader;
      with TGA_header do
        begin
        img_height := bytes_to_word (Height_lo, Height_hi);
        img_width := bytes_to_word (Width_lo, Width_hi);
        index := bytes_to_word (Index_lo, Index_hi);
        length := bytes_to_word (Length_lo, Length_hi);
        x_origin := bytes_to_word (X_org_lo, X_org_hi);
        y_origin := bytes_to_word (Y_org_lo, Y_org_hi);

        lblWidth.Caption := IntToStr (img_width);
        lblHeight.Caption := IntToStr (img_height);
        lblIDLength.Caption := IntToStr (IDLength);
        if CoMapType = 0
        then lblCoMapType.Caption := '0  (none)'
        else lblCoMapType.Caption := IntToStr (CoMapType);
        case ImgType of
           1: lblImageType.Caption := IntToStr (ImgType) + '  (Map RGB)';
           2: lblImageType.Caption := IntToStr (ImgType) + '  (Raw RGB)';
           3: lblImageType.Caption := IntToStr (ImgType) + '  (Raw Mono)';
           9: lblImageType.Caption := IntToStr (ImgType) + '  (Map Encode)';
          10: lblImageType.Caption := IntToStr (ImgType) + '  (Raw Encode)';
          11: lblImageType.Caption := IntToStr (ImgType) + '  (Mono Encode)';
        else
          lblImageType.Caption := IntToStr (ImgType) + ' (unknown)';
        end;
        lblIndex.Caption := IntToStr (Index);
        lblLength.Caption := IntToStr (Length);
        lblXOrigin.Caption := IntToStr (x_origin);
        lblYOrigin.Caption := IntToStr (y_origin);
        lblPixelSize.Caption := IntToStr (PixelSize);
        lblBits.Caption := IntToHex (Bits, 2) + ' (hex)';
        AttBits := Bits and $0F;
        lblPixelAttributes.Caption := IntToHex (AttBits, 2) + ' (hex)';
        OrgBit := (Bits shr 5) and $01;
        if OrgBit = 1
          then lblOrigin.Caption := 'upper left'
          else lblOrigin.Caption := 'lower left';
        IntrLve := (Bits shr 6) and $03;
        case IntrLve of
          0: lblInterlace.Caption := 'none';
          1: lblInterlace.Caption := 'two way';
          2: lblInterlace.Caption := 'four way';
          3: lblInterlace.Caption := '(unknown)';
        end;
        end;
      TGAPropertiesSheet.TabVisible := True;
      end;
end;

procedure TfrmProperties.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #27 then Close;
end;

end.

