unit img_form;

{
Revison history:

V1.0.0   1997 Apr 05  First released version
V1.1.0   1997 May 04  Add 16-bit BMP support in Image_Rd.pas
V1.2.0   1997 May 18  Delphi 3.0
V1.2.2   1997 May 24  Correct interlaced reading code in GIF, overwriting buffer
V1.2.4   1997 Jul 06  Add '.JPE' as valid file extension (for .JPEG)
                      Add About box reading version info from the .EXE file
                      Add grey-scale JPEG input
V1.2.6   1997 Nov 15  Recompile for Borland Delphi 3.01
V1.3.0   1998 Mar 14  Recompile for Borland Delphi 3.01
                      Faster JPEG image loading by using Borland's JPEG unit
                      Make image dither after image loading
                      Get About box, Copyright from the .EXE version information
                      Make properties form Modal (or wrong file info results)
                      Allow escape key to close the form
V1.3.2   1998 Mar 27  Update GIFimage unit to give transparency data
                      GIF unit is now self-registering (for .GIF files)
                      Add version information to form title
                      Don't lower case the file name
V2.0.0   1998 Oct 12  Version for Delphi 4.0
                      Add auto resizing for JPEG images
V2.0.2   1998 Oct 24  Add auto resizing for TBitmaps
                      Correct handling of very small images, incorrectly stretched.
V2.0.4   1998 Nov 20  Better error messages for file not found and bad formats
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Menus, image_rd, GIFimage, VersInfo, StdCtrls;

type
  TMainForm = class(TForm)
    Image1: TImage;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    Open1: TMenuItem;
    OpenDialog1: TOpenDialog;
    Properties1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    VersionInfoResource1: TVersionInfoResource;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Properties1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Image1Progress(Sender: TObject; Stage: TProgressStage;
      PercentDone: Byte; RedrawNow: Boolean; const R: TRect;
      const Msg: String);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    function new_image (filename: String): boolean;  // Loads a named image file
  public
    { Public declarations }
    image_filename: string;                  // The image file name
  end;

var
  MainForm: TMainForm;

implementation

uses Math, JPEG, img_prop, AboutFrm;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  // Enable the timer.  Allows things to happen after all window creation is complete.
  Timer1.Enabled := True;
end;

procedure TMainForm.Timer1Timer(Sender: TObject);
var
  OK: boolean;
  s: string;
begin
  Timer1.Enabled := False;     // stop recurring timer events
  if ParamCount > 0 then       // if the use has specified a file, show it
    try
      ShowHint := False;
      ok := new_image (ParamStr (1));  // try to show the user's file
      if not OK then Close;
    except
      on E: EInvalidGraphic do   // Was there an error?
        begin
        s := 'The image viewer encountered an error reading the file: ' +
             ParamStr (1) + '.  Most likely causes are that the file is corrupt, ' +
             'has the wrong file extension for the graphic in the file, ' +
             'or uses a version of the file format that this program cannot understand.' +
             #13 + #13 + 'The actual error message returned from the graphics ' +
             'reading routine was: ' + E.Message;
        Application.MessageBox (PChar (s),
                                'Error reading graphics file',
                                MB_OK or MB_ICONINFORMATION);
        Close;
        end;
    end;
end;

function TMainForm.new_image (filename: String): boolean;
var
  f: TSearchRec;
  reduce: Single;
  jpeg_scale: integer;
  max_width, max_height: integer;
  s: string;
begin
  Result := False;  // Assume we failed to read the file OK
  if FindFirst (filename, faAnyFile, f) <> 0  // Test if the file exists
  then   // File doesn't exist - tell the user the bad news
    begin
    s := 'The image viewer could not find the file: ' + ParamStr (1) +
         '.  Most likely causes are that the file name is incorrect, ' +
         'or that your shortcut does not have the "%1" following the ' +
         'file name of the executable program.  Note that the quotation ' +
         'marks are required so that file names with embedded spaces ' +
         'are correctly passed to the program.';
    Application.MessageBox (PChar (s),
        PChar ('Cannot find file: "' + filename + '"'),
        MB_OK or MB_ICONINFORMATION);
    end
  else
    begin   // Try to make the iamge fit the screen if it is too large
    max_width := GetSystemMetrics (SM_CXFULLSCREEN);
    max_height := GetSystemMetrics (SM_CYFULLSCREEN);
    // Get the full filename
    image_filename := ExtractFileDir (filename) + '\' + f.Name;
    Image1.Stretch := False;
    Image1.Picture.LoadFromFile (filename);    // Load the image
    if Image1.Picture.Graphic is TDJTJPEGImage
    then
      with TDJTJPEGImage (Image1.Picture.Graphic) do
      begin
      // See how much we should rescale the image down
      reduce := Max (Width / max_width, Height / max_height);
      if reduce < 1
        then reduce := 1    // no need to rescale down, image fits in display
        else Image1.Stretch := True;  // yes, we need to rescale
      // Get the nearest whole number reduction below the reduction factor
      jpeg_scale := Trunc (reduce);
      // We can save loading time by using the sub-sampling functions of JPEG
      case jpeg_scale of
        0, 1: Scale := jsFullSize;
        2, 3: Scale := jsHalf;
        4..7: Scale := jsQuarter;
      else
        Scale := jsEighth;
      end;
      // If we've sub-sampled, we need to reduce the image less
      case Scale of
        jsHalf: reduce := 0.5 * reduce;
        jsQuarter: reduce := 0.25 * reduce;
        jsEighth: reduce := 0.125 * reduce;
      end;
      // Compute the final client size to just fit the reduced image
      ClientWidth := Round (Width / reduce);
      ClientHeight := Round (Height / reduce);
      end
    else
      if Image1.Picture.Graphic is TBitmap
      then  // similar code to above, no scaling, simply a reduced bitmap
        begin
        reduce := Max (Image1.Picture.Bitmap.Width / max_width,
                       Image1.Picture.Bitmap.Height / max_height);
        if reduce < 1
          then reduce := 1
          else Image1.Stretch := True;
        ClientWidth := Round (Image1.Picture.Bitmap.Width / reduce);
        ClientHeight := Round (Image1.Picture.Bitmap.Height / reduce);
        end
      else
        begin
        ClientWidth := Image1.Picture.Width;
        ClientHeight := Image1.Picture.Height;
        end;
    Position := poScreenCenter;  // Re-position after possible size change
    Caption := ExtractFilename (image_filename) +
             ' - David''s Image Viewer - Version ' + VersionInfoResource1.FileVersion.AsString;
    Application.Title := Caption;
    if Image1.Picture.Graphic is TBitmap
    then ApplyDither (Image1.Picture.Bitmap)
    else
      if Image1.Picture.Graphic is TDJTImage
      then TDJTImage (Image1.Picture.Graphic).Dither;
    Result := True;    // Note that we succeded in reading the file OK.
    end;
  FindClose (f);
end;

procedure TMainForm.Open1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then new_image (OpenDialog1.FileName);
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.Properties1Click(Sender: TObject);
begin
  with frmProperties do
    begin
    filename := image_filename;
    image := Image1.Picture;
    ShowModal;
    end;
end;

procedure TMainForm.About1Click(Sender: TObject);
begin
  with AboutBox1 do
    begin
    // Blank filename for version resource means use Application.EXEname.
    // Build up the About Box from the version info in the .EXE file
    Comments.Caption := VersionInfoResource1.Comments;
    Version.Caption := 'Version: ' + VersionInfoResource1.FileVersion.AsString;
    Copyright.Caption := VersionInfoResource1.LegalCopyright;
    ShowModal;
    end;
end;

procedure TMainForm.Image1Progress(Sender: TObject; Stage: TProgressStage;
  PercentDone: Byte; RedrawNow: Boolean; const R: TRect;
  const Msg: String);
begin
  case Stage of
    psEnding: if Image1.Picture.Graphic is TDJTJPEGImage
                then TDJTJPEGImage (Image1.Picture.Graphic).Dither;
  end;
end;

procedure TMainForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Ord (Key) = VK_ESCAPE then Close;
end;

end.

