unit soleff;

interface

uses
	Windows, Messages;

const
	UPC_OPEN = WM_USER + 3469;
	UPC_CHANGED = WM_USER + 3470;
	UPC_BTNPRESS = WM_USER + 3471;
	UPC_PROCESS = WM_USER + 3472;
	UPC_CLOSE = WM_USER + 3473;
	UPC_IMAGECLICK = WM_USER + 3474;

	UPC_PREVIEW = WM_USER + 4469;
	UPC_ACCEPT = WM_USER + 4470;
	UPC_CANCEL = WM_USER + 4471;
	UPC_NEW = WM_USER + 4472;
	UPC_PARAM = WM_USER + 4473;
	UPC_PROGRESS = WM_USER + 4474;
	UPC_PROGRESS_MAX = WM_USER + 4475;
	UPC_REFRESH_ON = WM_USER + 4476;
	UPC_REFRESH_OFF = WM_USER + 4477;

	PT_VALUE = $00000;
	PT_CAPTION = $10000;
	PT_MINIMUM = $20000;
	PT_MAXIMUM = $30000;
	PT_INCREMENT = $40000;
	PT_DECIMAL = $50000;

	UPCDESC : PChar =	'Ver=1.72' + #13 +
				'Menu=SolarizeD' + #13 +
				'Name=Solarize in Delphi 3.0' + #13 +
				'Copyright=(c)1998 Arfer' + #13 +
				'Opt=PW' + #13 +
				'Par1=S,R Treshold,0,255,128' + #13 +
				'Par2=S,G Treshold,0,255,128' + #13 +
				'Par3=S,B Treshold,0,255,128' + #13 +
				'Par4=C,Lock Sliders,1' + #13 +
				'Par5=C,Inverse,0' + #13 +
				'Help=UPC.HLP,100' + #13;

function UPCGETDESC : PChar; export;
function UPCPROCESS(cm : integer; d : Pointer) : integer; pascal; export;

implementation

type
	TPixel = record
		BB : Byte;
		GG : Byte;
		RR : Byte;
		ss : Byte;
	end; {TPixel}
	PPixel = ^TPixel;
	TPixelArray = array[0..0] of TPixel;
	PPixelArray = ^TPixelArray;

	TUPImageControlStruct = record
		Addr : PInteger;
		SX, SY : integer;
	end; {TUPImageControlStruct}
	PUPImageControlStruct = ^TUPImageControlStruct;

	TUPImageStruct = record
		PSrc : PPixelArray;
		PDes : PPixelArray;
		SX, SY : integer;
		MinX, MinY : integer;
		MaxX, MaxY : integer;
		Selection : integer;
		ProgBar : integer;
		DrawCol : integer;
		BackCol : integer;
		Cos, Sin : PInteger;
		HWND : THandle;
		Bufs : PUPImageControlStruct;
		Index : integer;
	end; {TUPImageStruct}
	PUPImageStruct = ^TUPImageStruct;

	TParStruct = record
		RTresh, GTresh, BTresh : integer;
		LockSliders : integer; {0: false, 1: true}
		Inverse : integer; {0: false, 1: true}
	end; {TParStruct}
	PParStruct = ^TParStruct;

var ImageStruct : TUPImageStruct;
	Parameters : TParStruct;
	Locking : boolean;

function UPCGETDESC : PChar;
begin
	Result := UPCDESC;
end; {UPCGETDESC}

procedure DoEffect;
var i, j : integer;
	ps, pd : PPixelArray;
	pps, ppd : PPixel;
begin
	with ImageStruct do
	begin
		for i := MinY to MaxY do
		begin
			ps := @PSrc^[i * Sx];
			pd := @PDes^[i * Sx];
			for j := MinX to MaxX do
				if ((Selection <> 0) and (ps^[j].ss <> 0)) or (Selection = 0) then
				begin
					pps := @ps^[j];
					ppd := @pd^[j];
					if ppd^.BB >= Parameters.BTresh then
						ppd^.BB := 255 - pps^.BB;
					if ppd^.GG >= Parameters.GTresh then
						ppd^.GG := 255 - pps^.GG;
					if ppd^.RR >= Parameters.RTresh then
						ppd^.RR := 255 - pps^.RR;

					if Parameters.Inverse <> 0 then
					begin
						ppd^.BB := 255 - pps^.BB;
						ppd^.GG := 255 - pps^.GG;
						ppd^.RR := 255 - pps^.RR;
					end; {if}
				end; {if}
		end; {for}
	end; {with}
end; {DoEffect}

function UPCPROCESS(cm : integer; d : Pointer) : integer;
var tmpParam : TParStruct;
	i : integer;

	procedure IncParamValue(var param : integer; value : integer);
	begin
		Inc(param, value);
		if param < 0 then
			param := 0
		else if param > 255 then
			param := 255;
	end; {IncParamValue}

begin
	Result := 1;
	case cm of
		UPC_OPEN :
		begin
			ImageStruct := PUPImageStruct(d)^;
			Parameters.RTresh := 128;
			Parameters.GTresh := 128;
			Parameters.BTresh := 128;
			Parameters.LockSliders := 1;
			Parameters.Inverse := 0;
			Locking := false;
		end;

		UPC_CHANGED :
		begin
			if Locking then
				exit;
			tmpParam := PParStruct(d)^;
			{If one slider is changed, the others go with it}
			if tmpParam.LockSliders <> 0 then
			begin
				Parameters.LockSliders := tmpParam.LockSliders;
				Parameters.Inverse := tmpParam.Inverse;
				i := tmpParam.RTresh - Parameters.RTresh;
				if i <> 0 then
				begin
					Locking := true;
					Parameters.RTresh := tmpParam.RTresh;
					IncParamValue(Parameters.GTresh, i);
					IncParamValue(Parameters.BTresh, i);
					SendMessage(ImageStruct.HWND, UPC_PARAM, PT_VALUE or 2, Parameters.GTresh);
					SendMessage(ImageStruct.HWND, UPC_PARAM, PT_VALUE or 3, Parameters.BTresh);
					Locking := false;
				end
				else
				begin
					i := tmpParam.GTresh - Parameters.GTresh;
					if i <> 0 then
					begin
						Locking := true;
						Parameters.GTresh := tmpParam.GTresh;
						IncParamValue(Parameters.RTresh, i);
						IncParamValue(Parameters.BTresh, i);
						SendMessage(ImageStruct.HWND, UPC_PARAM, PT_VALUE or 1, Parameters.RTresh);
						SendMessage(ImageStruct.HWND, UPC_PARAM, PT_VALUE or 3, Parameters.BTresh);
						Locking := false;
					end
					else
					begin
						i := tmpParam.BTresh - Parameters.BTresh;
						if i <> 0 then
						begin
							Locking := true;
							Parameters.BTresh := tmpParam.BTresh;
							IncParamValue(Parameters.RTresh, i);
							IncParamValue(Parameters.GTresh, i);
							SendMessage(ImageStruct.HWND, UPC_PARAM, PT_VALUE or 1, Parameters.RTresh);
							SendMessage(ImageStruct.HWND, UPC_PARAM, PT_VALUE or 2, Parameters.GTresh);
							Locking := false;
						end; {if}
					end; {else}
				end; {else}
			end
			else
				Parameters := tmpParam;
		end;

		UPC_PROCESS :
		begin
			ImageStruct := PUPImageStruct(d)^;
			DoEffect;
		end;

	end; {case}
end; {UPCPROCESS}

end.
