//-----------------------------------------------------------------------------------------------
// BRIGCONT.CPP for BRIGCONT.UPC (C)1998 MEGALUX Ltd.
//-----------------------------------------------------------------------------------------------

#include "upc.h"

USERC("brigcont.rc");
//---------------------------------------------------------------------------
#define GRAD	256 	/* gradation levels */

#define floor(x) ((x)<0 ? (int)((x)-0.9999) : (int)(x))
#define ceil(x) ((x)<0 ? (int)(x) : (int)(x+0.9999))

struct UPImageStruct UPP;

int TuneHist[GRAD*10];
float TuneMean;
unsigned char Tune[GRAD];

struct D {
	int Bri, Con;
} Data;

//-----------------------------------------------------------------------------------------------
UPCDESC_EXPORT
	"Ver=1.53\rMenu=&Brightness/Contrast\rName=Brightness/Contrast\rIcon=BRIGCONT\r"
	"Copyright=(c)1998 MEGALUX Ltd.\rOpt=PW\rPar1=I,Brightness Value,-99,99,0\r"
	"Par2=I,Contrast Value,-99,999,0\rPar3=B,Optimize Histogram\rHelp=UPC.HLP,200";


int WINAPI DllEntryPoint(HINSTANCE, unsigned long, void*)
{
	return 1;
}

extern "C" int __declspec(dllexport) __pascal UPCProcess(int cm, void *d)
{
	register int x;
	float mulval, addval;

	switch(cm) {
		case UPC_OPEN:				// INITIALIZATION WITH FULL PICTURE
			unsigned *b, *e;
			int yval;

			// saving Picture data (dimensions, source, destination, etc.)

			UPP = *(UPImageStruct *)d;

			// initializing the histogram array

			memset(TuneHist, 0, GRAD*10*sizeof(int));

			// building the histogram

			b = UPP.PSrc;
			e = b + UPP.SX*UPP.SY;
			while(b < e) {
				yval = RED(*b)*3 + GREEN(*b)*5.9 + BLUE(*b)*1.1;
				TuneHist[yval]++;
				b++;
			}

			// calculating mean value

			TuneMean = 0;
			for(x=0; x<GRAD*10; x++)
				TuneMean += TuneHist[x]*x;
			TuneMean /= UPP.SX*UPP.SY*10.0;
			break;
		case UPC_CHANGED:			// PARAMETERS CHANGED - STORING NEW VALUES (comes once after INIT, too)
			int temp;

			Data = *(D *)d;
			// calculating transformation
			mulval = 1+Data.Con/99.0;
			addval = TuneMean+Data.Bri*GRAD/75.0;
			for(x=0; x<GRAD; x++) {
				temp = (x-TuneMean)*mulval+addval;
				if(temp < 0)			Tune[x] = 0;
				else if(temp >= GRAD)	Tune[x] = GRAD-1;
				else					Tune[x] = (unsigned char)temp;
			}
			break;
		case UPC_BTNPRESS:			// OPTIMIZING PARAMETERS BASED ON THE HISTOGRAM
			register int n;
			float min, max;

			min = 0;
			for(n=0; n<GRAD*10 && !TuneHist[n]; n++)
				min++;
			min /= 10;
			max = GRAD*10-1;
			for(n=GRAD*10-1; n>=0 && !TuneHist[n]; n--)
				max--;
			max /= 10;

			// calculating the transformation of RGB components based on equations
			//   0 = (min - TuneMean)*mulval + addval;
			//   GRAD-1 = (max - TuneMean)*mulval + addval;

			if(max-min > 0.09) {	// if there is something we can optimize
				addval = (GRAD-1)*(min-TuneMean)/(min-max);
				addval = floor((addval-TuneMean)*75/GRAD + 0.5);

				mulval = (GRAD-1.0)/(max-min);
				mulval = ceil((mulval-1)*99);

				if(mulval < -99)	mulval = -99;
				if(mulval > 999)	mulval = 999;
				if(addval < -99)	addval = -99;
				if(addval >  99)	addval =  99;
			}
			else {
				addval = mulval = 0;
			}

			PostMessage(UPP.Handle, UPC_PARAM, 1, addval);	// the new Brightness
			PostMessage(UPP.Handle, UPC_PARAM, 2, mulval);	// and the new Contrast

			break;
		case UPC_PROCESS:			// PROCESSING PICTURE
			register int y;
			int sx, sy, gap;
			unsigned *src, *des;

			// saving Picture data (it may change every time PROCESS is called...)
			// calculating important dimensions and variables

			UPP = *(UPImageStruct *)d;
			sx = UPP.MaxX-UPP.MinX+1;
			sy = UPP.MaxY-UPP.MinY+1;
			gap = UPP.SX - sx;
			src = UPP.PSrc + UPP.MinY*UPP.SX + UPP.MinX;
			des = UPP.PDes + UPP.MinY*UPP.SX + UPP.MinX;

			for(y=0; y<sy; y++,src+=gap,des+=gap) {
				for(x=0; x<sx; x++,src++,des++)
					if(!UPP.Selection || SELECTED(*src))
						*des = COLOR(Tune[RED(*src)], Tune[GREEN(*src)], Tune[BLUE(*src)]);
				if(UPP.ProgBar)
					if(SendMessage(UPP.Handle, UPC_PROGRESS, y+1, 0))
						break;
			}
			break;
	}

	return 0;
}

//-----------------------------------------------------------------------------------------------
// END OF MODULE
//-----------------------------------------------------------------------------------------------

