# func2raw.awk: generates 3d-RAW-triangledata out of a 3d-function

function tan(x)   { return sin(x)/cos(x); }
function asin(x)  { return atan2(x,sqrt( (1-x)*(1+x) ) ); }
function acos(x)  { return atan2(sqrt( (1-x)*(1+x) ),x ); }
function atan(x)  { return atan2(x,1); }
function abs(x)   { if (x<0) return -x; else return x; }
function e()      { return exp(1); }
function pi()     { return atan2(0,-1); }

#- THE 3D FUNCTION: -----------------------------------------------------------

function f(x,y) {

 return cos((x^2+y^2)/4)/(3+x^2+y^2);        # A sombrero
# return -y/(9+x^2+y^2);                      # A mountain and a crater
# return 1/(9+x^2+(y-3)^2)+1/(9+x^2+(y+3)^2); # Two mountains
# return 7*x^2-y^3;                           # A hanging valley
# return y^2-x^2;                             # A saddle
# return y^2/5-3*abs(x);                      # A sway-back roof
# return (y^2+1/10)/(x^2+y^2+1/10);           # A pinched ridge
# return y*(3*x^2-y^2);                       # A monkey saddle
# return -sqrt(abs(x*y));                     # Intersecting ridges
# return -sqrt(abs(x))-sqrt(abs(y));          # A pagoda roof
# return sqrt(abs(x))-sqrt(abs(y));           # A ridge intersecting a valley
# return -y*sqrt(abs(x));                     # A ridge that becomes a valley
# return 50/(50+((x^2+y^2)^(1/2)-37/10)^2)-1; # A volcano
# return exp(-x/9)*(pi()/2-atan(y));          # A surfer's perfect wave
# return atan(-y,x+1/10);                     # A cliff is born
# return -cos(3*pi()*x/10)*cos(pi()*y/10);    # Two separated mountains
# return -cos(3*pi()*x/10)*sin(pi()*y/5);     # Three mountains

}

BEGIN {   START = -5;  STOP = 5;  RES = 25;

#------------------------------------------------------------------------------

  d=(STOP-START)/RES;  MIN=1e10; MAX=-1e10;
  for ( x=START; x<=STOP; x+=d ) {
    for ( y=START; y<=STOP; y+=d ) {
      z=f(x,y); if (z<MIN) MIN=z; if (z>MAX) MAX=z;
    }
  }
  if (MIN != MAX) SCAL=(STOP-START)/(MAX-MIN)/2; else SCAL=1;
  for ( x=START; x<=STOP; x+=d ) {
    for ( y=START; y<=STOP; y+=d ) {
      x0=x;   y0=y;   z0=f(x0,y0)*SCAL;
      x1=x;   y1=y+d; z1=f(x1,y1)*SCAL;
      x2=x+d; y2=y;   z2=f(x2,y2)*SCAL;
      x3=x+d; y3=y+d; z3=f(x3,y3)*SCAL;
      print x0, z0, y0, x1, z1, y1, x2, z2, y2;
      print x2, z2, y2, x1, z1, y1, x3, z3, y3;
    }
  }
}
