unit Unit2t;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Menus, JPeg;

type
  TForm2 = class(TForm)
    Image1: TImage;
    SaveDialog1: TSaveDialog;
    PopupMenu1: TPopupMenu;
    Close1: TMenuItem;
    N1: TMenuItem;
    SaveToBPMfile1: TMenuItem;
    SaveToJpegfile1: TMenuItem;
    N40Compress1: TMenuItem;
    N60Compress1: TMenuItem;
    N80Compress1: TMenuItem;
    N20Compress1: TMenuItem;
    procedure Close1Click(Sender: TObject);
    procedure SaveToBPMfile1Click(Sender: TObject);
    procedure N40Compress1Click(Sender: TObject);
    procedure N60Compress1Click(Sender: TObject);
    procedure N80Compress1Click(Sender: TObject);
    procedure N20Compress1Click(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    procedure SaveToJpegfile(Compress: Integer);
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

uses Test1;

{$R *.DFM}

procedure TForm2.Close1Click(Sender: TObject);
begin
  Hide;
end;

procedure TForm2.SaveToBPMfile1Click(Sender: TObject);
begin
  SaveDialog1.FileName:='';
  SaveDialog1.DefaultExt := '.BMP';
  SaveDialog1.Filter := 'BMP files (*.BMP)|*.BMP';
  if SaveDialog1.Execute then
  begin
    Image1.Picture.SaveToFile(SaveDialog1.FileName);
  end;
end;

procedure TForm2.SaveToJpegfile(Compress: Integer);
var
  II: TJpegImage;
begin
  SaveDialog1.FileName:='';
  SaveDialog1.DefaultExt := '.JPG';
  SaveDialog1.Filter := 'Jpeg files (*.JPG)|*.JPG';
  if SaveDialog1.Execute then
  begin
    II := TJpegImage.Create;
    try
      II.Assign(Image1.Picture.Bitmap);
      II.CompressionQuality := Compress;
      II.PixelFormat := jf24Bit;
      II.Grayscale := False;
      II.ProgressiveDisplay := False;
      II.SaveToFile(SaveDialog1.FileName);
    finally
      II.Free;
    end;
  end;
end;

procedure TForm2.N40Compress1Click(Sender: TObject);
begin
  SaveToJpegfile(60);
end;

procedure TForm2.N60Compress1Click(Sender: TObject);
begin
  SaveToJpegfile(40);
end;

procedure TForm2.N80Compress1Click(Sender: TObject);
begin
  SaveToJpegfile(20);
end;

procedure TForm2.N20Compress1Click(Sender: TObject);
begin
  SaveToJpegfile(80);
end;

procedure TForm2.FormKeyPress(Sender: TObject; var Key: Char);
begin
 if key = #27 then Close;
end;

end.

