unit Test1;

interface

uses
  Windows, Messages, SysUtils, Jpeg, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Gauges, ComCtrls, Stereogram;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Gauge1: TGauge;
    Bevel1: TBevel;
    RadioGroup1: TRadioGroup;
    Image1: TImage;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Label4: TLabel;
    Edit4: TEdit;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    Label5: TLabel;
    Edit5: TEdit;
    RadioGroup2: TRadioGroup;
    Label6: TLabel;
    Edit6: TEdit;
    Label7: TLabel;
    Bevel4: TBevel;
    Label8: TLabel;
    TrackBar1: TTrackBar;
    Label9: TLabel;
    lbInten: TLabel;
    Label10: TLabel;
    RadioGroup3: TRadioGroup;
    RadioGroup4: TRadioGroup;
    Bevel5: TBevel;
    Bevel6: TBevel;
    Label11: TLabel;
    Label12: TLabel;
    Image2: TImage;
    Image3: TImage;
    Label13: TLabel;
    Label14: TLabel;
    OpenDialog1: TOpenDialog;
    Label15: TLabel;
    Label16: TLabel;
    Edit7: TEdit;
    Label17: TLabel;
    Label18: TLabel;
    Bevel7: TBevel;
    Stereogram1: TStereogram;
    procedure LoadImage(Sender: TImage; FileName: string);
    procedure Button1Click(Sender: TObject);
    procedure Stereogram1Generate(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure Image3Click(Sender: TObject);
    procedure Zmena(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SetSepar(Sender: TObject);
  private
    { Private declarations }
    LastType: Integer;
  public
    { Public declarations }
    procedure SetParams;
    procedure GetParams;
    procedure SetJPEGOptions(Sender: TImage);
  end;

var
  Form1: TForm1;

implementation

uses Unit2t;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
 var bbb:Tbitmap;
begin
  Gauge1.Progress:=0;
  Application.ProcessMessages;
  StereoGram1.generate;
  Form2.Width := StereoGram1.Width + 10;
  Form2.Height := StereoGram1.height + 30;
  Form2.Image1.Width := StereoGram1.Width;
  Form2.Image1.Height := StereoGram1.Height;
  Form2.Image1.Picture.Bitmap.Assign(StereoGram1.ResultMap);
  Form2.Show;
end;

procedure TForm1.Stereogram1Generate(Sender: TObject);
begin
  if Stereogram1.Progress - Gauge1.Progress > 3  then
    Gauge1.Progress := Stereogram1.Progress;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  lbInten.Caption := IntToStr(TrackBar1.Position);
  Zmena(Sender);
end;

procedure TForm1.Image2Click(Sender: TObject);
begin
  OpenDialog1.Filter := 'Image files (*.BMP,*.JPG)|*.BMP;*.JPG';
  OpenDialog1.Filterindex := 0;
  if OpenDialog1.Execute then
  begin
    LoadImage(Image2, OpenDialog1.FileName);
  end;
  Label15.Visible := False;
  Label13.Caption := IntToStr(Image2.Picture.Width) + ' x ' +
    IntToStr(Image2.Picture.Height);
  Stereogram1.DepthMap := Image2.Picture;
  GetParams;
end;



procedure TForm1.SetJPEGOptions(Sender: TImage);
var
  Temp: Boolean;
begin
  Temp := Sender.Picture.Graphic is TJPEGImage;
  if Temp then
    with TJPEGImage(Sender.Picture.Graphic) do
    begin
      PixelFormat := jf24Bit;
      Scale := jsFullSize;
      Grayscale := False;
      Performance := jpBestQuality;
      ProgressiveDisplay := False;
    end;
end;


procedure TForm1.LoadImage(Sender: TImage; FileName: string);
var
  II: TImage;
begin
  II := TImage.Create(nil);
  try
    try
      II.Picture.LoadFromFile(Filename);
    except
      on EInvalidGraphic do
        II.Picture.Graphic := nil;
    end;
    SetJPEGOptions(II);
    if II.Picture.Graphic <> nil then
    begin
      if not (II.Picture.Graphic is TJPEGImage) then
      begin
        Sender.Picture.Bitmap := II.Picture.Bitmap;
      end
      else
      begin
        Sender.Picture.Bitmap.PixelFormat := pf24bit;
        Sender.Picture.Bitmap.Width := II.Picture.Width;
        Sender.Picture.Bitmap.Height := II.Picture.Height;
        Sender.Canvas.Draw(0, 0, II.Picture.Graphic);
      end;
    end;
  finally
    II.Free;
  end;
end;

procedure TForm1.Image3Click(Sender: TObject);
begin
  OpenDialog1.Filter := 'Image files (*.BMP,*.JPG)|*.BMP;*.JPG';
  OpenDialog1.Filterindex := 0;
  if OpenDialog1.Execute then
  begin
    LoadImage(Image3, OpenDialog1.FileName);
  end;
  Label16.Visible := False;
  Label14.Caption := IntToStr(Image3.Picture.Width) + ' x ' +
    IntToStr(Image3.Picture.Height);
  Stereogram1.MaskMap := Image3.Picture;
  GetParams;
end;



procedure TForm1.SetParams;
begin
  try
    if RadioGroup1.ItemIndex = 0 then Stereogram1.StereoType := sgtFastRandomDot;
    if RadioGroup1.ItemIndex = 1 then Stereogram1.StereoType := sgtRandomDotTextured;
    if RadioGroup1.ItemIndex = 2 then Stereogram1.StereoType := sgtTextured;
     if RadioGroup1.ItemIndex = 3 then Stereogram1.StereoType := sgtColoredDot;

    if RadioGroup2.ItemIndex = 0 then Stereogram1.Blur := blurNone;
    if RadioGroup2.ItemIndex = 1 then Stereogram1.Blur := blurLight;
    if RadioGroup2.ItemIndex = 2 then Stereogram1.Blur := blurMedium;
    if RadioGroup2.ItemIndex = 3 then Stereogram1.Blur := blurHeavy;

    Stereogram1.DotIntensity := TrackBar1.Position;

    if RadioGroup3.ItemIndex = 0 then Stereogram1.RandomDotColor := dctBlackWhite;
    if RadioGroup3.ItemIndex = 1 then Stereogram1.RandomDotColor := dctRGB;

    Stereogram1.Oversampling := RadioGroup4.ItemIndex + 1;

    if (Edit1.Text <> '') then
      Stereogram1.ObservDistance := StrToFloat(Edit1.Text);
    if (Edit2.Text <> '') then
      Stereogram1.Max3Ddepth := StrToFloat(Edit2.Text);
    if (Edit3.Text <> '') then
      Stereogram1.Min3Ddepth := StrToFloat(Edit3.Text);
    if (Edit5.Text <> '') then
      Stereogram1.DPI := StrToInt(Edit5.Text);
    if (Edit7.Text <> '') then
      Stereogram1.Height := StrToInt(Edit7.Text);
    if (Edit6.Text <> '') then
      Stereogram1.Width := StrToInt(Edit6.Text);

  except
  end;
end;

procedure TForm1.GetParams;
begin

  if Stereogram1.StereoType = sgtFastRandomDot then RadioGroup1.ItemIndex := 0;
  if Stereogram1.StereoType = sgtRandomDotTextured then RadioGroup1.ItemIndex := 1;
  if Stereogram1.StereoType = sgtTextured then RadioGroup1.ItemIndex := 2;
  if Stereogram1.StereoType = sgtColoredDot then RadioGroup1.ItemIndex := 3;


  if Stereogram1.Blur = blurNone then RadioGroup2.ItemIndex := 0;
  if Stereogram1.Blur = blurLight then RadioGroup2.ItemIndex := 1;
  if Stereogram1.Blur = blurMedium then RadioGroup2.ItemIndex := 2;
  if Stereogram1.Blur = blurHeavy then RadioGroup2.ItemIndex := 3;


  TrackBar1.Position := Stereogram1.DotIntensity;

  if Stereogram1.RandomDotColor = dctBlackWhite then RadioGroup3.ItemIndex := 0;
  if Stereogram1.RandomDotColor = dctRGB then RadioGroup3.ItemIndex := 1;

  RadioGroup4.ItemIndex := Stereogram1.Oversampling - 1;

  Edit1.Text := FloatToStr(Stereogram1.ObservDistance);
  Edit2.Text := FloatToStr(Stereogram1.Max3Ddepth);
  Edit3.Text := FloatToStr(Stereogram1.Min3Ddepth);
  Edit4.Text := FloatToStr(Stereogram1.Separation);

  Edit7.Text := IntToStr(Stereogram1.Height);
  Edit6.Text := IntToStr(Stereogram1.Width);

  image2.Picture := Stereogram1.DepthMap;
  image3.Picture := Stereogram1.MaskMap;

  Label13.Caption := IntToStr(Image2.Picture.Width) + ' x ' +
    IntToStr(Image2.Picture.Height);

  Label14.Caption := IntToStr(Image3.Picture.Width) + ' x ' +
    IntToStr(Image3.Picture.Height);

end;


procedure TForm1.Zmena(Sender: TObject);
begin
  if (LastType <> 2) and (RadioGroup1.ItemIndex = 2) then
  begin
    RadioGroup4.ItemIndex := 3;
  end;
  LastType := RadioGroup1.ItemIndex;
  SetParams;
  GetParams;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  LastType := -1;
  getParams;
end;

procedure TForm1.SetSepar(Sender: TObject);
begin
  if Stereogram1.Separation <> StrToInt(Edit4.Text) then
  begin
    Stereogram1.Separation := StrToInt(Edit4.Text);
    GetParams;
  end;
end;

end.

