unit TestCard;

{
This form is a mini testcard, simply for TV quality and resolution checking
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TFormTestcard = class(TForm)
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormPaint(Sender: TObject);
    procedure FormClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormTestcard: TFormTestcard;

implementation

{$R *.DFM}

procedure TFormTestcard.FormCreate(Sender: TObject);
begin
  Color := RGB (64, 64, 64);
end;


procedure TFormTestcard.FormClick(Sender: TObject);
begin
  Close;
end;


procedure TFormTestcard.FormKeyPress(Sender: TObject; var Key: Char);
begin
  Close;
end;


procedure TFormTestcard.FormPaint(Sender: TObject);
var
  dx, dy: integer;

  procedure TripletAt (x, y: integer);
  begin
    with Canvas do
      begin
      Pen.Color := clRed;
      MoveTo (x - dx div 4, y);  LineTo (x - dx div 12, y);
      MoveTo (x, y - dy div 4);  LineTo (x, y - dy div 12);
      Pen.Color := clBlue;
      MoveTo (x + dx div 12, y);  LineTo (x + dx div 4, y);
      MoveTo (x, y + dy div 12);  LineTo (x, y + dy div 4);
      Pen.Color := clLime;
      MoveTo (x - dx div 12, y);  LineTo (x + dx div 12, y);
      MoveTo (x, y - dy div 12);  LineTo (x, y + dy div 12);
      end;
  end;

  procedure GreyScaleAt (x, y: integer);
  var
    i, grey: integer;
  begin
    Inc (y, 8 * dy div 6);
    with Canvas do
      for i := 0 to 16 do
        begin
        grey := (i * 255) div 16;
        Brush.Color := RGB (grey, grey, grey);
        Pen.Color := Brush.Color;
        Rectangle (x - dx div 6, y, x + dx div 6, y + dy div 6);
        Dec (y, dy div 6);
        end;
  end;
var
  x, y: integer;
  mid_x, mid_y: integer;
  i, radius: integer;                    
  angle: Double;
  s: string;
begin
  with Canvas do
    begin
    Pen.Color := clLime;
    Pen.Width := 3;
    radius := ClientHeight;
    mid_x := ClientWidth div 2;
    mid_y := ClientHeight div 2;
    for i := 0 to 1 do
      begin
      angle := (2 * i + 1) * pi / 4;
      dx := Round (radius * cos (angle));
      dy := Round (radius * sin (angle));
      MoveTo (mid_x - dx, mid_y + dy);
      LineTo (mid_x + dx, mid_y - dy);
      end;

    Pen.Color := clWhite;
    Pen.Width := 1;
    Font.Color := clWhite;

    MoveTo (0, mid_y);
    LineTo (ClientWidth, mid_y);
    MoveTo (mid_x, 0);
    LineTo (mid_x, ClientHeight);

    Brush.Style := bsClear;
    for i := 1 to 4 do
      begin
      dx := i * (ClientWidth div 8);
      Ellipse (mid_x - dx, mid_y - dx, mid_x + dx + 1, mid_y + dx + 1);
      end;

    Brush.Style := bsSolid;
    Brush.Color := Self.Color;
    x := 0;
    dx := ClientWidth div 8;
    while x <= ClientWidth do
      begin
      MoveTo (x, mid_y - 4);
      LineTo (x, mid_y + 5);
      s := IntToStr (x);
      TextOut (x - TextWidth (s) div 2, mid_y + 8, s);
      x := x + dx;
      end;

    dy := ClientHeight div 8;
    y := 0;
    while y <= ClientHeight do
      begin
      MoveTo (mid_x - 4, y);
      LineTo (mid_x + 5, y);
      s := IntToStr (y);
      TextOut (mid_x - TextWidth (s) - 8, y - TextHeight (s) div 2, s);
      y := y + dy;
      end;

    dx := ClientWidth div 16;
    dy := ClientHeight div 12;

    for x := -1 to 1 do if x <> 0 then
      for y := -1 to 1 do if y <> 0 then
        begin
        TripletAt (mid_x + x * (15 * dx) div 2, mid_y + y * (11 * dy) div 2);
        TripletAt (mid_x + x * (15 * dx) div 2, mid_y + y * dy div 2);
        GreyScaleAt (mid_x + x * (15 * dx) div 2, mid_y + y * 3 * dy);
        end;
        
    end;
end;

end.

