unit Options;

{
1999 May 02  Add annotation options
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, Spin;

type
  TFormOptions = class(TForm)
    PageControl1: TPageControl;
    TabSheetAssociation: TTabSheet;
    ButtonOK: TButton;
    ButtonCancel: TButton;
    GroupBoxRegExtn: TGroupBox;
    CheckBoxRegister: TCheckBox;
    Label1: TLabel;
    TabSheetMagnification: TTabSheet;
    CheckBoxKeepSmallImages: TCheckBox;
    TabSheetAutoShow: TTabSheet;
    GroupBoxAutoShow: TGroupBox;
    Label2: TLabel;
    CheckBoxAutoShow: TCheckBox;
    CheckBoxLoopShow: TCheckBox;
    SpinEditAutoTimerInterval: TSpinEdit;
    Label3: TLabel;
    CheckBoxRandomOrder: TCheckBox;
    CheckBoxResample: TCheckBox;
    CheckBoxAnnotatePreview: TCheckBox;
    CheckBoxAnnotateSlideShow: TCheckBox;
    procedure CheckBoxRegisterClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CheckBoxKeepSmallImagesClick(Sender: TObject);
    procedure CheckBoxAutoShowClick(Sender: TObject);
    procedure CheckBoxLoopShowClick(Sender: TObject);
    procedure ButtonOKClick(Sender: TObject);
    procedure CheckBoxRandomOrderClick(Sender: TObject);
    procedure CheckBoxResampleClick(Sender: TObject);
    procedure CheckBoxAnnotatePreviewClick(Sender: TObject);
    procedure CheckBoxAnnotateSlideShowClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    RegisterFileExtension: boolean;
    KeepSmallImages: boolean;
    AutoShowEnable: boolean;
    AutoShowInterval: integer;
    AutoShowLoop: boolean;
    AutoShowRandomOrder: boolean;
    DoResample: boolean;
    AnnotatePreview: boolean;
    AnnotateSlideShow: boolean;
  end;

var
  FormOptions: TFormOptions;

implementation

{$R *.DFM}

procedure TFormOptions.FormShow(Sender: TObject);
begin
  CheckBoxRegister.Checked := RegisterFileExtension;

  CheckBoxKeepSmallImages.Checked := KeepSmallImages;
  CheckBoxResample.Checked := DoResample;
  CheckBoxAnnotatePreview.Checked := AnnotatePreview;
  CheckBoxAnnotateSlideShow.Checked := AnnotateSlideShow;

  CheckBoxAutoShow.Checked := AutoShowEnable;
  CheckBoxLoopShow.Checked := AutoShowLoop;
  SpinEditAutoTimerInterval.Value := AutoShowInterval;
  CheckBoxRandomOrder.Checked := AutoShowRandomOrder;

  CheckBoxLoopShow.Enabled := AutoShowEnable;
  SpinEditAutoTimerInterval.Enabled := AutoShowEnable;
  CheckBoxRandomOrder.Enabled := AutoShowEnable;
  Label3.Enabled := AutoShowEnable;
end;

procedure TFormOptions.CheckBoxRegisterClick(Sender: TObject);
begin
  RegisterFileExtension := CheckBoxRegister.Checked;
end;

procedure TFormOptions.CheckBoxKeepSmallImagesClick(Sender: TObject);
begin
  KeepSmallImages := CheckBoxKeepSmallImages.Checked;
end;

procedure TFormOptions.CheckBoxAutoShowClick(Sender: TObject);
begin
  AutoShowEnable := CheckBoxAutoShow.Checked;
  CheckBoxLoopShow.Enabled := AutoShowEnable;
  SpinEditAutoTimerInterval.Enabled := AutoShowEnable;
  CheckBoxRandomOrder.Enabled := AutoShowEnable;
  Label3.Enabled := AutoShowEnable;
end;

procedure TFormOptions.CheckBoxLoopShowClick(Sender: TObject);
begin
  AutoShowLoop := CheckBoxLoopShow.Checked;
end;

procedure TFormOptions.CheckBoxRandomOrderClick(Sender: TObject);
begin
  AutoShowRandomOrder := CheckBoxRandomOrder.Checked;
end;

procedure TFormOptions.ButtonOKClick(Sender: TObject);
begin
  AutoShowInterval := SpinEditAutoTimerInterval.Value;
end;

procedure TFormOptions.CheckBoxResampleClick(Sender: TObject);
begin
  DoResample := CheckBoxResample.Checked;
end;

procedure TFormOptions.CheckBoxAnnotatePreviewClick(Sender: TObject);
begin
  AnnotatePreview := CheckBoxAnnotatePreview.Checked;
end;

procedure TFormOptions.CheckBoxAnnotateSlideShowClick(Sender: TObject);
begin
  AnnotateSlideShow := CheckBoxAnnotateSlideShow.Checked;
end;

end.

