unit JPEGImageProperties;

{
1997 May 10  Allow for the requested file not existing.
1998 Mar 14  Update for revised image reading units
1998 Mar 27  Add GIF transparency info
             Remove obsolete JPEG stuff
1998 Oct 12  Handle JPEG images that have non-unity scale
             Allow for escape on form or button to close the form
1998 Nov 25  Version for JPEG only, simply requires file name
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls;

type
  TFormProperties = class(TForm)
    btnOK: TButton;
    PageControl1: TPageControl;
    FilePropsSheet: TTabSheet;
    grpFileProperties: TGroupBox;
    Label17: TLabel;
    Label18: TLabel;
    lblFilename: TLabel;
    lblFolder: TLabel;
    Label16: TLabel;
    lblFileSize: TLabel;
    Label21: TLabel;
    lblLastModified: TLabel;
    grpImageProperties: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    lblImgWidth: TLabel;
    lblImgHeight: TLabel;
    Label14: TLabel;
    lblInputBits: TLabel;
    Label15: TLabel;
    lblDisplayBits: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    lblImageBytes: TLabel;
    lblCompression: TLabel;
    procedure btnOKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
    Filename: string;
  end;

var
  FormProperties: TFormProperties;

implementation

uses JPEG;

{$R *.DFM}

procedure TFormProperties.btnOKClick(Sender: TObject);
begin
  Hide;
end;


procedure TFormProperties.FormShow(Sender: TObject);
var
  input_bits: word;
  uncompressed, compressed: integer;
  sr: TSearchRec;
  jpg: TJPEGimage;
  dc: HDC;
  DisplayBitsPerPixel: integer;
  st: string;
begin
  Caption := '(no file currently selected)';

  if FindFirst (filename, faAnyFile, sr) <> 0 then
    begin
    FindClose (sr);
    Exit;
    end;

  DisplayBitsPerPixel := 0;
  dc := GetDC (0);
  case GetDeviceCaps (dc, BITSPIXEL) of
     8: DisplayBitsPerPixel := 8;
    15: DisplayBitsPerPixel := 15;
    16: DisplayBitsPerPixel := 16;
    24: DisplayBitsPerPixel := 24;
    32: DisplayBitsPerPixel := 32;
  end;
  ReleaseDC (0, dc);
  lblDisplayBits.Caption := IntToStr (DisplayBitsPerPixel);

  // First the format independent things that are to be displayed
  PageControl1.ActivePage := FilePropsSheet;
  lblFilename.Caption := ExtractFilename (filename);
  lblFilename.Hint := lblFilename.Caption;
  lblFolder.Caption := ExtractFilepath (ExpandFileName (filename));
  lblFolder.Hint := lblFolder.Caption;

  Caption := lblFilename.Caption + ' properties';
  compressed := sr.Size;
  st := Format ('%.0n bytes', [compressed + 0.0]);
  if compressed > 1024 * 1024
    then st := Format ('%.1d MB (%s)', [compressed div (1024 * 1024), st])
    else if compressed > 1024
           then st := Format ('%.1d KB (%s)', [compressed div 1024, st]);
  lblLastModified.Caption := FormatDateTime ('dddddd tt', FileDateToDateTime (sr.Time));
  FindClose (sr);
  lblFileSize.Caption := st;

  if LowerCase (ExtractFileExt (filename)) <> '.jpg' then Exit;

  try
    jpg := TJPEGimage.Create;
    jpg.LoadFromFile (filename);
    input_bits := 0;
    case jpg.PixelFormat of
      jf8bit: input_bits := 8;
      jf24bit: input_bits := 24;
    end;
    lblImgHeight.Caption := IntToStr (jpg.Height);
    lblImgWidth.Caption := IntToStr (jpg.Width);
    lblInputBits.Caption := IntToStr (input_bits);
    uncompressed := jpg.Height * jpg.Width * input_bits div 8;
    lblImageBytes.Caption := IntToStr (uncompressed);
    lblCompression.Caption := Format ('%.2n:1', [uncompressed / compressed]);
  finally
    jpg.Free;
  end;

end;


procedure TFormProperties.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #27 then Close;
end;


end.

