unit FullScreen;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, JpegEx;

type
  TFormFullScreenPreview = class(TForm)
    ImageDisplay: TImage;
    TimerShow: TTimer;
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormShow(Sender: TObject);
    procedure TimerShowTimer(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormClick(Sender: TObject);
    procedure ImageDisplayClick(Sender: TObject);
  private
    { Private declarations }
    display_phase: (low_quality, high_quality, complete);
    jpg: TJPEGImageEx;          // The image we'll be showing full screen
  public
    { Public declarations }
    ImageDescription: string;   // Mixed filename and image details
    magnify_small_images: boolean;
  end;

var
  FormFullScreenPreview: TFormFullScreenPreview;


implementation

uses PicturePanel;

{$R *.DFM}

procedure TFormFullScreenPreview.FormShow(Sender: TObject);
begin
  ImageDisplay.Align := alClient;    // It's more convenient to do these
  Color := clBlack;                  // at run-time than design time.
  display_phase := low_quality;      // Mark the initial mode
  TimerShow.Enabled := True;         // And start the timer
end;

procedure TFormFullScreenPreview.TimerShowTimer(Sender: TObject);
begin
  TimerShow.Enabled := False;   // stop any retriggering
  case display_phase of
    low_quality:
      begin
      // Create the JPG to fill the client area
      jpg := TJPEGImageEx.CreateWithClientSize (ClientWidth, ClientHeight);
      jpg.ExpandSmallImages := magnify_small_images;
      // Initially, load at basic quality
      jpg.LoadFromFile (get_filename_part (ImageDescription));
      // Copy the description for later use by display_image_details
      ImageDisplay.Hint := ImageDescription;
      // See if we have a picture now, and display it if so
      if jpg <> nil then ImageDisplay.Picture.Assign (jpg.Image.Picture);
      display_image_details (ImageDisplay);
      display_phase := high_quality;   // Change state to next display quality
      TimerShow.Enabled := True;       // and wait for the next trigger
      end;
    high_quality:
      begin
      if not jpg.Resampled then        // We have not got top quality as yet
        begin
        jpg.Resample;                                      // Force a re-sample
        ImageDisplay.Picture.Assign (jpg.Image.Picture);   // Copy up the image
        display_image_details (ImageDisplay);              // Rewrite details
        end;
      display_phase := complete;       // Change state to all done
      end;
  end;
end;

procedure TFormFullScreenPreview.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  ImageDisplay.Picture.Assign (nil);   // Remove the picture
  jpg.Free;                            // Release the JPG memory
  jpg := nil;                          // And stop us using it next time
end;

procedure TFormFullScreenPreview.FormClick(Sender: TObject);
begin
  Close;            // Ayy click exits
end;

procedure TFormFullScreenPreview.ImageDisplayClick(Sender: TObject);
begin
  Close;
end;

procedure TFormFullScreenPreview.FormKeyPress(Sender: TObject;
  var Key: Char);
begin
  Close;            // Any key exits
end;

end.

