unit DeleteOriginal;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, JPEGEx;

type
  TFormDeleteOriginal = class(TForm)
    ButtonYes: TButton;
    ButtonNo: TButton;
    LabelConfirm: TLabel;
    TimerShow: TTimer;
    Panel1: TPanel;
    ImageDisplay: TImage;
    procedure FormShow(Sender: TObject);
    procedure TimerShowTimer(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    jpg: TJPEGImageEx;          // The image we'll be showing full screen
  public
    { Public declarations }
    filename: string;
  end;

var
  FormDeleteOriginal: TFormDeleteOriginal;

implementation

{$R *.DFM}

procedure TFormDeleteOriginal.FormShow(Sender: TObject);
begin
  LabelConfirm.Caption := 'Are you sure you want to delete the orginal image: ' + filename + ' ?';
  Caption := 'Confirm delete of ' + ExtractFileName (filename);
  TimerShow.Enabled := True;         // And start the timer
end;

procedure TFormDeleteOriginal.TimerShowTimer(Sender: TObject);
var
  w, h: integer;
begin
  TimerShow.Enabled := False;         // Stop a retrigger
  // Create the JPG to fill the TImage
  w := ImageDisplay.Width;
  h := ImageDisplay.Height;
  jpg := TJPEGImageEx.CreateWithClientSize (w, h);
  // Initially, load at basic quality
  jpg.LoadFromFile (filename);
  if jpg <> nil then
    begin
    if not jpg.Resampled then jpg.Resample;            // Force a re-sample
    ImageDisplay.Picture.Assign (jpg.Image.Picture);   // Copy up the image
    end;
end;

procedure TFormDeleteOriginal.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  ImageDisplay.Picture.Assign (nil);   // Remove the picture
  jpg.Free;                            // Release the JPG memory
  jpg := nil;                          // And stop us using it next time
end;

end.
