(***********************************************)
(*                                             *)
(* ZX-Spectrum screen file viewer              *)
(* Copyright (c) 1999 by Vadim Bodrov          *)
(*                                             *)
(* Target:                                     *)
(* MS-DOS 32-bit protected mode application    *)
(* Compiler:                                   *)
(* TMT Pascal Multi-target 3.21 or higher      *)
(***********************************************)

uses CRT, Graph, ZenTimer;

const
  clBlack        = $000000;
  clGreen        = $002600;
  clMagenta      = $260026;
  clRed          = $260000;
  clCyan         = $002626;
  clBlue         = $000026;
  clYellow       = $262600;
  clGray         = $262626;
  clLightGreen   = $003900;
  clLightMagenta = $390039;
  clLightRed     = $390000;
  clLightCyan    = $003939;
  clLightBlue    = $000039;
  clLightYellow  = $393900;
  clWhite        = $393939;

  ZX_COLORS: array [0..15] of DWORD =
  (clBlack, clBlue, clRed, clMagenta,
   clGreen, clCyan, clYellow, clGray,
   clBlack, clLightBlue, clLightRed,
   clLightMagenta, clLightGreen,
   clLightCyan, clLightYellow, clWhite
  );

var
  PixData: array [0..6143] of Byte;
  AttrData: array [0..767] of Byte;
  Flasher: Boolean;
  Scr: Pointer;
  f: File;

procedure xSwap(var a, b: DWORD);
var
  c: DWORD;
begin
  c := a;
  a := b;
  b := c;
end;

procedure DecodeScr;
var
  cPtr: Pointer;
  i, j, k, l, m: DWORD;
  c, State, Attr: Byte;
  Paper, Ink: DWORD;
  Bright: DWORD;
begin
  cPtr := Scr;
  for j := 0 to 2 do
  begin
    for i := 0 to 7 do
    begin
      for k := 0 to 7 do
      begin
        for l := 0 to 31 do
        begin
          c := PixData[j * 2048 + k * 256 + i * 32 + l];
          for m := 0 to 7 do
          begin
            State := (c and 128) shr 7;
            Attr := AttrData[j * 256 + i * 32 + l];
            Ink := Attr and 7;
            Paper := (Attr shr 3) and 7;
            if (Attr and 64) = 64 then
            begin
              if Ink <> 0 then Ink +:= 8;
              if Paper <> 0 then Paper +:= 8;
            end;
            if (Flasher) and ((Attr and 128) = 128) then xSwap(Ink, Paper);
            if State = 0 then
              Byte(cPtr^) := Paper
            else
              Byte(cPtr^) := Ink;
            c := c shl 1;
            inc(cPtr);
          end;
        end;
      end;
    end;
  end;
  Flasher := not Flasher;
end;

procedure ULZDelay(Value: DWord);
var
  CurValue: DWord;
begin
  CurValue := ULZTimerLap + Value;
  while (ULZTimerLap < CurValue) and not (KeyPressed) do (* nothing *)
end;

procedure ViewScr(Addr: Pointer);
var
  i: DWORD;
begin
  SetGraphMode($13);
  //SetSVGAMode(320, 240, 8, LfbOrBanked);

  for i := 0 to 15 do
    SetRGBPalette(i, ZX_COLORS[i] shr 16, ZX_COLORS[i] shr 8, ZX_COLORS[i]);

  ULZTimerOn;

  repeat
    DecodeScr;
    PutSprite(32, 4, 287, 195, Addr^);
    //PutSprite(32, 24, 287, 215, Addr^);
    ULZDelay(10);
  until (KeyPressed) ;

  ULZTimerOff;

  ReadKey;
  RestoreCrtMode;
end;

begin
  Write('ZX-Spectrum screen file viewer v1.5 ');
{$ifdef __DOS__}
  Writeln('(MS-DOS 32-bit)');
{$endif}
  Writeln('Copyright (c) 1999 by Vadim Bodrov');
  if ParamCount < 1 then
  begin
    Writeln('Usage: SCRVIEW file.scr');
    Writeln;
    halt;
  end;

{$i-}
  Assign(f, ParamStr(1));
  Reset(f);
{$i+}
  if IOResult <> 0 then
  begin
    Writeln(ParamStr(1),' is not found.');
    Writeln;
    halt;
  end;
  if FileSize(f) <> 6912 then
  begin
    Close(f);
    Writeln('Wrong .SCR file.');
    Writeln;
    halt;
  end;
{$i-}
  BlockRead(f, PixData, SizeOf(PixData));
  BlockRead(f, AttrData, SizeOf(AttrData));
  Close(f);
{$i+}
  if IOResult <> 0 then
  begin
    Writeln(ParamStr(1),' read error.');
    Writeln;
    halt;
  end;
  GetMem(Scr, 49152);
  ViewScr(Scr);
  FreeMem(Scr, 49152);
end.