#ifndef __XSP__
#define __XSP__

//  ----------------  XSP  ---------------------------

#include <stdio.h>
#include "define.h"

// (Header) -------------------------------------------------------

struct XSP_HEADER {
    BYTE    header[4];      // "XSP\0"
    int     version;
    BYTE    name[16];
    int     total_frame;
    BYTE    palette[768];
    int     total_animation;
    int     animation_loop;
    int     ani_info_offset;
    int     reserved[16];
    // int     frame_offset[ total_frame ];
    // XSP_ANI_INFO ani_info[ total_animation ];
};

// (Animation) -------------------------------------------------------

struct XSP_ANI_INFO {
    int     frame_num;
    int     xstep;
    int     ystep;
    int     delay;
    BYTE    reserved[16];
};

// (Frame) -----------------------------------------------------------

struct XSP_FRAME_HEADER {
    int     xlen;
    int     ylen;
    int     xpos;
    int     ypos;
    int     pal_offset;
    BYTE    *palette;
    int     reserved[14];
    //      BYTE image[xlen*ylen]
    //      crash info  { int x, int y }[64]
};

class XSP {
    FILE *file;
    int   current_frame;
public:
    XSP_HEADER          header;
    XSP_ANI_INFO        *ani_info;
    XSP_FRAME_HEADER    frame_header;
    int                 *frame_offset;
    int                 xpos;
    int                 ypos;

    XSP();
    ~XSP();
    BOOL Load( char *fname );
    void GotoFrame( int num );
};

#endif
