/* ************************************************************** */
/* redemo2.c For Turbo C - Demonstrates how to display XGF images */
/*                         from inside a resource file.           */
/*                                                                */
/* Use Raster Master/RastClip/RastPort to create XGF files.       */
/*                                                                */
/* ************************************************************** */

#include <stdio.h>
#include <graphics.h>

struct resheadrec {
    char         rfid[3];    /* resource file id - RES    */
    unsigned int resitems;   /* number of resource items  */
  };

struct resitemrec {
    int  rt;         /* resource type */
    char rid[12];    /* resource id   */
    long offset;     /* file offset   */
    long length;     /* file size     */
  };

void setvga16()
{
 int driver = VGA,
     mode = VGALO;

 initgraph(&driver, &mode, "");
}

void res_dis_xgf(int x, int y, char *filename, int ri)
{
 FILE *F;
 unsigned int width,height,bpl,i;
 int scanline[1030];
 struct resitemrec res;

 F=fopen(filename,"rb");

 if (F!=NULL)
 {
   fseek(F,((long)sizeof(struct resheadrec)+
   (long)(ri-1)*(long)sizeof(struct resitemrec)),SEEK_SET);

   fread(&res,sizeof(res),1,F);             /* res item record  */

   fseek(F,res.offset,SEEK_SET);
   fread(&width,2,1,F);
   fread(&height,2,1,F);

   scanline[0]=width;
   scanline[1]=0;

   bpl=imagesize(0,0,width,0)-6;

   for(i=0;i<height;i++)
   {
     fread(&scanline[2],1,bpl,F);
     putimage(x,y+i,scanline,0);
   }
   fclose(F);
 }
}


void main()
{
  setvga16();

  setfillstyle(SOLID_FILL,BLUE);
  bar(0,0,getmaxx(),getmaxy());

  res_dis_xgf(0,0,"pics.res",1);
  res_dis_xgf(200,50,"pics.res",2);
  res_dis_xgf(300,100,"pics.res",3);
  res_dis_xgf(200,0,"pics.res",4);
  res_dis_xgf(400,50,"pics.res",5);
  res_dis_xgf(500,100,"pics.res",6);

  getch();
  closegraph();
}
