;

struc   split_node

value           dd ?
component       dd ?
lighter         dd ?
darker          dd ?

ends

;

align 4
split_tree      dd ?
palette         db 768 dup ( ? )

colour_mask     dd -1   ;for posturization

;
;Call this after loading the split tree into memory

proc    RebaseSplitTree n

        mov     eax, [split_tree]
        mov     ecx, 511
        mov     esi, [split_tree]

@@rebase:
        cmp     [esi + split_node.lighter], -1
        je      @@skip_lighter

        add     [esi + split_node.lighter], eax

@@skip_lighter:
        cmp     [esi + split_node.darker], -1
        je      @@skip_darker

        add     [esi + split_node.darker], eax

@@skip_darker:
        add     esi, size split_node
        dec     ecx
        jnz     @@rebase

        ret

endp

;
;Load and rebase the split tree before you use this.
;You can use the difference between the input and output rgb values for error
;diffusion.  Look up the rgb values of the output in the palette. Scan left
;then right across the image for better results.

; ------------------->   | ;scanline 1
;<-------------------    | ;scanline 2
; ------------------->   | ;scanline 3
;<-------------------    | ;scanline 4
; ------------------->   |
;<-------------------    V

;Heading right:
;pixel(x, y) = output
;error = input - output
;inputpixel(x+1, y) += 7 * error/16
;inputpixel(x-1, y+1) += 3 * error/16
;inputpixel(x, y+1) += 5 * error/16
;inputpixel(x+1, y+1) += error - (7 * error/16 + 3 * error/16 + 5 * error/16)

;Heading left:
;pixel(x, y) = output
;error = input - output
;inputpixel(x-1, y) += 7 * error/16
;inputpixel(x+1, y+1) += 3 * error/16
;inputpixel(x, y+1) += 5 * error/16
;inputpixel(x-1, y+1) += error - (7 * error/16 + 3 * error/16 + 5 * error/16)

;This came from Foley, van Dam et al.

;In:
;       eax: any r,g,b 32 bit colour
;Out:
;       eax: nearset 8bit palette colour

proc    QuantizeColour n

        push    ebx esi
        and     eax, [colour_mask]
        mov     [@@rgb], eax
        mov     esi, [split_tree]

@@recurse_split_tree:
        cmp     [esi + split_node.darker], -1
        je      @@got_it
        
        mov     eax, [esi + split_node.component]
        lea     ebx, [eax + esi]
        mov     al, [eax + o @@rgb]
        cmp     al, [b ebx + split_node.value]
        jb      @@goto_darker

@@goto_lighter:
        mov     esi, [esi + split_node.lighter]
        jmp     @@recurse_split_tree

@@goto_darker:
        mov     esi, [esi + split_node.darker]
        jmp     @@recurse_split_tree

@@got_it:
        mov     eax, [esi + split_node.value]
        pop     esi ebx
        ret

@@rgb   dd ?

endp

;

macro   iclamp what, low_value, high_value
local   low, high

        cmp     what, low_value
        jge     low    
	
        mov     what, low_value
        jmp     high

low:
        cmp     what, high_value
        jle     high

        mov     what, high_value

high:
endm

;
;This is pretty horrible, but i'm sure it gives you the general idea.
;Get rid of the imuls with a lookup table, use registers better.
;In:
;       ecx: x pixels
;       edx: y pixels
;       esi: 32bit source image
;       edi: 8bit dest image

proc    Dither n

@@y     equ dword esp + 8
@@x     equ dword esp + 4
@@bx    equ dword esp

        sub     esp, 12
        mov     [@@x], ecx
        mov     [@@y], edx
        shl     ecx, 2
        mov     [@@bx], ecx

@@y_loop:
        mov     ebp, [@@x]

@@x_loop:
        mov     eax, [esi]
        call    QuantizeColour
        mov     [edi], al
        mov     eax, [eax*4 + o palette]

        xor     ebx, ebx
        xor     ecx, ecx
        mov     bl, al
        mov     cl, [esi]
        sub     ecx, ebx
        mov     [@@dr], ecx
        xor     ebx, ebx
        xor     ecx, ecx
        mov     bl, ah
        mov     cl, [esi + 1]
        sub     ecx, ebx
        mov     [@@dg], ecx
        xor     ebx, ebx
        xor     ecx, ecx
        shr     eax, 8
        mov     bl, ah
        mov     cl, [esi + 2]
        sub     ecx, ebx
        mov     [@@db], ecx

        add     esi, 4
        mov     eax, [@@dr]
        imul    eax, 7
        sar     eax, 4
        mov     [@@sdr], eax
        movzx   ebx, [b esi]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi], al
        mov     eax, [@@dg]
        imul    eax, 7
        sar     eax, 4
        mov     [@@sdg], eax
        movzx   ebx, [b esi + 1]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 1], al
        mov     eax, [@@db]
        imul    eax, 7
        sar     eax, 4
        mov     [@@sdb], eax
        movzx   ebx, [b esi + 2]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 2], al
        sub     esi, 4

        sub     esi, 4
        add     esi, [@@bx]
        mov     eax, [@@dr]
        imul    eax, 3
        sar     eax, 4
        add     [@@sdr], eax
        movzx   ebx, [b esi]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi], al
        mov     eax, [@@dg]
        imul    eax, 3
        sar     eax, 4
        add     [@@sdg], eax
        movzx   ebx, [b esi + 1]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 1], al
        mov     eax, [@@db]
        imul    eax, 3
        sar     eax, 4
        add     [@@sdb], eax
        movzx   ebx, [b esi + 2]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 2], al
        add     esi, 4
        sub     esi, [@@bx]

        add     esi, [@@bx]
        mov     eax, [@@dr]
        imul    eax, 5
        sar     eax, 4
        add     [@@sdr], eax
        movzx   ebx, [b esi]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi], al
        mov     eax, [@@dg]
        imul    eax, 5
        sar     eax, 4
        add     [@@sdg], eax
        movzx   ebx, [b esi + 1]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 1], al
        mov     eax, [@@db]
        imul    eax, 5
        sar     eax, 4
        add     [@@sdb], eax
        movzx   ebx, [b esi + 2]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 2], al
        sub     esi, [@@bx]

        add     esi, 4
        add     esi, [@@bx]
        mov     eax, [@@dr]
        sub     eax, [@@sdr]
        movzx   ebx, [b esi]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi], al
        mov     eax, [@@dg]
        sub     eax, [@@sdg]
        movzx   ebx, [b esi + 1]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 1], al
        mov     eax, [@@db]
        sub     eax, [@@sdb]
        movzx   ebx, [b esi + 2]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 2], al
        sub     esi, 4
        sub     esi, [@@bx]

        add     esi, 4
        inc     edi
        dec     ebp
        jnz     @@x_loop

        dec     [@@y]
        jz      @@done_y

        mov     ebp, [@@x]
        add     esi, [@@bx]
        sub     esi, 4
        add     edi, [@@x]
        dec     edi

@@x_loop2:
        mov     eax, [esi]
        call    QuantizeColour
        mov     [edi], al
        mov     eax, [eax*4 + o palette]

        xor     ebx, ebx
        xor     ecx, ecx
        mov     bl, al
        mov     cl, [esi]
        sub     ecx, ebx
        mov     [@@dr], ecx
        xor     ebx, ebx
        xor     ecx, ecx
        mov     bl, ah
        mov     cl, [esi + 1]
        sub     ecx, ebx
        mov     [@@dg], ecx
        xor     ebx, ebx
        xor     ecx, ecx
        shr     eax, 8
        mov     bl, ah
        mov     cl, [esi + 2]
        sub     ecx, ebx
        mov     [@@db], ecx

        add     esi, -4
        mov     eax, [@@dr]
        imul    eax, 7
        sar     eax, 4
        mov     [@@sdr], eax
        movzx   ebx, [b esi]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi], al
        mov     eax, [@@dg]
        imul    eax, 7
        sar     eax, 4
        mov     [@@sdg], eax
        movzx   ebx, [b esi + 1]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 1], al
        mov     eax, [@@db]
        imul    eax, 7
        sar     eax, 4
        mov     [@@sdb], eax
        movzx   ebx, [b esi + 2]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 2], al
        sub     esi, -4

        sub     esi, -4
        add     esi, [@@bx]
        mov     eax, [@@dr]
        imul    eax, 3
        sar     eax, 4
        add     [@@sdr], eax
        movzx   ebx, [b esi]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi], al
        mov     eax, [@@dg]
        imul    eax, 3
        sar     eax, 4
        add     [@@sdg], eax
        movzx   ebx, [b esi + 1]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 1], al
        mov     eax, [@@db]
        imul    eax, 3
        sar     eax, 4
        add     [@@sdb], eax
        movzx   ebx, [b esi + 2]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 2], al
        add     esi, -4
        sub     esi, [@@bx]

        add     esi, [@@bx]
        mov     eax, [@@dr]
        imul    eax, 5
        sar     eax, 4
        add     [@@sdr], eax
        movzx   ebx, [b esi]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi], al
        mov     eax, [@@dg]
        imul    eax, 5
        sar     eax, 4
        add     [@@sdg], eax
        movzx   ebx, [b esi + 1]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 1], al
        mov     eax, [@@db]
        imul    eax, 5
        sar     eax, 4
        add     [@@sdb], eax
        movzx   ebx, [b esi + 2]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 2], al
        sub     esi, [@@bx]

        add     esi, -4
        add     esi, [@@bx]
        mov     eax, [@@dr]
        sub     eax, [@@sdr]
        movzx   ebx, [b esi]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi], al
        mov     eax, [@@dg]
        sub     eax, [@@sdg]
        movzx   ebx, [b esi + 1]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 1], al
        mov     eax, [@@db]
        sub     eax, [@@sdb]
        movzx   ebx, [b esi + 2]
        add     eax, ebx
        iclamp  eax, 0, 255
        mov     [esi + 2], al
        sub     esi, -4
        sub     esi, [@@bx]

        sub     esi, 4
        dec     edi
        dec     ebp
        jnz     @@x_loop2

        add     esi, 4
        inc     edi
        add     esi, [@@bx]
        add     edi, [@@x]

        dec     [@@y]
        jnz     @@y_loop

@@done_y:
@@done:
        add     esp, 12
        ret

align 4
@@dr    dd ?    ;Errors at this pixels
@@dg    dd ?
@@db    dd ?

@@sdr   dd ?    ;Sum of the errors diffused
@@sdg   dd ?    ;For (7 * error/16 + 3 * error/16 + 5 * error/16)
@@sdb   dd ?

endp

;
