/*************************************************** Compiler definitions: */
/*      > Signed Chars                                                     */
/*      > BC++ 3.1 (MODEL Small) |  WATCOM C/C++ 10.6                      */
/***************************************************************************/

#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <string.h>
#include <conio.h>
#include <dos.h>        /* to detect DOS_16 uses __DOS_H*/
#ifdef __DOS_H
    #include <dir.h>
    #define __DOS16__
    #define BufSize 32768L
#else
    #include <sys/utime.h>
    #define BufSize 1024L*1024L
#endif

#define MaxFName 255
unsigned char   FnameInpJPG[MaxFName]="\0";
unsigned char   FnameOutJPG[MaxFName]="\0";
unsigned short  ushtv1, ushtv2;
unsigned int    i, j, TraceFLG=0, GrabFLG=0;
unsigned char   a, b,  Buf[BufSize];
unsigned long   ulngv, Flen, begFPtr = 0;
FILE            *HndlInpJPG=NULL, *HndlOutJPG=NULL;

unsigned char InHex[256] = {
/*00*/ 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
/*10*/ 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
/*20*/ 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
/*30*/  0 , 1 , 2 , 3 , 4 , 5 , 6 , 7 , 8 , 9 ,255,255,255,255,255,255,
/*40*/ 255,10 ,11 ,12 ,13 ,14 ,15 ,255,255,255,255,255,255,255,255,255,
/*50*/ 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
/*60*/ 255,10 ,11 ,12 ,13 ,14 ,15 ,255,255,255,255,255,255,255,255,255,
/*70*/ 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
/*80*/ 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
/*90*/ 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
/*A0*/ 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
/*B0*/ 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
/*C0*/ 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
/*D0*/ 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
/*E0*/ 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
/*F0*/ 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
};

unsigned long GetArgVal(char *PtrSrc) {
    unsigned char *PtrStart;
    unsigned long Val = 0;
    PtrStart = PtrSrc;

    if(*PtrSrc == 0) {
        printf("Error in aruments: constant value expected.\n");
        exit(-1);
    }
    if((*(unsigned short *)PtrSrc != '0' + 256 * 'x') && (*PtrSrc != '$')) {
        while(*PtrSrc >= '0' && *PtrSrc <= '9') {
            Val *= 10;
            Val += (unsigned long)(*(PtrSrc++) - '0');
        }
    }
    else { // ᫨ ᫮ 稭  "0x"  "$" -  ⭠筮:
        PtrSrc++;
        if(*PtrSrc == 'x') PtrSrc++;
        PtrSrc--;
        while(InHex[*++PtrSrc] < 0x10) {
            Val *= 0x10;
            Val += (unsigned long)(InHex[*PtrSrc]);
        }
    }
    if(*PtrSrc != 0) {
        printf("invalid constant value: '%s'\n",PtrStart);
        exit(-1);
    }
    return(Val);
}

/***************************************************************************/
void usage (void) {/************************************************ usage */
/***************************************************************************/
    printf("\n\
  JPG info/preview remover/optimizer, v1.1 Copyright (C) 1997 Vitaliy Vasiliev\n\n\
  Usage: JPGOPT [switches] InputJPG [OutputJPG]\n\
  default OutputJPG-name is '$optim$.jpg'\n\
  switches:\n\
    -t              - trace field removing\n\
    -g              - grab/search mode - search and save all JPGs\n\
    -b$XXXXXXXX     - beg pointer in file (default is 0)\n\
    -?, -h          - this help message\n\
  ");
    exit(127);
}

/***************************************************************************/
void pause (void) {/************************************************ pause */
/***************************************************************************/
    fprintf(stderr, "press any key to continue...");
    if(getch()==0) getch();
    fprintf(stderr, "\r                            \r");
}

/***************************************************************************/
void frdChk(unsigned char*frdBuf, unsigned long frdLen, FILE*frdHndl, unsigned char*frdName) {
/***************************************************************************/
    if((fread(&frdBuf[0], frdLen, 1, frdHndl)) == NULL) {
        printf("Unexpected EOF or error reading file '%s'\n", frdName);
        exit(3);
    }
}

/***************************************************************************/
void fwrChk(unsigned char*fwrBuf, unsigned long fwrLen, FILE*fwrHndl, unsigned char*fwrName) {
/***************************************************************************/
    if((fwrite(&fwrBuf[0], fwrLen, 1, fwrHndl)) == NULL) {
        printf("Error writing file '%s'\n", fwrName);
        exit(3);
    }
}

int AskYN(unsigned int DefaultYN) {
    unsigned char a;
    if(DefaultYN) printf(" Y");
    else          printf(" N");
    if(!TraceFLG) { printf("\n"); return(DefaultYN); }
    for(;;) {
        if((a=getch())==0) getch();
        if(a==27) {printf("\n\n*** EXITING BY ESCAPE ***\n\n"); exit(1);}
        if(a=='Y'||a=='y') {printf("\x8Y"); return(1);}
        if(a=='N'||a=='n') {printf("\x8N"); return(0);}
        if(a==0x0D)        {return(DefaultYN);}
    }
}


void getargs (int argc, char *argv[]);
/***************************************************************************/
int main (int argc, char *argv[]) {/********************************* main */
/***************************************************************************/
    unsigned long curFPtr = 0;
    getargs(argc, argv);

    printf("\n\nInput_JPG_file: '%s'\n", FnameInpJPG);
    if((HndlInpJPG=fopen(&FnameInpJPG[0], "rb")) == NULL) {
        printf("Cannot open for read input file: %s.\n", FnameInpJPG);
        exit(-2);
    }

    fseek(HndlInpJPG, 0L, SEEK_END);
    Flen = ftell(HndlInpJPG);
    fseek(HndlInpJPG, begFPtr, SEEK_SET);
    printf("Input_JPG_file_length = %ld byte(s)\n", (unsigned long)Flen);

    for(;;) {
        frdChk((unsigned char*)&ushtv1, 2, HndlInpJPG, FnameInpJPG);
        if(ushtv1!=0xD8FF) {
            printf("Invalid_start_JPG_id: must be 0xD8FF\n", FnameOutJPG);
            printf("Search for JPG ?[Y,N,ESC]", FnameOutJPG);
            if(AskYN(1)) {
                printf("\n");
                for(;;) {
                    frdChk((unsigned char*)&a, 1, HndlInpJPG, FnameInpJPG);
                    if(a==0xD8 && b==0xFF) {
                        curFPtr = (unsigned long)(ftell(HndlInpJPG)-2);
                        frdChk((unsigned char*)&ushtv1, 2, HndlInpJPG, FnameInpJPG);
                        frdChk((unsigned char*)&ushtv2, 2, HndlInpJPG, FnameInpJPG);
                        frdChk((unsigned char*)&ulngv, 4, HndlInpJPG, FnameInpJPG);
                        fseek(HndlInpJPG, curFPtr + 2, SEEK_SET);
                        if(ushtv1 != 0xe0ff) continue;
                        if(ulngv != 0x4649464A) continue;
                        ushtv1=0xD8FF;
                        break;
                    }
                    b=a;
                }
                printf("Found 0xD8FF at 0x%08lX\n", curFPtr);
            }
            else exit(-2);
        }

        if(GrabFLG) sprintf(FnameOutJPG, "%08lX.JPG", curFPtr);
        printf("Output_JPG_file: '%s'\n", FnameOutJPG);
        if((HndlOutJPG=fopen(&FnameOutJPG[0], "wb")) == NULL) {
            printf("Cannot create output file: %s.\n", FnameOutJPG);
            exit(-2);
        }
        fwrChk((unsigned char*)&ushtv1, 2, HndlOutJPG, FnameOutJPG);
        
        for(;;) {
            frdChk(((unsigned char*)&ushtv1)  , 2, HndlInpJPG, FnameInpJPG);
            if(ushtv1==0xDAFF) break;
            frdChk(((unsigned char*)&ushtv2)+1, 1, HndlInpJPG, FnameInpJPG);
            frdChk(((unsigned char*)&ushtv2)+0, 1, HndlInpJPG, FnameInpJPG);
            printf("Block_Id=0x%04lX, block_Len=0x%04lX in file '%s' at 0x%06lX", (unsigned long)ushtv1, (unsigned long)ushtv2, FnameInpJPG, (unsigned long)(ftell(HndlInpJPG)-4));
        
            if(
            ushtv1==0xE0FF ||
            ushtv1==0xDBFF ||
            ushtv1==0xC0FF ||
            ushtv1==0xDDFF ||
            ushtv1==0xC1FF ||
            ushtv1==0xC2FF ||
            ushtv1==0xC4FF) i=1;
            else i=0;
            if(TraceFLG) {/*printf(" [Y,N,ESC]");*/ i=(AskYN(i));}
            if(i) { // ᫨  ஢:
                fwrChk(((unsigned char*)&ushtv1)  , 2, HndlOutJPG, FnameOutJPG);
                fwrChk(((unsigned char*)&ushtv2)+1, 1, HndlOutJPG, FnameOutJPG);
                fwrChk(((unsigned char*)&ushtv2)+0, 1, HndlOutJPG, FnameOutJPG);
                --ushtv2;
                while(--ushtv2) {
                    frdChk((unsigned char*)&a, 1, HndlInpJPG, FnameInpJPG);
                    fwrChk((unsigned char*)&a, 1, HndlOutJPG, FnameOutJPG);
                }
                printf(" +\n");
            }
            else { // ᫨   ஢:
                --ushtv2;
                while(--ushtv2) {
                    frdChk((unsigned char*)&a, 1, HndlInpJPG, FnameInpJPG);
                }
                printf(" -\n");
            }
        }
        printf("Block_imageJPG (block_Id=0xDAFF) at 0x%06lX -- copying...\n", (unsigned long)(ftell(HndlInpJPG)-2));
        fwrChk((unsigned char*)&ushtv1, 2, HndlOutJPG, FnameOutJPG);
        b=0;
        for(;;) {
            frdChk((unsigned char*)&a, 1, HndlInpJPG, FnameInpJPG);
            fwrChk((unsigned char*)&a, 1, HndlOutJPG, FnameOutJPG);
            if(a==0xD9 && b==0xFF) break;
            b=a;
        }
        fclose(HndlOutJPG);
        
/******************************************* ᨬ   ६ ᮧ */
        i=fileno(HndlInpJPG);
        if(_dos_getftime(i, (unsigned*)&ushtv1, (unsigned*)&ushtv2))
            printf("ERROR get date and time for '%s'", FnameInpJPG);
        
/************************************* ⠭   ६ ᮧ */
        // ushtv1=Date ,  ushtv1=Time
        
        if ((HndlOutJPG=fopen(FnameOutJPG, "rb"))==NULL)
            {printf("open %s for setTimeDate failed\n", FnameOutJPG); exit(3);}
        i=fileno(HndlOutJPG);
        if(_dos_setftime(i, (unsigned short)ushtv1, (unsigned short)ushtv2))
            {printf("ERROR set date and time for '%s'", FnameOutJPG); exit(3);}
        fclose(HndlOutJPG);
        if(!GrabFLG) break;
    }
    printf("\nOK.");
    return(0);
}


/***************************************************************************/
void getargs(int argc, char *argv[]) {/********************* checking args */
/***************************************************************************/
    if(argc==1) usage();
/****************************************************** ࠧ६ switch': */
    while(--argc > 0) {
        argv++;
        if( ((*argv)[0] == '-') || ((*argv)[0] == '/')) {/*if switch in cmdln */
            switch((*argv)[1]) {
                case 'b':
                case 'B':
                    begFPtr = GetArgVal(&(*argv)[2]);
                    break;
                case 't': /* -t       - trace */
                case 'T': /* -t       - trace */
                    TraceFLG=1;
                    break;
                case 'g': /* -g       - Grab Mode */
                case 'G': /* -g       - Grab Mode */
                    GrabFLG=1;
                    break;
                case '?': /* -?       - help */
                case 'h': /* -h       - help */
                case 'H': /* -H       - help */
                    usage();
                default:
                    printf("Error in command line - invalid switch: %s\n\n",&(*argv)[0]);
                    usage();
            }
        }
        else {
/*****************  㬥 ( switch)   室 䠩: */
            if(!FnameInpJPG[0]) strcpy(FnameInpJPG, &(*argv)[0]);
            else {
/**************** ன 㬥 ( switch)   室 䠩: */
                if(!FnameOutJPG[0]) strcpy(FnameOutJPG, &(*argv)[0]);
                else {
/********************************** ⨩ 㬥 ( switch) - invalid: */
                    printf("Error in command line - 3rd argument is invalid: %s\n\n",&(*argv)[0]);
                    usage();
                }
            }
        }
    }
/******************************  㬥   室 䠩 */
    if(!FnameInpJPG[0]) {
        printf("Error in command line - not defined <InputBMP>\n\n");
        usage();
    }
/****************************************************  室 䠩 */
    if(!FnameOutJPG[0]) strcpy(FnameOutJPG, "$optim$.jpg");
}
