VERSION 5.00
Begin VB.Form Example 
   Caption         =   "Examples"
   ClientHeight    =   3105
   ClientLeft      =   5235
   ClientTop       =   4440
   ClientWidth     =   4065
   LinkTopic       =   "Form1"
   ScaleHeight     =   3105
   ScaleWidth      =   4065
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton Generate4 
      Caption         =   "Execute Script On Image"
      Height          =   495
      Left            =   360
      TabIndex        =   3
      Top             =   2400
      Width           =   3375
   End
   Begin VB.CommandButton Generate2 
      Caption         =   "Execute Script From Memory"
      Height          =   495
      Left            =   337
      TabIndex        =   2
      Top             =   935
      Width           =   3375
   End
   Begin VB.CommandButton GenerateAnimation 
      Caption         =   "Generate Animation"
      Height          =   495
      Left            =   352
      TabIndex        =   1
      Top             =   1667
      Width           =   3375
   End
   Begin VB.CommandButton Generate 
      Caption         =   "Execute Script From File"
      Height          =   495
      Left            =   352
      TabIndex        =   0
      Top             =   203
      Width           =   3375
   End
End
Attribute VB_Name = "Example"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Sub Generate_Click()

Dim HDR As ISL_HEADER
Dim Image As Long
Dim Filename As String
Dim Width, Height As Long

'Check that ISL 2.5 was loaded

If ISL_GetStringVersion = "2.5" Then

Filename = "molecular3.isf"

'Initialize the library

ISL_Initialize

'Read header of Image Styles script file

If ISL_ReadScriptHeaderFromFile(Filename, HDR) = ISL_NOERROR Then

'Get image width and height from header's structure

Width = HDR.Width
Height = HDR.Height

'Load Image Styles script file

ISL_LoadScriptFromFile Filename

'Initialize the library buffers
        
ISL_InitBuffers

'Allocate memory for 32-bits RGB image data

Image = GlobalAlloc(GPTR, Width * Height * 4)
GlobalLock (Image)

'Execute loaded script to generate the image

ISL_ExecuteScript Image

'Save generated image as bitmap file

ISL_SaveBMPImage "output_file.bmp", Image, Width, Height

'Free all memory resources used by library

ISL_Finish

'Free all memory resources used by generated image

GlobalUnlock Image
GlobalFree Image

Else
MsgBox "File not found.", vbExclamation, "ISL"
End
End If

MsgBox """output_file.bmp"" was successfully generated.", vbInformation, "ISL"

End If
End Sub

Private Sub Generate2_Click()

Dim HDR As ISL_HEADER
Dim DataLength As Long
Dim Image As Long
Dim Filename As String
Dim Width, Height As Long
Dim Mem As Long
Dim DataStore() As Byte
 
'Check that ISL 2.5 was loaded
 
If ISL_GetStringVersion = "2.5" Then

Filename = "cells.isf"

DataLength = FileLen(Filename)
ReDim DataStore(DataLength) As Byte

Mem = GlobalAlloc(GPTR, DataLength)
GlobalLock Mem

Open Filename For Binary As #1
Get 1, 1, DataStore
Call CopyMemory(ByVal Mem, DataStore(0), DataLength)
Close #1

'Initialize the library

ISL_Initialize

'Read header of Image Styles script file from memory

If ISL_ReadScriptHeaderFromMemory(Mem, HDR) = ISL_NOERROR Then

'Get image width and height from header's structure

Width = HDR.Width
Height = HDR.Height

'Load Image Styles script file from memory

ISL_LoadScriptFromMemory Mem

'Initialize the library buffers
        
ISL_InitBuffers

'Allocate memory for 32-bits RGB image data

Image = GlobalAlloc(GPTR, Width * Height * 4)
GlobalLock Image

'Execute loaded script to generate the image

ISL_ExecuteScript Image

'Save generated image as bitmap file

ISL_SaveBMPImage "output_memory.bmp", Image, Width, Height

'Free all memory resources used by library

ISL_Finish

'Free all memory resources used by generated image

GlobalUnlock Image
GlobalFree Image

GlobalUnlock Mem
GlobalFree Mem

Else
MsgBox "File not found.", vbExclamation, "ISL"
End
End If

MsgBox """output_memory.bmp"" was successfully generated.", vbInformation, "ISL"

End If
End Sub

Private Sub GenerateAnimation_Click()

Dim HDR As ISL_HEADER
Dim Image As Long
Dim Filename As String
Dim Width, Height As Long
Dim Value, Frame As Long

'Check that ISL 2.5 was loaded

If ISL_GetStringVersion = "2.5" Then

Filename = "background.isf"

'Initialize the library

ISL_Initialize

'Read header of Image Styles script file

If ISL_ReadScriptHeaderFromFile(Filename, HDR) = ISL_NOERROR Then

'Get image width and height from header's structure

Width = HDR.Width
Height = HDR.Height

'Load Image Styles script file

ISL_LoadScriptFromFile Filename

'Initialize the library buffers
        
ISL_InitBuffers

'Allocate memory for 32-bits RGB image data

Image = GlobalAlloc(GPTR, Width * Height * 4)
GlobalLock (Image)

'Start loop for 25 animation frames

For a = 0 To 240 Step 10

Frame = a / 10 + 1

GenerateAnimation.Caption = "Frame " + CStr(Frame)
Filename = "output" + Format(Frame, "00") + ".bmp"

'Execute loaded script to generate the image

ISL_ExecuteScript Image

'Save generated image as bitmap file

ISL_SaveBMPImage Filename, Image, Width, Height

'Get "Points" (first by order) "X Offset" effect's variable value

Value = ISL_GetEffectValue(0, ISL_Value11)

'Increase it by 10

Value = Value + 10

'Set changed value back

ISL_SetEffectValue 0, ISL_Value11, Value

Next a

'Free all memory resources used by library

ISL_Finish

'Free all memory resources used by generated image

GlobalUnlock Image
GlobalFree Image

GenerateAnimation.Caption = "Generate Animation"

Else
MsgBox "File not found.", vbExclamation, "ISL"
End
End If

MsgBox "Animation was successfully generated.", vbInformation, "ISL"

End If
End Sub
Private Sub Generate4_Click()

Dim HDR As ISL_HEADER
Dim Image As Long
Dim Filename As String
Dim Width, Height As Long

'Check that ISL 2.5 was loaded

If ISL_GetStringVersion = "2.5" Then

Filename = "molecular2.isf"

'Initialize the library

ISL_Initialize

'Read header of Image Styles script file

If ISL_ReadScriptHeaderFromFile(Filename, HDR) = ISL_NOERROR Then

'Load Image Styles script file

ISL_LoadScriptFromFile Filename

'Get "flower.jpg" image width and height

ISL_GetJPGImageDimensions "flower.jpg", Width, Height

'Allocate memory for 32-bits RGB image data

Image = GlobalAlloc(GPTR, Width * Height * 4)
GlobalLock (Image)

'Load "flower.jpg" to the allocated memory

ISL_LoadJPGImage "flower.jpg", Image

'Execute loaded script to generate the image

ISL_ExecuteScriptOnImage Image, Width, Height

'Save generated image as bitmap file

ISL_SaveBMPImage "output_image_file.bmp", Image, Width, Height

'Free all memory resources used by library

ISL_Finish

'Free all memory resources used by generated image

GlobalUnlock Image
GlobalFree Image

Else
MsgBox "File not found.", vbExclamation, "ISL"
End
End If

MsgBox """output_image_file.bmp"" was successfully generated.", vbInformation, "ISL"

End If
End Sub
