#include "stdafx.h"
#include "isl.h"

unsigned char *image;

int main(int argc, char* argv[])
{
	int width,height;

	/* Check that ISL 2.5 was loaded */

	if(ISL_GetVersion()=='2.5')
	{

	/* Initialize the library */

	ISL_Initialize();
	
	/* Get "flower.jpg" image width and height */

	ISL_GetJPGImageDimensions("flower.jpg",&width,&height);

	/* Allocate memory for 32-bits RGB image data */

	image=new unsigned char[width*height*4];

	/* Load "flower.jpg" to the allocated memory */

	ISL_LoadJPGImage("flower.jpg",image);

	/* Add "LINES" effect to the script */

	ISL_AddEffect(ISL_LINES,true);

	/* Set lines "Amount" value to 300 */

	ISL_SetEffectValue(ISL_Effect1,ISL_Value5,300);

	/* Add "CIRCLES" effect to the script */

	ISL_AddEffect(ISL_CIRCLES,true);
	
	/* Set circles "Amount" value to 500 */
	
	ISL_SetEffectValue(ISL_Effect1,ISL_Value5,500);

	/* Execute script to generate the image */

	ISL_ExecuteScriptOnImage(image,width,height);

	/* Save generated image as bitmap file */

	ISL_SaveBMPImage("output.bmp",image,width,height);

	/* Free all memory resources used by library */

	ISL_Finish();
	
	delete image;
	}

	return 0;
}
