#include "stdafx.h"
#include "isl.h"

char filename[]="bricks2.isf";
unsigned char *image;

int main(int argc, char* argv[])
{
	int width,height;
	ISL_ScriptHeader ish;

	/* Check that ISL 2.5 was loaded */

	if(ISL_GetVersion()=='2.5')
	{

	/* Initialize the library */

	ISL_Initialize();
	
	/* Read header of Image Styles script file */

	ISL_ReadScriptHeaderFromFile(filename,&ish);

	/* Load Image Styles script file */

	if(ISL_LoadScriptFromFile(filename)==ISL_NOERROR)
	{

	/* Get "flower.jpg" image width and height */

	ISL_GetJPGImageDimensions("flower.jpg",&width,&height);

	/* Allocate memory for 32-bits RGB image data */

	image=new unsigned char[width*height*4];

	/* Load "flower.jpg" to the allocated memory */

	ISL_LoadJPGImage("flower.jpg",image);

	/* Execute loaded script to generate the image */

	ISL_ExecuteScriptOnImage(image,width,height);

	/* Save generated image as bitmap file */

	ISL_SaveBMPImage("output.bmp",image,width,height);

	/* Free all memory resources used by library */

	ISL_Finish();
	
	delete image;
	}
	}

	return 0;
}
