#include "stdafx.h"
#include "windows.h"
#include "stdio.h"
#include "isl.h"

char filename[]="volumetric.isf";

unsigned char *image;
char output_filename[100];

int main(int argc, char* argv[])
{
	int a,width,height,val;
	ISL_ScriptHeader ish;

	/* Check that ISL 2.5 was loaded */

	if(ISL_GetVersion()=='2.5')
	{

	/* Initialize the library */

	ISL_Initialize();

	/* Read header of Image Styles script file */

	ISL_ReadScriptHeaderFromFile(filename,&ish);

	/* Get image width and height from header's structure */

	width=ish.width;
	height=ish.height;

	/* Load Image Styles script file */

	if(ISL_LoadScriptFromFile(filename)==ISL_NOERROR)
	{

	/* Initialize the library buffers */
		
	ISL_InitBuffers();

	/* Allocate memory for 32-bits RGB image data */

	image=new unsigned char[width*height*4];

	/* Start loop for 25 animation frames */

	for(a=0;a<250;a+=10)
	{
	wsprintf(output_filename,"output_%02d.bmp",a/10+1);

	/* Execute loaded script to generate the image */

	ISL_ExecuteScript(image);

	/* Save generated image as bitmap file */

	ISL_SaveBMPImage(output_filename,image,width,height);
	
	printf("*");

	/* Get "Sine Distortion" (second by order) "X Offset" effect's variable value */

	val=ISL_GetEffectValue(1,ISL_Value8);

	/* Increase it by 10 */

	val+=10;

	/* Set changed value back */

	ISL_SetEffectValue(1,ISL_Value8,val);

	}

	/* Free all memory resources used by library */

	ISL_Finish();

	delete image;
	}
	}

	printf("\n");
	
	return 0;
}