#include "stdafx.h"
#include "isl.h"

unsigned char *image;

unsigned char grass[]={
96,0,0,0,73,83,70,50,45,1,0,0,3,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,40,67,41,
32,50,48,48,50,32,80,97,117,114,101,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,
1,1,1,76,0,0,0,4,0,0,0,0,0,0,0,186,91,0,0,224,10,0,0,4,0,0,0,64,0,0,0,32,0,
0,0,1,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,50,0,0,0,1,0,0,0,24,0,0,0,28,0,0,0,0,0,0,0,149,0,0,0,15,1,0,0,89,
0,0,0,24,0,0,0,57,0,0,0,0,0,0,0,1,0,0,0,100,0,0,0,0,0,0,0,255 };

int main(int argc, char* argv[])
{
	int width,height;
	ISL_ScriptHeader ish;

	/* Check that ISL 2.5 was loaded */

	if(ISL_GetVersion()=='2.5')
	{

	/* Initialize the library */

	ISL_Initialize();
	
	/* Read header of Image Styles script file from memory */
	
	ISL_ReadScriptHeaderFromMemory((unsigned char *)grass,&ish);

	/* Get image width and height from header's structure */

	width=ish.width;
	height=ish.height;
	
	/* Load Image Styles script file from memory */

	if(ISL_LoadScriptFromMemory((unsigned char *)grass)==ISL_NOERROR)
	{
    
	/* Initialize the library buffers */
		
	ISL_InitBuffers();

	/* Allocate memory for 32-bits RGB image data */

	image=new unsigned char[width*height*4];

	/* Execute loaded script to generate the image */

	ISL_ExecuteScript(image);

	/* Save generated image as bitmap file */

	ISL_SaveBMPImage("output.bmp",image,width,height);

	/* Free all memory resources used by library */

	ISL_Finish();
	
	delete image;
	}
	}

	return 0;
}
