#ifdef ISL_EXPORTS
#define ISL_API __declspec(dllexport)
#else
#define ISL_API __declspec(dllimport)
#endif

#define ISL_Value1	 0
#define ISL_Value2	 1
#define ISL_Value3	 2
#define ISL_Value4	 3
#define ISL_Value5	 4
#define ISL_Value6	 5
#define ISL_Value7	 6
#define ISL_Value8	 7
#define ISL_Value9	 8
#define ISL_Value10	 9
#define ISL_Value11	 10
#define ISL_Value12	 11
#define ISL_Value13	 12
#define ISL_Value14	 13
#define ISL_Value15	 14
#define ISL_Value16	 15
#define ISL_Value17	 16
#define ISL_Value18	 17
#define ISL_Value19	 18
#define ISL_Value20	 19

#define ISL_Effect1	 0
#define ISL_Effect2	 1
#define ISL_Effect3	 2
#define ISL_Effect4	 3
#define ISL_Effect5	 4
#define ISL_Effect6	 5
#define ISL_Effect7	 6
#define ISL_Effect8	 7
#define ISL_Effect9	 8
#define ISL_Effect10 9
#define ISL_Effect11 10
#define ISL_Effect12 11
#define ISL_Effect13 12
#define ISL_Effect14 13
#define ISL_Effect15 14
#define ISL_Effect16 15
#define ISL_Effect17 16
#define ISL_Effect18 17
#define ISL_Effect19 18
#define ISL_Effect20 19

#define ISL_LINES 1
#define ISL_CIRCLES 2
#define ISL_RECTANGLES 3
#define ISL_SPLINES 4
#define ISL_PLASMA 5
#define ISL_TWIRL 6
#define ISL_BLUR 7
#define ISL_CLEAR_IMAGE 8
#define ISL_GAMMA_CORRECTION 9
#define ISL_BRIGHTNESS 10
#define ISL_PERLIN_NOISE 11
#define ISL_MOVE_TO_BUFFER 12
#define ISL_SINE_DISTORTION 13
#define ISL_DISTORTION_BY_BUFFER 14
#define ISL_CONNECT_BUFFER 15
#define ISL_WAVES 16
#define ISL_DIVIDER 17
#define ISL_CARPET 18
#define ISL_EDGE 19
#define ISL_BLOBS 20
#define ISL_NOISE 21
#define ISL_VOXEL 22
#define ISL_EMBOSS 23
#define ISL_SINE_PLASMA 24
#define ISL_MAXIMUM 25
#define ISL_MINIMUM 26
#define ISL_BUMP 27
#define ISL_COLORIZE 28
#define ISL_INVERSION 29
#define ISL_THRESHOLD 30
#define ISL_CONTRAST 31
#define ISL_HSV 32
#define ISL_ADD_TO_BUFFER 33
#define ISL_EXCHANGE_BUFFER 34
#define ISL_UNSHARP_MASK 35
#define ISL_MEDIAN 36
#define ISL_WORMS 37
#define ISL_OFFSET 38
#define ISL_GLASS 39
#define ISL_IMAGE_FILE 40
#define ISL_FLIP 41
#define ISL_PATTERN 42
#define ISL_POINTS 43
#define ISL_SHIFTER 44
#define ISL_PINCH 45
#define ISL_MOTION_BLUR 46
#define ISL_FREEHAND_LAYER 47
#define ISL_GRADIENT_MAP 48
#define ISL_KALEIDOSCOPE 49
#define ISL_ZOOM 50
#define ISL_ROTATE 51
#define ISL_SEAMLESS 52
#define ISL_BORDER 53
#define ISL_TILT 54
#define ISL_FRACTAL_PLASMA 55
#define ISL_SCRATCH 56
#define ISL_GAUSSIAN_BLUR 57
#define ISL_TREES 58
#define ISL_FIBERS 59

#define ISL_NOERROR 1

typedef struct
{
    int soh;
    int marker;
    int version;
    int effects;
    int width;
    int height;
    int seamless;
    char remark[64];
    int buffers;
    int rnd;
} ISL_ScriptHeader;

extern "C"
{
ISL_API bool __stdcall  ISL_Initialize();

ISL_API bool __stdcall  ISL_LoadScriptFromFile(const char *);
ISL_API bool __stdcall  ISL_LoadScriptFromMemory(unsigned char *);

ISL_API bool __stdcall  ISL_ReadScriptHeaderFromFile(const char *,ISL_ScriptHeader *);
ISL_API bool __stdcall  ISL_ReadScriptHeaderFromMemory(unsigned char *,ISL_ScriptHeader *);

ISL_API bool __stdcall  ISL_AddEffect(int,int);
ISL_API int  __stdcall  ISL_GetEffectValue(int,int);
ISL_API void __stdcall  ISL_SetEffectValue(int,int,int);

ISL_API void __stdcall  ISL_ExecuteScript(void *);
ISL_API bool __stdcall  ISL_ExecuteScriptOnImage(void *,int,int);

ISL_API bool __stdcall  ISL_InitBuffers();
ISL_API bool __stdcall  ISL_InitBuffers_WH(int,int);

ISL_API void __stdcall  ISL_Finish();

ISL_API bool __stdcall  ISL_GetJPGImageDimensions(const char *,int *,int *);
ISL_API bool __stdcall  ISL_LoadJPGImage(const char *,unsigned char *);
ISL_API bool __stdcall  ISL_SaveJPGImage(const char *,unsigned char *,int,int);
ISL_API bool __stdcall  ISL_SaveBMPImage(const char *,unsigned char *,int,int);

ISL_API int  __stdcall  ISL_GetVersion();
}