#include "stdafx.h"
#include "isl.h"

char filename[]="cords.isf";
unsigned char *image;

int main(int argc, char* argv[])
{
	int width,height;
	ISL_ScriptHeader ish;

	/* Check that ISL 2.5 was loaded */

	if(ISL_GetVersion()=='2.5')
	{

	/* Initialize the library */

	ISL_Initialize();
	
	/* Read header of Image Styles script file */

	ISL_ReadScriptHeaderFromFile(filename,&ish);

	/* Get image width and height from header's structure */

	width=ish.width;
	height=ish.height;
	
	/* Load Image Styles script file */

	if(ISL_LoadScriptFromFile(filename)==ISL_NOERROR)
	{
    
	/* Initialize the library buffers */
		
	ISL_InitBuffers();

	/* Allocate memory for 32-bits RGB image data */

	image=new unsigned char[width*height*4];

	/* Execute loaded script to generate the image */

	ISL_ExecuteScript(image);

	/* Save generated image as bitmap file */

	ISL_SaveBMPImage("output.bmp",image,width,height);

	/* Free all memory resources used by library */

	ISL_Finish();
	
	delete image;
	}
	}

	return 0;
}
