unit Example;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ISL, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);

var

ish: ISL_ScriptHeader;
width,height: DWORD;
filename: string;
image: PChar;

begin

filename:='inside_the_robot.isf';

if ISL_GetStringVersion()='2.5' then begin

// Initialize the library

ISL_Initialize();

// Read header of Image Styles script file

if ISL_ReadScriptHeaderFromFile(PChar(filename),ish)=True then begin

// Get image width and height from header's structure

width:=ish.width;
height:=ish.height;

// Load Image Styles script file

ISL_LoadScriptFromFile(PChar(filename));

// Allocate memory for 32-bits RGB image data

GetMem(image,width*height*4);

//Initialize the library buffers

ISL_InitBuffers();

// Execute loaded script to generate the image

ISL_ExecuteScript(image);

// Save generated image as bitmap file

ISL_SaveBMPImage(PChar('output_file.bmp'),image,width,height);

// Free all memory resources used by library

ISL_Finish();

// Free all memory resources used by generated image

FreeMem(image);

MessageBox(0, '"output_file.bmp" was successfully generated.', 'ISL', MB_ICONINFORMATION);

end

Else MessageBox(0, 'File not found.', 'ISL', MB_ICONEXCLAMATION);

end

end;

procedure TForm1.Button2Click(Sender: TObject);

var

ish: ISL_ScriptHeader;
width,height: DWORD;
image: PChar;

const memfile: array[0..408] of BYTE =
( 92,0,0,0,73,83,70,50,200,0,0,0,9,0,0,0,0,1,0,0,0,1,
0,0,1,0,0,0,40,67,41,32,50,48,48,50,32,80,97,117,114,
101,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,
0,0,0,1,0,0,0,0,0,0,0,190,116,0,0,177,1,0,0,44,0,0,0,198,
0,0,0,1,0,0,0,255,0,0,0,172,0,0,0,59,0,0,0,255,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,50,0,0,0,1,0,0,0,76,
0,0,0,1,0,0,0,0,0,0,0,137,104,0,0,98,3,0,0,36,0,0,0,173,
0,0,0,1,0,0,0,255,0,0,0,143,0,0,0,45,0,0,0,255,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,50,0,0,0,1,0,0,0,32,
0,0,0,6,0,0,0,0,0,0,0,216,0,0,0,3,0,0,0,3,0,0,0,93,112,
0,0,0,0,0,0,20,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,16,
0,0,0,25,0,0,0,0,0,0,0,1,0,0,0,24,0,0,0,39,0,0,0,0,0,0,0,
203,85,0,0,37,0,0,0,3,0,0,0,32,0,0,0,23,0,0,0,0,0,0,0,12,
0,0,0,237,0,0,0,66,0,0,0,0,0,0,0,77,0,0,0,16,0,0,0,9,0,0,
0,0,0,0,0,131,0,0,0,24,0,0,0,10,0,0,0,0,0,0,0,157,0,0,0,
162,0,0,0,151,0,0,0,255 );

begin

if ISL_GetStringVersion()='2.5' then begin

// Initialize the library

ISL_Initialize();

// Read header of Image Styles script file from memory

if ISL_ReadScriptHeaderFromMemory(@memfile,ish)=True then begin

// Get image width and height from header's structure

width:=ish.width;
height:=ish.height;

// Load Image Styles script file from memory

ISL_LoadScriptFromMemory(@memfile);

// Allocate memory for 32-bits RGB image data

GetMem(image,width*height*4);

//Initialize the library buffers

ISL_InitBuffers();

// Execute loaded script to generate the image

ISL_ExecuteScript(image);

// Save generated image as bitmap file

ISL_SaveBMPImage(PChar('output_memory.bmp'),image,width,height);

// Free all memory resources used by library

ISL_Finish();

// Free all memory resources used by generated image

FreeMem(image);

MessageBox(0, '"output_memory.bmp" was successfully generated.', 'ISL', MB_ICONINFORMATION);

end

Else MessageBox(0, 'File not found.', 'ISL', MB_ICONEXCLAMATION);

end;

end;

procedure TForm1.Button3Click(Sender: TObject);
var

ish: ISL_ScriptHeader;
value,width,height,a: DWORD;
filename: string;
image: PChar;

begin

filename:='ground3.isf';

if ISL_GetStringVersion()='2.5' then begin

// Initialize the library

ISL_Initialize();

// Read header of Image Styles script file

if ISL_ReadScriptHeaderFromFile(PChar(filename),ish)=True then begin

// Get image width and height from header's structure

width:=ish.width;
height:=ish.height;

// Load Image Styles script file

ISL_LoadScriptFromFile(PChar(filename));

// Allocate memory for 32-bits RGB image data

GetMem(image,width*height*4);

// Start loop for 25 animation frames

//Initialize the library buffers

ISL_InitBuffers();

For a:=0 To 24 do begin

Button3.Caption:='Frame: '+IntToStr(a+1);

if a<9 then filename:='output0' else filename:='output';

// Execute loaded script to generate the image

ISL_ExecuteScript(image);

// Save generated image as bitmap file

ISL_SaveBMPImage(PChar(filename+IntToStr(a+1)+'.bmp'),image,width,height);

// Get "Plasma" (first by order) "X Offset" effect's variable value

value:=ISL_GetEffectValue(ISL_Effect1, ISL_Value10);

// Increase it by 10

value:=value+10;

// Set changed value back

ISL_SetEffectValue(ISL_Effect1, ISL_Value10, value);

end;

// Free all memory resources used by library

ISL_Finish();

// Free all memory resources used by generated image

FreeMem(image);

Button3.Caption:='Generate Animation';

MessageBox(0, 'Animation was successfully generated.', 'ISL', MB_ICONINFORMATION);

end

Else MessageBox(0, 'File not found.', 'ISL', MB_ICONEXCLAMATION);

end

end;

procedure TForm1.Button4Click(Sender: TObject);
var

ish: ISL_ScriptHeader;
width,height: DWORD;
filename: string;
image: PChar;

begin

filename:='molecular2.isf';

if ISL_GetStringVersion()='2.5' then begin

// Initialize the library

ISL_Initialize();

// Read header of Image Styles script file

if ISL_ReadScriptHeaderFromFile(PChar(filename),ish)=True then begin

// Get 'flower.jpg' image width and height

ISL_GetJPGImageDimensions('flower.jpg',@width,@height);

// Load Image Styles script file

ISL_LoadScriptFromFile(PChar(filename));

// Allocate memory for 32-bits RGB image data

GetMem(image,width*height*4);

// Load 'flower.jpg' to the allocated memory

ISL_LoadJPGImage('flower.jpg',image);

// Execute loaded script to generate the image

ISL_ExecuteScriptOnImage(image,width,height);

// Save generated image as bitmap file

ISL_SaveBMPImage(PChar('output_image_file.bmp'),image,width,height);

// Free all memory resources used by library

ISL_Finish();

// Free all memory resources used by generated image

FreeMem(image);

MessageBox(0, '"output_image_file.bmp" was successfully generated.', 'ISL', MB_ICONINFORMATION);

end

Else MessageBox(0, 'File not found.', 'ISL', MB_ICONEXCLAMATION);

end

end;

end.
