unit ISL;

interface

Uses

Windows, SysUtils;

const

ISL_Value1	= 0;
ISL_Value2	= 1;
ISL_Value3	= 2;
ISL_Value4	= 3;
ISL_Value5	= 4;
ISL_Value6	= 5;
ISL_Value7	= 6;
ISL_Value8	= 7;
ISL_Value9	= 8;
ISL_Value10	= 9;
ISL_Value11	= 10;
ISL_Value12	= 11;
ISL_Value13	= 12;
ISL_Value14	= 13;
ISL_Value15	= 14;
ISL_Value16	= 15;
ISL_Value17	= 16;
ISL_Value18	= 17;
ISL_Value19	= 18;
ISL_Value20	= 19;

ISL_Effect1	= 0;
ISL_Effect2	= 1;
ISL_Effect3	= 2;
ISL_Effect4	= 3;
ISL_Effect5	= 4;
ISL_Effect6	= 5;
ISL_Effect7	= 6;
ISL_Effect8	= 7;
ISL_Effect9	= 8;
ISL_Effect10	= 9;
ISL_Effect11	= 10;
ISL_Effect12	= 11;
ISL_Effect13	= 12;
ISL_Effect14	= 13;
ISL_Effect15	= 14;
ISL_Effect16	= 15;
ISL_Effect17	= 16;
ISL_Effect18	= 17;
ISL_Effect19	= 18;
ISL_Effect20	= 19;

ISL_LINES = 1;
ISL_CIRCLES = 2;
ISL_RECTANGLES = 3;
ISL_SPLINES = 4;
ISL_PLASMA = 5;
ISL_TWIRL = 6;
ISL_BLUR = 7;
ISL_CLEAR_IMAGE = 8;
ISL_GAMMA_CORRECTION = 9;
ISL_BRIGHTNESS = 10;
ISL_PERLIN_NOISE = 11;
ISL_MOVE_TO_BUFFER = 12;
ISL_SINE_DISTORTION = 13;
ISL_DISTORTION_BY_BUFFER = 14;
ISL_CONNECT_BUFFER = 15;
ISL_WAVES = 16;
ISL_DIVIDER = 17;
ISL_CARPET = 18;
ISL_EDGE = 19;
ISL_BLOBS = 20;
ISL_NOISE = 21;
ISL_VOXEL = 22;
ISL_EMBOSS = 23;
ISL_SINE_PLASMA = 24;
ISL_MAXIMUM = 25;
ISL_MINIMUM = 26;
ISL_BUMP = 27;
ISL_COLORIZE = 28;
ISL_INVERSION = 29;
ISL_THRESHOLD = 30;
ISL_CONTRAST = 31;
ISL_HSV = 32;
ISL_ADD_TO_BUFFER = 33;
ISL_EXCHANGE_BUFFER = 34;
ISL_UNSHARP_MASK = 35;
ISL_MEDIAN = 36;
ISL_WORMS = 37;
ISL_OFFSET = 38;
ISL_GLASS = 39;
ISL_IMAGE_FILE = 40;
ISL_FLIP = 41;
ISL_PATTERN = 42;
ISL_POINTS = 43;
ISL_SHIFTER = 44;
ISL_PINCH = 45;
ISL_MOTION_BLUR = 46;
ISL_FREEHAND_LAYER = 47;
ISL_GRADIENT_MAP = 48;
ISL_KALEIDOSCOPE = 49;
ISL_ZOOM = 50;
ISL_ROTATE = 51;
ISL_SEAMLESS = 52;
ISL_BORDER = 53;
ISL_TILT = 54;
ISL_FRACTAL_PLASMA = 55;
ISL_SCRATCH = 56;
ISL_GAUSSIAN_BLUR = 57;
ISL_TREES = 58;
ISL_FIBERS = 59;

type

BOOL  = LongBool;

ISL_ScriptHeader = record
    soh:        DWORD;
    marker:     DWORD;
    version:    DWORD;
    effects:    DWORD;
    width:      DWORD;
    height:     DWORD;
    seamless:   DWORD;
    remark:     array[0..64] of BYTE;
    buffers:    DWORD;
    rnd:        DWORD;
end;

function ISL_Initialize(): BOOL; stdcall; external 'isl.dll' name '_ISL_Initialize@0';

function ISL_ReadScriptHeaderFromFile(filename: PChar; var header: ISL_ScriptHeader): BOOL; stdcall; external 'isl.dll' name '_ISL_ReadScriptHeaderFromFile@8';
function ISL_ReadScriptHeaderFromMemory(mem: Pointer; var header: ISL_ScriptHeader): BOOL; stdcall; external 'isl.dll' name '_ISL_ReadScriptHeaderFromMemory@8';

function ISL_LoadScriptFromFile(filename: PChar): BOOL; stdcall; external 'isl.dll' name '_ISL_LoadScriptFromFile@4';
function ISL_LoadScriptFromMemory(mem: PChar): BOOL; stdcall; external 'isl.dll' name '_ISL_LoadScriptFromMemory@4';

function ISL_GetEffectValue(nb_eff: DWORD; nb_value: DWORD): DWORD; stdcall; external 'isl.dll' name '_ISL_GetEffectValue@8';
procedure ISL_SetEffectValue(nb_eff: DWORD; nb_value: DWORD; value: DWORD); stdcall; external 'isl.dll' name '_ISL_SetEffectValue@12';

function ISL_InitBuffers(): BOOL; stdcall; external 'isl.dll' name '_ISL_InitBuffers@0';
function ISL_InitBuffers_WH(width: DWORD; height: DWORD): BOOL; stdcall; external 'isl.dll' name '_ISL_InitBuffers_WH@8';

function ISL_AddEffect(eff_id: DWORD; seamless: DWORD): BOOL; stdcall; external 'isl.dll' name '_ISL_AddEffect@8';
procedure ISL_ExecuteScript(mem: Pointer); stdcall; external 'isl.dll' name '_ISL_ExecuteScript@4';
procedure ISL_ExecuteScriptOnImage(mem: Pointer; width: DWORD; height: DWORD); stdcall; external 'isl.dll' name '_ISL_ExecuteScriptOnImage@12';

procedure ISL_Finish(); stdcall; external 'isl.dll' name '_ISL_Finish@0';

function ISL_GetJPGImageDimensions(filename: PChar; width: Pointer; height: Pointer): BOOL; stdcall; external 'isl.dll' name '_ISL_GetJPGImageDimensions@12';
function ISL_LoadJPGImage(filename: PChar; mem: PChar): BOOL; stdcall; external 'isl.dll' name '_ISL_LoadJPGImage@8';
function ISL_SaveBMPImage(filename: PChar; mem: PChar; width: DWORD; height: DWORD): BOOL; stdcall; external 'isl.dll' name '_ISL_SaveBMPImage@16';
function ISL_SaveJPGImage(filename: PChar; mem: PChar; width: DWORD; height: DWORD): BOOL; stdcall; external 'isl.dll' name '_ISL_SaveJPGImage@16';

function ISL_GetVersion(): DWORD; stdcall; external 'isl.dll' name '_ISL_GetVersion@0';
function ISL_GetStringVersion(): String;

implementation

function ISL_GetStringVersion(): String;

var

value: DWORD;
str: String;

begin

value:=ISL_GetVersion() And 16711680;
value:=(value shr 16)-48;
str:=IntToStr(value) + '.';
value:=ISL_GetVersion() And 255;
value:=value-48;
str:=str+IntToStr(value);

ISL_GetStringVersion:=str;

end;

end.
