// BatchExampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "BatchExample.h"
#include "BatchExampleDlg.h"
#include "ISL.h"
#include "InfoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBatchExampleDlg dialog

CBatchExampleDlg::CBatchExampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBatchExampleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBatchExampleDlg)
	m_sf = _T("");
	m_od = _T("");
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CBatchExampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBatchExampleDlg)
	DDX_Control(pDX, IDC_LIST1, m_il);
	DDX_Text(pDX, IDC_EDIT1, m_sf);
	DDX_Text(pDX, IDC_EDIT2, m_od);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBatchExampleDlg, CDialog)
	//{{AFX_MSG_MAP(CBatchExampleDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_BN_CLICKED(IDC_BUTTON4, OnButton4)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON6, OnButton6)
	ON_BN_CLICKED(IDC_BUTTON5, OnButton5)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBatchExampleDlg message handlers

BOOL CBatchExampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CBatchExampleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CBatchExampleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CBatchExampleDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

void CBatchExampleDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CBatchExampleDlg::OnButton2() 
{
	CFileDialog openfile(TRUE,"*.jpg",NULL,OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_LONGNAMES|OFN_HIDEREADONLY|OFN_ALLOWMULTISELECT,"JPEG Files (*.jpg)|*.jpg||");

	char* pc;

	DWORD MAXFILE=2562*100;
	openfile.m_ofn.nMaxFile = MAXFILE;
	pc = (char *)new char[MAXFILE];
	openfile.m_ofn.lpstrFile = pc;
	openfile.m_ofn.lpstrFile[0] = NULL;

	if(openfile.DoModal()==IDOK)
	{
	POSITION pos=openfile.GetStartPosition();
	while(pos!=NULL) m_il.AddString(openfile.GetNextPathName(pos));
	}
	
	delete []pc;	
}

void CBatchExampleDlg::OnButton3() 
{
	if((m_il.GetCount()!=0)&&(m_il.GetCurSel()>=0))	m_il.DeleteString(m_il.GetCurSel());
}

void CBatchExampleDlg::OnButton4() 
{
	m_il.ResetContent();
}

void CBatchExampleDlg::OnButton1() 
{
	CFileDialog openfile(TRUE,"*.isf",NULL,OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_LONGNAMES|OFN_HIDEREADONLY,"Image Styles Script Files (*.isf)|*.isf||");

	if(openfile.DoModal()==IDOK)
	{
	m_sf=openfile.GetPathName();
	UpdateData(false);
	}
}

void CBatchExampleDlg::OnButton6() 
{
   CString path;
   char charpath[MAX_PATH];
   BROWSEINFO bi;
   int rinfo;

   ZeroMemory(&bi,sizeof(bi));
   
   TCHAR szDisplayName[MAX_PATH];
   szDisplayName[0]='\0';

   bi.hwndOwner=NULL;
   bi.pidlRoot=NULL;
   bi.pszDisplayName=szDisplayName;
   bi.ulFlags=BIF_VALIDATE;
   bi.lParam=NULL;
   bi.iImage=0;

   LPITEMIDLIST pidl=SHBrowseForFolder(&bi);
   rinfo=SHGetPathFromIDList(pidl,charpath);
   path=charpath;
   if(path.Right(1)!="\\") path+="\\";   
   
   if(rinfo==TRUE)
   {
   m_od=path;
   UpdateData(false);
   }	
}

void CBatchExampleDlg::OnButton5() 
{
	CString fpn,ofn,infostr;
	int width,height;
	unsigned char *image;
	InfoDlg info;

	if(m_il.GetCount()<1)
	{
	MessageBox("At least one file name should be present in the input files list.","Warning...",MB_ICONEXCLAMATION);
	return;
	}

	if(m_sf=="")
	{
	MessageBox("Please specify a script file.","Warning...",MB_ICONEXCLAMATION);
	return;
	}

	if(m_od=="")
	{
	MessageBox("Please specify an output directory.","Warning...",MB_ICONEXCLAMATION);
	return;
	}

	if(ISL_GetVersion()=='2.5')
	{

	ISL_Initialize();
	BeginWaitCursor();

	info.Create(IDD_INFO,this);
	info.CenterWindow(this);
	info.ShowWindow(SW_SHOW);

	ISL_LoadScriptFromFile(m_sf);

	for(int a=0;a<m_il.GetCount();a++)
	{
	infostr.Format("Processing file %d of %d",a+1,m_il.GetCount());
	info.m_infotxt=infostr;
	info.UpdateData(false);
	info.UpdateWindow();
	
	m_il.GetText(a,fpn);
	
	ISL_GetJPGImageDimensions(fpn,&width,&height);
	
	image=new unsigned char[width*height*4];
	
	ISL_LoadJPGImage(fpn,image);
	ISL_ExecuteScriptOnImage(image,width,height);
	
	ofn=fpn;
	ofn=ofn.Right(ofn.GetLength()-ofn.ReverseFind('\\')-1);

	ISL_SaveJPGImage(m_od+"output-"+ofn,image,width,height);

	delete image;
	}

	ISL_Finish();

	info.DestroyWindow();
	
	EndWaitCursor();
	MessageBox("Batch process complete successfully!","Info",MB_ICONINFORMATION);
	}
}