/*
 * Imagery Version 1.0 Copyright (C) 1995 Ursus Computing Pty. Ltd.
 * Function Headers and Structure Definitions
 * Note that all references to HANDLE's are void* in the 32-bit version
 * and that HANDLE's are unsigned int in the 16-bit version
 */

#ifndef __IMAGERY__
#define __IMAGERY__
#include <windows.h>

#define FILE_BMP        0	/* Windows compatible Bitmap */
#define FILE_OS2        1	/* OS/2 BMP file */
#define FILE_GIF        2	/* Compuserve GIF (unsupported) */
#define FILE_PPM        3	/* Portable Pixmap */
#define FILE_TGA        5	/* Truevision Targa */
#define FILE_TIFF       6	/* Aldus TIFF Revision 6 */
#define FILE_PSD        7	/* PhotoShop Bitmap (v2.5) */
#define FILE_PCX        8	/* Zsoft PCX */
#define FILE_SGI        9	/* Silicon Graphics image file */
#define FILE_SUNRAS     11	/* Sun Raster file */
#define FILE_PNG        12	/* Portable Network Graphics */
#define FILE_JPEG       13	/* JFIF compatible JPEG */

/*
 * Compression types used in File Formats
 */
#define TIFF_NONE			0 /* No compression */
#define TIFF_LZW			1 /* LZW compression */
#define TIFF_PACK			2 /* Packbits compression */
#define TIFF_NEXT			3 /* 2-bit NeXT Compression (unsupported) */
#define TIFF_FAX_G3     	4 /* FAX Group 3 compression (unsupported) */
#define TIFF_FAX_G4     	5 /* FAX Group 4 compression (unsupported) */
#define TIFF_THUNDERSCAN	6 /* Thunderscan RLE 4-bit (unsupported) */
#define TIFF_RLE			7 /* RLE compression (unsupported) */
#define TIFF_JPEG			8 /* JPEG DCT compression */

/*
 * Colour space formats
 */
#define IMG_RGB_24		0 /* 24-bit Red, Green, Blue values */
#define IMG_RGB_8		2 /* 8-bit Paletted */
#define IMG_GRAY_8		5 /* 8-bit Grayscale (gray palette)*/
#define IMG_CMYK		6 /* 32-bit CMYK */
#define IMG_YCbCr		8 /* 24-bit YCbCr/YCC/YUV format (JPEG) */

/*
 * JPEG sampling factors
 */
#define SAMPLE_NONE		0 /* No sampling factors (24-bit/grayscale)*/
#define SAMPLE_411		1 /* 4:1:1 sampling factors (24-bit)*/
#define SAMPLE_422		2 /* 4:2:2 sampling factors (24-bit)*/
#define SAMPLE_2112		3 /* 2:1:1:2 sampling factors (CMYK) */
#define SAMPLE_1111		4 /* 1:1:1:1 sampling factors (CMYK) */

typedef struct FileInfo{
	int Width;				/* Image width in pixels */
	int Height;				/* Image height in pixels */
	DWORD ImageSize;		/* Image size in bytes when in memory */
	int BitsPerPixel;		/* Bits Per Pixel of Image */
	DWORD FileSize;			/* Size of file on disk */
	int ImageClass;			/* Colour space of image file */
	int FileFormat;			/* Image file format */
	char szComments[80];	/* comments found in file */
	int CompressionRatio;	/* compression ratio (HIBYTE:LOBYTE) */
	int CompressionMethod;	/* compression method (TIFF definitions) */
	HANDLE hPreview;		/* DIB handle of preview */
	DWORD PreviewSize;		/* Size of preview DIB */
	int PreviewWidth;		/* Preview width in pixels */
	int PreviewHeight;		/* Preview height in pixels*/
	BYTE Colormap[3][256];	/* Colormap */
	int JPEGQuality;		/* Approximate quality factor for JPEG */
	int JPEGSampling;		/* JPEG sampling factors */
	LPSTR szJPEGType;		/* Literal description of JPEG encoding */
	BOOL bInterlaced;		/* TRUE if interlaced PNG */
	BOOL bPreview;			/* TRUE if there is a preview image */
	BOOL bReadable;			/* TRUE if readable */
	BOOL bMask;				/* TRUE if a mask/alpha channel was found */
} FileInfo;

typedef struct WriteOptions{
	int ImageClass;		/* Colour space */
	BOOL bWriteAlpha;	/* Write an alpha channel (individual libraries only)*/
	BOOL bWritePreview;	/* Write a Preview of pre-calculated dimensions */
	int JPEGQuality;	/* JPEG quality factor */
	int Compression;	/* TIFF compression method */
	int FileFormat;		/* File Format to be output */
	int SegmentSize;	/* TIFF segment size (kb) */
	BOOL bPredictor;	/* LZW predictor for TIFF LZW */
	int JPEGSampling;	/* Sampling factors for JPEG compression */
	LPSTR szComments;	/* Comments to be inserted into file */
	BOOL bInterlaced;	/* Whether a PNG file will be written interlaced */
} WriteOptions;


/* Initialize Imagery Library */
UINT WINAPI InitLib(UINT,HWND,UINT);

/* Perform cleanup of Imagery Library */
int WINAPI EndLib(void);

/* 
 * Function headers for File input/output
 */
/* Read any supported file format into a DIB */
HANDLE WINAPI ReadImage(LPSTR);

/* Write any supported file format from a 24-bit or 8-bit DIB */
UINT WINAPI WriteImage(LPSTR,HANDLE,WriteOptions*);

/* Retrieve information about an image file */
int WINAPI GetFileInfo(LPSTR,FileInfo*);

/*
 * Function headers for Image manipulation
 */
/* Retrieve a specific channel from a 24-bit DIB */
HANDLE WINAPI GetChannel(HANDLE,int);

/* Set a specific channel in a 24-bit DIB */
HANDLE WINAPI PutChannel(HANDLE,HANDLE,int);

/* Combine 3 channels to form a 24-bit DIB */
HANDLE WINAPI CombineChannels(HANDLE,HANDLE,HANDLE);

/* Convert the colour space of a DIB */
HANDLE WINAPI ColorConvert(HANDLE,int);

/* Adjust the gamma of a DIB */
HANDLE WINAPI GammaCorrect(HANDLE,float,float,float);

/* Adjust the gamma of a DIB (red,green and blue can be different) */
//HANDLE WINAPI ColorCorrect(HANDLE,float,float,float);

/* Add distributed/random noise to a 24-bit DIB */
HANDLE WINAPI AddNoise(HANDLE,int,int);

/* Crop a DIB to new dimensions */
HANDLE WINAPI CropImage(HANDLE,RECT);

/* Scatter the pixels of a DIB */
HANDLE WINAPI DisplaceImage(HANDLE,int);

/* Flip a DIB vertically or horizontally */
HANDLE WINAPI FlipImage(HANDLE,int);

/* Invert the pixels of a DIB */
HANDLE WINAPI InvertImage(HANDLE);

/* Rotate a DIB by an arbitrary angle (with anti-aliasing) */
HANDLE WINAPI RotateImage(HANDLE,float);

/* Resize a DIB using the Windows GDI */
HANDLE WINAPI ResizeImage(HANDLE,int,int);

/* Emboss a DIB */
HANDLE WINAPI EmbossImage(HANDLE,BYTE);

/* Unimplemented */
/*HANDLE WINAPI RemoveNoise(HANDLE,int);*/

/* Normalize the pixels of a DIB */
HANDLE WINAPI NormalizeImage(HANDLE);

/* Equalize the pixels of a DIB */
HANDLE WINAPI EqualizeImage(HANDLE);

/* Resample (resize) a DIB with greater quality */
HANDLE WINAPI ResampleImage(HANDLE,int,int);

/* Detects the edges of an image */
HANDLE WINAPI DetectEdges(HANDLE);

/* Sharpen DIB */
HANDLE WINAPI SharpenImage(HANDLE,int);

/* Blur a DIB */
HANDLE WINAPI BlurImage(HANDLE,int);

/* Average a DIB */
HANDLE WINAPI AverageImage(HANDLE,int);

/* Apply a 5x5 matrix to a DIB (registered version) */
HANDLE WINAPI FilterImage(HANDLE,int,int,int*);

/* Alter brightness and contrast levels of a DIB */
HANDLE WINAPI TuneImage(HANDLE,int*,int*,int);

#endif /* __IMAGERY__ */
