Attribute VB_Name = "ImgInf"
Option Explicit

Public Type ImageInfo
    Filetype As Byte
    Width As Long
    Height As Long
    Depth As Byte
End Type

Public Const PNG As Byte = 1
Public Const GIF As Byte = 2
Public Const JPG As Byte = 3
Public Const BMP As Byte = 4
Public Const ERROR As Byte = 255


Public Function GetImageInfo(sPath As String) As ImageInfo

' This routine checks the first three bytes of a file to determine
' if it is a BMP, GIF, or PNG.  If it doesn't find a match it calls
' CheckJpg to determine if the file is a Jpeg Image.  It doesn't
' rely on file extensions, therefore LOGO.SYS and similiar
' files will show up as bitmaps as they should.
    On Error GoTo handle
    Dim iFileNum As Integer
    Dim bTemp(2) As Byte
    Dim uTemp As ImageInfo
    Dim lPointer As Long
    
    GetImageInfo.Filetype = ERROR
    
    iFileNum = FreeFile
    Open sPath For Binary As iFileNum       ' open file
    Get #iFileNum, 1, bTemp()                   ' read first three bytes
    
    If bTemp(0) = 137 And bTemp(1) = 80 And bTemp(2) = 78 Then          ' check for PNG
        uTemp = GetPng(iFileNum)
        If uTemp.Filetype <> ERROR Then GetImageInfo = uTemp
    End If
    
    If bTemp(0) = 71 And bTemp(1) = 73 And bTemp(2) = 70 Then            ' check for GIF
        uTemp = GetGif(iFileNum)
        If uTemp.Filetype <> ERROR Then GetImageInfo = uTemp
    End If
    
    If bTemp(0) = 66 And bTemp(1) = 77 Then                                          ' check for BMP
        uTemp = GetBmp(iFileNum)
        If uTemp.Filetype <> ERROR Then GetImageInfo = uTemp
    End If
    
    If GetImageInfo.Filetype = ERROR Then
        lPointer = CheckJpg(iFileNum)
        If lPointer <> -1 Then
            uTemp = GetJpg(iFileNum, lPointer)
            If uTemp.Filetype <> ERROR Then GetImageInfo = uTemp
        End If
    End If
    Close iFileNum
    
Exit Function
handle:
    GetImageInfo.Filetype = ERROR
    Close iFileNum
End Function


Private Function GetPng(iFileNum As Integer) As ImageInfo

    On Error GoTo handle
    Dim msb As Byte
    Dim lsb As Byte
    GetPng.Filetype = PNG

    Get #iFileNum, 19, msb      ' get the width
    Get #iFileNum, 20, lsb
    GetPng.Width = Mult(lsb, msb)
    
    Get #iFileNum, 23, msb      ' get the height
    Get #iFileNum, 24, lsb
    GetPng.Height = Mult(lsb, msb)
    
    Get #iFileNum, 25, msb      ' get bit depth
    Get #iFileNum, 26, lsb
    Select Case lsb
        Case 0                              ' greyscale
            GetPng.Depth = msb
            
        Case 2                              ' RGB encoded
            GetPng.Depth = msb * 3
            
        Case 3                              ' Palette based, 8 bpp
            GetPng.Depth = 8
            
        Case 4                              ' greyscale with alpha
            GetPng.Depth = msb * 2
            
        Case 6                              ' RGB encoded with alpha
            GetPng.Depth = msb * 4
            
        Case Else                           ' UhOh!
            GetPng.Filetype = ERROR
            
    End Select
    
Exit Function
handle:
    GetPng.Filetype = ERROR
End Function


Private Function GetGif(iFileNum As Integer) As ImageInfo

    On Error GoTo handle
    Dim msb As Byte
    Dim lsb As Byte
    GetGif.Filetype = GIF
    
    Get #iFileNum, 7, lsb               ' get the width
    Get #iFileNum, 8, msb
    GetGif.Width = Mult(lsb, msb)
    
    Get #iFileNum, 9, lsb               ' get the height
    Get #iFileNum, 10, msb
    GetGif.Height = Mult(lsb, msb)
    
    Get #iFileNum, 11, lsb              ' get bit depth
    GetGif.Depth = (lsb And 7) + 1
    
Exit Function
handle:
    GetGif.Filetype = ERROR
End Function


Private Function GetBmp(iFileNum As Integer) As ImageInfo

    On Error GoTo handle
    Dim msb As Byte
    Dim lsb As Byte
    GetBmp.Filetype = BMP
    
    Get #iFileNum, 19, lsb               ' get the width
    Get #iFileNum, 20, msb
    GetBmp.Width = Mult(lsb, msb)
    
    Get #iFileNum, 23, lsb               ' get the height
    Get #iFileNum, 24, msb
    GetBmp.Height = Mult(lsb, msb)
    
    Get #iFileNum, 29, lsb              ' get bit depth
    GetBmp.Depth = lsb
    
Exit Function
handle:
    GetBmp.Filetype = ERROR
End Function


Private Function CheckJpg(iFileNum As Integer) As Long

    On Error GoTo handle
    Dim FoundFlag As Byte
    Dim bbuf(3) As Byte
    Dim lPos As Long
    Dim Length As Long
    Length = LOF(iFileNum)
    
    Do While lPos < Length And FoundFlag = 0             ' Find Beginning of Jpeg Data
        lPos = lPos + 1
        Get #iFileNum, lPos, bbuf()
        If bbuf(0) = 255 And bbuf(1) = 216 And bbuf(2) = 255 Then
            FoundFlag = 1
            CheckJpg = lPos
        End If
    Loop
    If FoundFlag = 0 Then
        CheckJpg = -1                       'Not a valid Jpeg
    End If
    
Exit Function
handle:
    CheckJpg = -1
End Function


Private Function GetJpg(iFileNum As Integer, lPos As Long) As ImageInfo

    ' Extracting the information from jpeg files
    ' is much more difficult than the other file types.

    ' There are times when Do...Loop just won't work
    ' and you have to code like you did years before.
    ' This procedure demonstrates that.
    
    On Error GoTo handle
    Dim Length As Long
    Dim Byt As Byte
    Dim lsb As Byte
    Dim msb As Byte
    
    GetJpg.Filetype = JPG
    Length = LOF(iFileNum)
    lPos = lPos + 2                 'skip first marker
    
back:
    If lPos > Length Then GoTo handle
    Get #iFileNum, lPos, Byt
    If Byt = 255 Then
        lPos = lPos + 1             ' get to next marker
        GoTo back
    End If
    
    If Byt < 192 Or Byt > 195 Then      'skip uneeded markers
        Get #iFileNum, lPos + 1, msb
        Get #iFileNum, lPos + 2, lsb
        lPos = lPos + Mult(lsb, msb) + 1
        GoTo back
    End If
        
    Get #iFileNum, lPos + 4, msb        ' get the height
    Get #iFileNum, lPos + 5, lsb
    GetJpg.Height = Mult(lsb, msb)
    Get #iFileNum, lPos + 6, msb        ' get the width
    Get #iFileNum, lPos + 7, lsb
    GetJpg.Width = Mult(lsb, msb)
    Get #iFileNum, lPos + 8, lsb           ' get color depth (8 for greyscale, 24 for color)
    GetJpg.Depth = lsb * 8
    
Exit Function
handle:
    GetJpg.Filetype = ERROR
End Function


Private Function Mult(lsb As Byte, msb As Byte) As Long
    Mult = CLng(lsb + (msb * 256))
End Function

