/*
    cpic.c by bill buckels 1991
    example of a disk fragment (.PIC) loader

    written in large model microsoft C
    by Bill Buckels 1991

    assumes a C format putimage array PIC file
    also handle BASIC PUT array PIC file


*/


#include <fcntl.h>
#include <stdio.h>
#include <malloc.h>
#include <graph.h>

unsigned char far *buffer, *ptr;
#define bitsperbyte 8

int fragin(char *fragment)
{

     FILE *fp;

     int fh;
     /* center the image on the screen */
     int xorg,yorg;
     unsigned int width, height;
     unsigned int buffersize;


    if ((_bios_equiplist() & 0x30) == 0x30){
        puts("Sorry.. Color Graphics Adapter or Compatible required...");
        exit(0);
        }


     _setvideomode(5);


    fp=fopen(fragment,"rb");
    buffersize=filelength(fileno(fp));
    buffer=_fmalloc(buffersize);
    fclose(fp);

    fh = open(fragment,O_RDONLY|O_BINARY);
    read(fh,buffer,buffersize);
    close(fh);


   if (buffer[0] == (unsigned char)0xfd)
     ptr = (char *)&buffer[7];
   else
     ptr = (char *)&buffer[0];

   width=(ptr[0]|ptr[1]<<8) ;
   xorg=160-(width/4);

   if((width%bitsperbyte)!=0)
                width=(width/bitsperbyte)+1;
   else width=(width/bitsperbyte) ;
   height=(ptr[2]|ptr[3]<<8);
   yorg=100-(height/2);

   /* display in the center of the screen */
    _putimage(xorg,yorg,ptr,_GOR);

    /*==================== wait for a key press ================*/

    while(!kbhit()) ;

    _ffree(buffer);
    _setvideomode(3);
    printf("the width is %d  bytes\n",width);
    printf("the height is %d rasters\n",height);
    return 0;

}








main(int argc, char *argv[])
{
    char buffer[66];

    if(argc==2)
       fragin(argv[1]);
    else
     {
       puts("listing of PIC files in the current directory...");
       system("Dir *.pic /W");
       printf("Please Enter Choice : ");
       gets(buffer);
       if (buffer[0] != 0)
         fragin(buffer);
       }
    exit(0);

}
