@ECHO OFF
REM TGIF.BAT uses GIFGATE to test GIF Uploads
REM %1 = Full path and filename of upload (C:\RBBS\UPLOAD\FILENAME.GIF)
REM %2 = Full path and filename of RBBS error flag file
REM This batch file is for RBBS!  You will have to tailor it to suit
REM your BBS software if you run something else!

REM RELAXED mode of operation - less errorlevel exits

GIFGATE %1 /r /w640 /h480 /c256 /g /t /lc:\rbbs\node%node%\gifgate.log

REM GIFGATE ERRORLEVEL Exits

REM ERRLEVEL                           SYMBOL IN LABEL
REM  251 - Width Below Minimum           W
REM  251 - Height Below Minimum          H
REM  251 - Colors Below Minimum          C
REM  252 - GifLite'd GIF                 G

REM Even if you do not use ALL of the possible command line switches for
REM GIFGATE, it is reccommended that you leave all the ERRORLEVEL exit
REM routines in this batch file anyway.

IF ERRORLEVEL 255 GOTO UNKNOWN
IF ERRORLEVEL 254 GOTO NOTFOUND
IF ERRORLEVEL 253 GOTO BAD_LOG
IF ERRORLEVEL 252 GOTO GIFLITE
IF ERRORLEVEL 251 GOTO SPECS
IF ERRORLEVEL 250 GOTO BAD_FORMAT
IF ERRORLEVEL   0 GOTO GOOD_GIF

:UNKNOWN
proecho %node%  ~A Program Error occurred during testing!
proecho %node%  ~Please tell Sysop!~
GOTO BAD_GIF

:NOTFOUND
proecho %node% ~Sorry, your upload was not found!
proecho %node%  ~Please tell Sysop!~
GOTO BAD_GIF

:BAD_LOG
proecho %node% ~Sorry, this upload could not be logged!
proecho %node%  ~Please tell Sysop!~
GOTO BAD_GIF

:BAD_FORMAT
proecho %node%  ~The GIF you Uploaded has a BAD header or is Incomplete!~
GOTO BAD_GIF

:GIFLITE
proecho %node% ~The GIF you Uploaded has been GIFLITE'd!
proecho %node% ~This BBS does not accept GIF uploads that have been GIFLITE'd!~
GOTO BAD_GIF

:SPECS
proecho %node% ~The GIF you Uploaded is BELOW the minimum SPECS for GIF Uploads!
proecho %node% ~All GIF Uploads MUST be at least 640x480x256!~

:BAD_GIF
COPY %1 C:\RBBS\BADFILES
DEL %1
ECHO ERROR > %2
GOTO END

:GOOD_GIF
proecho %node%  ~No Errors Detected!~
IF EXIST NODE%node%\VCHK%node% DEL NODE%node%\VCHK%node%

:END
SETERROR 0
