comment 
   Ŀ
         F.O - Picture-viewer (C) 1996 Mikael Klasson aka Fluff       
   Ĵ
   									   
   	 Ok, why do I release this code??? Hmm... that's a tough one...    
    Oh well, I suppose someone can put it to use. If so, then please give 
   			     me credits for it, ok?			   
   									   
   		   If you want to contact me, then please do!		   
   	     I'm looking forward to reading your bug-reports... ;)         
   	If you want me to implement a picture-format then send it to me.   
   	 I need a 16-color PBM to see what it looks like (if it exists)    
   	     Send me a packed 16-color BMP so I can make them work.	   
   		    I would also like some unpacked ILBM's.                
   									   
   	  And.... What DO byte 8 och 9 in the colorRIX-header mean???	   
   									   
   		      Ahum... The code's a bit messy... ;)                 
   

.386p
.model flat
.stack 4096
.code

;Ŀ
;Defines
;
version         equ     'v0.61'
scrollspeed	equ	20
RASTERCHECK     equ     0

;Ŀ
;Code
;
_main:
	mov	ax,0ee02h		; EBX then contains linear address
	int	31h			; of code-segment
	mov	codeaddress,ebx 	; linear address of codeseg
	mov	buffer8kseg,ax		; this is an 8kb buffer in low memory
	add	esi,80h
	mov	dtaaddress,esi
	mov	edi,0a0000h
	sub	edi,ebx
	mov	videoptr,edi
	mov	edi,0b8000h
	sub	edi,ebx
	mov	textptr,edi

	call	_checkswitches
	jnc	switcheschecked
	mov	edx,offset usagemsg
	call	_putmsg
	jmp	_exit
switcheschecked:
	cmp	switchv,1
	je	checkmoreargs		; override vga-detection
	mov	ax,1200h
	mov	bl,31h
	int	10h
	cmp	al,12h
	je	checkmoreargs		; vgadetected is a more suitable name
	mov	edx,offset vgamsg
	call	_putmsg
	jmp	_exit
checkmoreargs:
	mov	fliorflc,0
	call	_interpretcmdline
	jnc	cmdlineok
	mov	edx,offset fileerrormsg
	call	_putmsg
	jmp	_exit
cmdlineok:
	call	_checkformat
	jnc	formatok
	inc	picerrors
	mov	picshown,1
	jmp	nextpic
formatok:
	call	_processpic
	jnc	picok
	mov	edx,offset picerrormsg
	call	_putmsg
	jmp	_exit
picok:
        mov     eax,picwidth
	mov	origpicwidth,eax
	mov	eax,picheight
	mov	origpicheight,eax
	cmp	switchx,0
	je	nowidthforcing
	mov	eax,switchx
	mov	picwidth,eax
nowidthforcing:
	cmp	switchy,0
	je	noheightforcing
	mov	eax,switchy
	mov	picheight,eax
noheightforcing:
        call    _setmode
	mov	eax,scrwidth
	mov	ebx,scrheight
	mul	ebx
	mov	scrsize,eax
	mov	eax,origpicwidth
	mov	picwidth,eax
	mov	eax,origpicheight
	mov	picheight,eax

foolmode:
	call	_setpal
putit:
	cmp	fliorflc,0
	je	notfliflc
	call	_playfliflc
	jmp	getkey
notfliflc:

IF      RASTERCHECK
        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        out     dx,al
        out     dx,al
        mov     al,63
        out     dx,al
ENDIF
	call	_putpic

IF      RASTERCHECK
        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        out     dx,al
        out     dx,al
        out     dx,al
        mov     dx,3dah
ss1:
        in      al,dx
        test    al,8
        jnz     ss1
ss2:
        in      al,dx
        test    al,8
        jz      ss2

        in      al,60h
        cmp     al,1
        jne     notfliflc
        jmp     _exit&msg
ENDIF

	cmp	switchwin,1
	je	_quit
	mov	picshown,1
getkey:
	xor	ax,ax
	int	16h
	push	ax
	mov	ax,0c00h		; clear keyb-buffer
	int	21h
	mov	ebx,scrollspeed
	mov	ah,2
	int	16h
	test	al,3
	pop	ax
	jz	notshifted
	mov	ebx,1

notshifted:
        xchg    al,ah
	cmp	al,75
	jne	notleft
	cmp	picxoffset,0
        je      putit
	sub	picxoffset,ebx
	jnc	putit
	mov	picxoffset,0
	jmp	putit
notleft:
	cmp	al,77
	jne	notright
	mov	ecx,picwidth
	sub	ecx,scrwidth
        jc      putit
	cmp	picxoffset,ecx
        je      putit
	add	picxoffset,ebx
	cmp	picxoffset,ecx
	jbe	putit
	mov	picxoffset,ecx
	jmp	putit
notright:
	cmp	al,72
	jne	notup
	cmp	picyoffset,0
        je      putit
	sub	picyoffset,ebx
	jnc	putit
	mov	picyoffset,0
	jmp	putit
notup:
	cmp	al,80
	jne	notdown
	mov	ecx,picheight
	sub	ecx,scrheight
        jc      putit
	cmp	picyoffset,ecx
        je      putit
	add	picyoffset,ebx
	cmp	picyoffset,ecx
	jbe	putit
	mov	picyoffset,ecx
	jmp	putit
notdown:
        cmp     al,74
        jne     notminus
        cmp     heightnumber,0
        je      putit
        dec     heightnumber
        mov     esi,heightnumber
        xor     eax,eax
        mov     ax,heights[esi*2]
        mov     scrheight,eax
        mov     esi,widthnumber
        xor     eax,eax
        mov     ax,widths[esi*2]
        mov     scrwidth,eax
        mov     picxoffset,0
        mov     picyoffset,0
        push    offset foolmode
        pushad
        jmp     smforcexmode
notminus:
        cmp     al,78
        jne     notplus
        mov     esi,heightnumber
        cmp     heights[esi*2+2],0
        je      putit
        inc     heightnumber
        inc     esi
        xor     eax,eax
        mov     ax,heights[esi*2]
        mov     scrheight,eax
        mov     esi,widthnumber
        xor     eax,eax
        mov     ax,widths[esi*2]
        mov     scrwidth,eax
        mov     picxoffset,0
        mov     picyoffset,0
        push    offset incyfool
        pushad
        jmp     smforcexmode
incyfool:
        mov     esi,heightnumber
        xor     eax,eax
        mov     ax,heights[esi*2]
        cmp     scrheight,eax
        je      foolmode
        dec     heightnumber
        jmp     foolmode
notplus:
        cmp     ah,'/'
        jne     notdiv
        cmp     widthnumber,0
        je      putit
        dec     widthnumber
        mov     esi,heightnumber
        xor     eax,eax
        mov     ax,heights[esi*2]
        mov     scrheight,eax
        mov     esi,widthnumber
        xor     eax,eax
        mov     ax,widths[esi*2]
        mov     scrwidth,eax
        mov     picxoffset,0
        mov     picyoffset,0
        push    offset foolmode
        pushad
        jmp     smforcexmode
notdiv:
        cmp     al,55
        jne     notmul
        mov     esi,widthnumber
        cmp     widths[esi*2+2],0
        je      putit
        inc     widthnumber
        inc     esi
        xor     eax,eax
        mov     ax,widths[esi*2]
        mov     scrwidth,eax
        mov     esi,heightnumber
        xor     eax,eax
        mov     ax,heights[esi*2]
        mov     scrheight,eax
        mov     picxoffset,0
        mov     picyoffset,0
        push    offset incxfool
        pushad
        jmp     smforcexmode
incxfool:
        mov     esi,widthnumber
        xor     eax,eax
        mov     ax,widths[esi*2]
        cmp     scrwidth,eax
        je      foolmode
        dec     widthnumber
        jmp     foolmode
notmul:
        cmp     ah,'>'
        jne     notgreater
        cmp     flispeed,0
        je      putit
        dec     flispeed
        jmp     putit
notgreater:
        cmp     ah,'<'
        jne     notless
        inc     flispeed
        jmp     putit
notless:

        cmp     al,1
	je	_exit&msg
	cmp	al,57
	jne	getkey
nextpic:
	mov	picxoffset,0
	mov	picyoffset,0
	mov	ax,0ee40h		; deallocate mem (picbuffer)
	int	31h
	mov	ax,0ee40h		; deallocate mem (filebuffer)
	int	31h
	jmp	checkmoreargs
_exit&msg:
	mov	edx,offset exitmsg
	call	_putmsg
_exit:
	cmp	vesafailed,1
	jne	_picerrors
	mov	ah,9
	mov	edx,offset vesaerrormsg
	int	21h
_picerrors:
	cmp	picerrors,0
	je	_quit
	mov	ah,9
	mov	edx,offset errormsg
	int	21h
	mov	eax,picerrors
	call	_printdec
	mov	ah,9
	mov	edx,offset notsupportmsg
	int	21h
_quit:
	mov	ah,4ch
	int	21h

;
; Initializes 80x50 textmode
; Falls back to 80x25 if VGA not present (At least I think it will... ;)
;
_set80x50:
	pushad
	mov	ax,1202h
	mov	bl,30h
	int	10h
	push	ax
	mov	ax,03h
	int	10h
	pop	ax
	cmp	switchv,1
	je	s85override
	cmp	al,12h
	jne	popad&clc&ret
s85override:
	mov	ax,1112h
	xor	bl,bl
	int	10h
	popad
	ret

;
; This routine shuffles all the pixels out onto the screen!
;
_putpic:
	pushad
	mov	esi,picbufptr
	add	esi,picxoffset
	mov	eax,picyoffset
	mov	ecx,picwidth
	mul	ecx
	add	esi,eax
	mov	edi,videoptr

	mov	ecx,picwidth
	cmp	ecx,scrwidth
	jbe	ppgnome1
	mov	ecx,scrwidth
ppgnome1:
	mov	widthtemp,ecx

	mov	eax,picheight		; check to see if we can use
	cmp	eax,scrheight		;  a fast put-routine
	jne	ppnotfast
	mov	eax,picwidth
	cmp	eax,scrwidth
	jne	ppnotfast
	cmp	vesamode,1
	je	ppvesafast
        jmp     ppnotfast               ; ppfast doesn't look good, esp.w/anims!
ppfast:
        mov     ah,00010001b            ; Perhaps it's quite unnecessary to
ppflop1:				;  have a fast version? The only time
	mov	edi,videoptr		;  you can use it is when you can't
	mov	al,02h			;  scroll the pic...
	mov	dx,3c4h 		;  Oh well, It might come in handy if
	out	dx,ax			;  I add support for animations...
        mov     ecx,scrsize             ; No way!! This sux! The reason: i plot 
        shr     ecx,4                   ;  all pixels in one plane and then all
        push    esi                     ;  in the next frame etc...
ppflop0:
	mov	al,[esi]		; ok, this is faster than just a loop
	stosb
	mov	al,[esi+4]
	stosb
	mov	al,[esi+8]
	stosb
	mov	al,[esi+12]
	stosb
	add	esi,16
	loop	ppflop0
	pop	esi
	inc	esi
        rol     ah,1
	test	ah,0eh
	jnz	ppflop1
	jmp	popad&clc&ret


ppnotfast:
	cmp	vesamode,1
	je	ppputvesa
	mov	ecx,scrheight
	cmp	ecx,picheight
	jbe	ppdontcentery		; dont center
	mov	ecx,picheight
	mov	eax,scrheight		; center picture (Y-axis)
	sub	eax,picheight
	shr	eax,1
	mov	ebx,scrwidth
	mul	ebx
	shr	eax,2			; 4 planes
	add	edi,eax
ppdontcentery:
	mov	eax,scrwidth
	cmp	eax,picwidth
	jbe	pplop0			; dont center
	sub	eax,picwidth		; center picture (X-axis)
	shr	eax,3			; 4 planes + centering
	add	edi,eax
pplop0:
	push	ecx
	mov	ah,00010001b
ppmlop1:
	mov	al,02h
	mov	dx,3c4h
	out	dx,ax
	mov	ecx,widthtemp
        shr     ecx,6
	jecxz	ppmalundone
	push	esi edi
ppmlop0:

        mov     al,[esi]
        mov     bl,[esi+16]
        mov     [edi],al
        mov     [edi+4],bl
        mov     al,[esi+4]
        mov     bl,[esi+20]
        mov     [edi+1],al
        mov     [edi+5],bl
        mov     al,[esi+8]
        mov     bl,[esi+24]
        mov     [edi+2],al
        mov     [edi+6],bl
        mov     al,[esi+12]
        mov     bl,[esi+28]
        mov     [edi+3],al
        mov     [edi+7],bl

        mov     al,[esi+32]
        mov     bl,[esi+48]
        mov     [edi+8],al
        mov     [edi+12],bl
        mov     al,[esi+36]
        mov     bl,[esi+52]
        mov     [edi+9],al
        mov     [edi+13],bl
        mov     al,[esi+40]
        mov     bl,[esi+56]
        mov     [edi+10],al
        mov     [edi+14],bl
        mov     al,[esi+44]
        mov     bl,[esi+60]
        mov     [edi+11],al
        mov     [edi+15],bl
        add     edi,16
        add     esi,64

        loop    ppmlop0
	pop	edi esi
	inc	esi
	rol	ah,1
	test	ah,0eh
	jnz	ppmlop1
	mov	ecx,widthtemp
	shr	ecx,4
	shl	ecx,2			; this IS necessary
	add	edi,ecx
	shl	ecx,2
	add	esi,ecx
	sub	esi,4

ppmalundone:
	mov	ecx,widthtemp
        and     ecx,03fh
	jecxz	ppgnullmulf1
pplop1:
	mov	al,02h
	mov	dx,3c4h
	out	dx,ax
	lodsb
	mov	[edi],al
	rol	ah,1
	test	ah,0eh
	jnz	ppnotnewedi
	inc	edi
ppnotnewedi:
	loop	pplop1
ppgnullmulf1:
	mov	ecx,scrwidth
	cmp	ecx,picwidth
	ja	ppscrmore
	je	ppdonexfixing
	sub	esi,ecx
	add	esi,picwidth
	jmp	ppdonexfixing
ppscrmore:
	sub	ecx,picwidth
	mov	ebx,ecx
	shr	ebx,2
	add	edi,ebx
	and	ecx,3
	jecxz	ppdonexfixing
pplop2:
	rol	ah,1
	test	ah,0eh
	jnz	ppnotnewedi2
	inc	edi
ppnotnewedi2:
	loop	pplop2

ppdonexfixing:
	pop	ecx
	loop	pplop0
	jmp	popad&clc&ret


ppputvesa:
	xor	ebx,ebx
	mov	vesapostemp,0
	mov	ecx,scrheight
	cmp	ecx,picheight
	jbe	ppdontcentery2		; dont center
	mov	ecx,picheight
	mov	eax,scrheight		; center picture (Y-axis)
	sub	eax,picheight
	shr	eax,1
	mov	ebx,scrwidth
	mul	ebx
	mov	ebx,eax
ppdontcentery2:
	mov	eax,scrwidth
	cmp	eax,picwidth
	jbe	ppvesa0 		; dont center
	sub	eax,picwidth		; center picture (X-axis)
	shr	eax,1
	add	ebx,eax
ppvesa0:
	mov	eax,ebx
	shr	eax,16
	mov	vesabanktemp,eax
	call	_setvesabank
	and	ebx,0ffffh
	mov	vesapostemp,ebx
	add	edi,ebx
ppvesalop0:
	push	ecx
	mov	ecx,widthtemp
	mov	ebx,vesapostemp
	add	ebx,ecx
	cmp	ebx,0ffffh
	jbe	ppvesafullrow
	sub	ebx,10000h
	sub	ecx,ebx
	rep	movsb
	inc	vesabanktemp
	mov	eax,vesabanktemp
	call	_setvesabank
	mov	edi,videoptr
	mov	vesapostemp,ebx
	mov	ecx,ebx
	rep	movsb
	jmp	ppvesarowyourboatashore
ppvesafullrow:
	add	vesapostemp,ecx
	rep	movsb
ppvesarowyourboatashore:
	mov	ecx,picwidth
	cmp	ecx,scrwidth
	je	ppvesadonerowing
	jb	ppvesaboatsinks
        sub     ecx,bytesperscanline
	add	esi,ecx
	jmp	ppvesadonerowing
ppvesaboatsinks:
        sub     ecx,bytesperscanline
	sub	edi,ecx
	sub	vesapostemp,ecx
	cmp	vesapostemp,0ffffh
	jbe	ppvesadonerowing
	inc	vesabanktemp
	mov	eax,vesabanktemp
	call	_setvesabank
	mov	edi,videoptr
	sub	vesapostemp,010000h
	add	edi,vesapostemp
ppvesadonerowing:
	pop	ecx
	loop	ppvesalop0
	jmp	popad&clc&ret


ppvesafast:				; fast version of vesa-putpic
        cmp     bytesperscanline,eax
        jne     ppputvesa
        mov     ecx,scrsize
	shr	ecx,16			; div 65536
	xor	eax,eax 		; start with bank 0
	jecxz	pponeblock
ppvesalop:
	call	_setvesabank
	pusha
	mov	ecx,65536/4
	rep	movsd
	popa
	add	esi,65536
	inc	eax
	loop	ppvesalop

pponeblock:
	call	_setvesabank
	mov	ecx,scrsize
	and	ecx,0ffffh
	rep	movsb
	jmp	popad&clc&ret

;
; Chooses vesa-bank to write to
;	In:	AX = Number of wanted 64k-block (0=first, 1=next...)
;
_setvesabank:
	pushad
	shl	eax,16			; mul 65536
	xor	edx,edx
	mov	ebx,granularity
	idiv	ebx
	mov	dx,ax
	mov	ax,4f05h
	mov	bx,0
	push	10h
	call	_int
	popad
	ret

;
; Initializes the correct palette
;
_setpal:
	pushad
	mov	dx,3c8h
	xor	al,al
	out	dx,al
	inc	dx
	mov	esi,offset pal
	mov	ecx,piccolors
	lea	ecx,[ecx*2+ecx]
	rep	outsb
	jmp	popad&clc&ret

;
; Sets the best suitable videomode
;
_setmode:
	pushad
	mov	vesamode,0			; reset vesa-flag
	mov	esi,offset widths-2
	mov	eax,picwidth
smlop:
	add	esi,2
	cmp	dword ptr [esi],0
	jne	smnotlastwidth
	sub	esi,2
	jmp	smfoundwidth
smnotlastwidth:
	cmp	ax,[esi]
	ja	smlop
smfoundwidth:
	movzx	eax,word ptr [esi]
	mov	scrwidth,eax
	sub	esi,offset widths
	shr	esi,1
	mov	widthnumber,esi

	mov	esi,offset heights-2
	mov	eax,picheight
smlop2:
	add	esi,2
	cmp	dword ptr [esi],0
	jne	smnotlastheight
	sub	esi,2
	jmp	smfoundheight
smnotlastheight:
	cmp	ax,[esi]
	ja	smlop2
smfoundheight:
	movzx	eax,word ptr [esi]
	mov	scrheight,eax
	sub	esi,offset heights
	shr	esi,1
        mov     heightnumber,esi

smforcexmode:
        mov     vesamode,0                      ; reset vesa-flag
        mov     esi,heightnumber
        mov     al,dotheightlist[esi]
	mov	ebx,widthnumber
	or	al,dotwidthlist[ebx]
	cmp	scrheight,308
	jne	smnotspec
	cmp	scrwidth,352
	jb	smnotspec
	and	al,0fh
	or	al,0a0h
smnotspec:
	cmp	scrwidth,376		; above x-mode maximums
	ja	smvesa
	cmp	scrheight,564		; above x-mode maximums
	ja	smvesa
	call	_setdotclock
	call	_xsetwidth
	mov	ebx,heightnumber
	call	_xsetheight
	jmp	popad&clc&ret
smvesa:
	mov	vesamode,1
	cmp	scrwidth,640
	ja	smvesa2
	cmp	scrheight,480
	ja	smvesa2
smset101h:				; 640x480
	mov	scrwidth,640
	mov	scrheight,480
	mov	vesaindex,0
	mov	ax,4f01h
	mov	cx,101h
	mov	bx,buffer8kseg
	mov	rm_es,bx
	xor	di,di
	push	10h
	call	_int
	movzx	ebx,buffer8kseg
	shl	ebx,4
	sub	ebx,codeaddress
	movzx	eax,word ptr [ebx+4]
	shl	eax,10			; mul 1024
	mov	granularity,eax
        movzx   eax,word ptr [ebx+16]
        mov     bytesperscanline,eax
	mov	ax,4f02h
	mov	bx,101h
	int	10h
	cmp	al,4fh
	jne	smvesaerror1
	or	ah,ah
	jz	popad&clc&ret		; everything ok
smvesaerror1:
	cmp	switchv,1
	je	popad&clc&ret		; override vesa-tests
	mov	vesafailed,1
	mov	scrwidth,376
	mov	widthnumber,xmodemaxwidthnumber
        mov     heightnumber,xmodemaxheightnumber
	mov	vesamode,0
	jmp	smforcexmode
smvesa2:
	cmp	scrwidth,800
	ja	smvesa3
	cmp	scrheight,600
	ja	smvesa3
smset103h:				; 800x600
	mov	scrwidth,800
	mov	scrheight,600
	mov	vesaindex,1
	mov	ax,4f01h
	mov	cx,103h
	mov	bx,buffer8kseg
	mov	rm_es,bx
	xor	di,di
	push	10h
	call	_int
	movzx	ebx,buffer8kseg
	shl	ebx,4
	sub	ebx,codeaddress
	movzx	eax,word ptr [ebx+4]
	shl	eax,10			; mul 1024
	mov	granularity,eax
        movzx   eax,word ptr [ebx+16]
        mov     bytesperscanline,eax
        mov     ax,4f02h
	mov	bx,103h
	int	10h
	cmp	al,4fh
	jne	smvesaerror2
	or	ah,ah
	jz	popad&clc&ret		; everything ok
smvesaerror2:
	cmp	switchv,1
	je	popad&clc&ret		; override vesa-tests
	mov	vesafailed,1
	jmp	smset101h		; try lower vesa-mode
smvesa3:
	cmp	scrwidth,1024
	ja	smvesa4
	cmp	scrheight,768
	ja	smvesa4
smset105h:				; 1024x768
	mov	scrwidth,1024
	mov	scrheight,768
	mov	vesaindex,2
	mov	ax,4f01h
	mov	cx,105h
	mov	bx,buffer8kseg
	mov	rm_es,bx
	xor	di,di
	push	10h
	call	_int
	movzx	ebx,buffer8kseg
	shl	ebx,4
	sub	ebx,codeaddress
	movzx	eax,word ptr [ebx+4]
	shl	eax,10			; mul 1024
	mov	granularity,eax
        movzx   eax,word ptr [ebx+16]
        mov     bytesperscanline,eax
        mov     ax,4f02h
	mov	bx,105h
	int	10h
	cmp	al,4fh
	jne	smvesaerror3
	or	ah,ah
	jz	popad&clc&ret		; everything ok
smvesaerror3:
	cmp	switchv,1
	je	popad&clc&ret		; override vesa-tests
	mov	vesafailed,1
	jmp	smset103h		; try lower vesa-mode
smvesa4:				; 1280x1024
	mov	scrwidth,1280
	mov	scrheight,1024
	mov	vesaindex,3
	mov	ax,4f01h
	mov	cx,107h
	mov	bx,buffer8kseg
	mov	rm_es,bx
	xor	di,di
	push	10h
	call	_int
	movzx	ebx,buffer8kseg
	shl	ebx,4
	sub	ebx,codeaddress
	movzx	eax,word ptr [ebx+4]
	shl	eax,10			; mul 1024
	mov	granularity,eax
        movzx   eax,word ptr [ebx+16]
        mov     bytesperscanline,eax
        mov     ax,4f02h
	mov	bx,107h
	int	10h
	cmp	al,4fh
	jne	smvesaerror4
	or	ah,ah
	jz	popad&clc&ret		; everything ok
smvesaerror4:
	cmp	switchv,1
	je	popad&clc&ret		; override vesa-tests
	mov	vesafailed,1
	jmp	smset105h		; try lower vesa-mode

;
; Allocates memory for picbuffer, unpacks picture (if needed) and gets
; screensizes and colordepth
;	Out:  CF = 1 if an error occured
;
_processpic:
	pushad
	mov	eax,picformat
	call	_process[eax*4]
	popad
	ret

;
; ColorRIX
;
_processcolorrix:
	pushad
	mov	esi,filebufptr
	movzx	eax,word ptr [esi+4]
	mov	picwidth,eax
	movzx	eax,word ptr [esi+6]
	mov	picheight,eax
	mov	piccolors,256
	movzx	eax,word ptr [esi+8]
	cmp	eax,00afh		; 256 colors
	je	pcr256colors
	cmp	eax,04abh		; 16 colors
	jne	popad&stc&ret
	mov	piccolors,16
pcr256colors:

	call	_allocpicmem

	add	esi,10
	cmp	piccolors,16
	je	pcr16colors
	mov	ecx,768/4		; transfer palette
	mov	edi,offset pal
	rep	movsd
	mov	edi,picbufptr
	mov	ecx,picsize
	mov	edx,ecx
	shr	ecx,2
	rep	movsd
	and	edx,03h
	jz	pcrevendw
	mov	ecx,edx
	rep	movsb
pcrevendw:
	jmp	popad&clc&ret

pcr16colors:
	mov	ecx,48/4		; transfer palette
	mov	edi,offset pal
	rep	movsd
	mov	edi,picbufptr
	mov	ecx,picsize
	shr	ecx,2
	xor	eax,eax
	rep	stosd
	mov	edi,picbufptr
	mov	ecx,picheight
pcr16lop0:
	push	ecx
	mov	bl,1
pcr16lop1:
	mov	ecx,picwidth
	shr	ecx,3
pcr16lop:
	lodsb
	test	al,080h
	jz	pcrzero1
	or	[edi],bl
pcrzero1:
	test	al,040h
	jz	pcrzero2
	or	[edi+1],bl
pcrzero2:
	test	al,020h
	jz	pcrzero3
	or	[edi+2],bl
pcrzero3:
	test	al,010h
	jz	pcrzero4
	or	[edi+3],bl
pcrzero4:
	test	al,008h
	jz	pcrzero5
	or	[edi+4],bl
pcrzero5:
	test	al,004h
	jz	pcrzero6
	or	[edi+5],bl
pcrzero6:
	test	al,002h
	jz	pcrzero7
	or	[edi+6],bl
pcrzero7:
	test	al,001h
	jz	pcrzero8
	or	[edi+7],bl
pcrzero8:
	add	edi,8
	loop	pcr16lop
	sub	edi,picwidth
	shl	bl,1
	test	bl,0fh
	jnz	pcr16lop1
	add	edi,picwidth
	pop	ecx
	loop	pcr16lop0
	jmp	popad&clc&ret

;
; FORM ILBM
;
_processformilbm:
	pushad
	call	_pfiandpfb
	jc	popad&stc&ret

	mov	edi,picbufptr		; clear buffer
	mov	ecx,picsize
	shr	ecx,2
	jecxz	pfidontclear
	xor	eax,eax
	rep	stosd
pfidontclear:

	mov	eax,'BODY'
	mov	esi,filebufptr
	call	_formsearch
	jc	popad&stc&ret

	add	esi,8-1 		; 8 for 'BODY'+length, -1 'cause we
	mov	edi,picbufptr		;  add 1 later
	add	edi,picwidth
	xor	ebp,ebp
	xor	ecx,ecx
pfisubedi:
	sub	edi,picwidth
pfiunpnext:
	inc	esi
	cmp	byte ptr [esi],-128
	je	pfiunpnext
	test	byte ptr [esi],128
	jz	pficopydirectly
	movsx	ebx,byte ptr [esi]
	neg	ebx
	inc	ebx
	inc	esi
	mov	ah,[esi]
pfilop1:
	call	_ilbmputbyte
	dec	ebx
	jnz	pfilop1
	jmp	pficommonstuff1

pficopydirectly:
	movzx	ebx,byte ptr [esi]
	inc	ebx
pfilop2:
	inc	esi
	mov	ah,[esi]
	call	_ilbmputbyte
	dec	ebx
	jnz	pfilop2
pficommonstuff1:
	cmp	ebp,picwidth
	jb	pfiunpnext
	xor	ebp,ebp
	inc	ecx
        cmp     ecx,bitplanes
	jb	pfisubedi
	xor	ecx,ecx
	mov	eax,edi
	sub	eax,picbufptr
	cmp	eax,picsize
	jb	pfiunpnext
	jmp	popad&clc&ret

;
; Used by both ILBM and PBM-routines
;	Out:	CF = 1 if error
;
_pfiandpfb:
	pushad
	mov	eax,'BMHD'                      ; get pic-properties
	mov	esi,filebufptr
	call	_formsearch
	jc	popad&stc&ret

	movzx	eax,word ptr [esi+8]
	xchg	ah,al
	mov	picwidth,eax

	movzx	eax,word ptr [esi+10]
	xchg	ah,al
	mov	picheight,eax

        xor     ecx,ecx
	mov	cl,byte ptr [esi+16]
        mov     bitplanes,ecx
	mov	eax,1
	shl	eax,cl
	mov	piccolors,eax
	cmp	eax,256 			; make sure it's 16 or 256
	je	pfbcolorsok			;  colors
	cmp	picformat,2			; exit if not 256-colors PBM
	je	pfbformerror
pfbcolorsok:

	mov	formpacked,1
	cmp	byte ptr [esi+17],01h		; mskHasMask?
	je	pfbformerror
	cmp	byte ptr [esi+18],01h		; ByteRun1?
	je	pfbpropsok
	mov	formpacked,0
	cmp	picformat,2			; PBM can be unpacked
	je	pfbpropsok
pfbformerror:
	mov	edx,offset formspecmsg
	call	_putmsg
	jmp	_exit
pfbpropsok:

	call	_allocpicmem

	mov	eax,'CMAP'                      ; read pal
	mov	esi,filebufptr
	call	_formsearch
	jc	popad&stc&ret

	add	esi,8
	mov	ecx,[esi-4]			; get pal-size
	xchg	cl,ch
	rol	ecx,16
	xchg	cl,ch
	mov	edi,offset pal
pfbpallop:
	lodsb
	shr	al,2				; convert 256 to 64
	stosb
	loop	pfbpallop
	jmp	popad&clc&ret

;
; FORM PBM
;
_processformpbm:
	pushad
	call	_pfiandpfb
	jc	popad&stc&ret

	mov	eax,'BODY'
	mov	esi,filebufptr
	call	_formsearch
	jc	popad&stc&ret

	add	esi,8
	mov	edi,picbufptr
	mov	edx,picsize

	cmp	formpacked,1
	jne	pfbunpacked

pfblop0:
	movzx	ecx,byte ptr [esi]
	inc	esi
	or	cl,cl
	js	pfbsigned

	inc	ecx
	sub	edx,ecx
	jb	popad&clc&ret
	rep	movsb
	jmp	pfblop0

pfbsigned:
	neg	cl
	inc	ecx
	sub	edx,ecx
	jb	popad&clc&ret
	lodsb
	rep	stosb
	jmp	pfblop0

pfbunpacked:
	mov	ecx,edx
	rep	movsb
	jmp	popad&clc&ret

;
; Outputs an "ILBM-byte" in AH to [EDI]
;	In:	AH = byte to output
;		EDI -> buffer to write to
;
_ilbmputbyte:
	push	eax edx
	shld	dx,ax,1
	and	dl,1
	shl	dl,cl
	or	[edi],dl

	shld	dx,ax,2
	and	dl,1
	shl	dl,cl
	or	[edi+1],dl

	shld	dx,ax,3
	and	dl,1
	shl	dl,cl
	or	[edi+2],dl

	shld	dx,ax,4
	and	dl,1
	shl	dl,cl
	or	[edi+3],dl

	shld	dx,ax,5
	and	dl,1
	shl	dl,cl
	or	[edi+4],dl

	shld	dx,ax,6
	and	dl,1
	shl	dl,cl
	or	[edi+5],dl

	shld	dx,ax,7
	and	dl,1
	shl	dl,cl
	or	[edi+6],dl

	shld	dx,ax,8
	and	dl,1
	shl	dl,cl
	or	[edi+7],dl
	add	edi,8
	add	ebp,8
	pop	edx eax
	ret

;
; Searches for a FORM-chunk.
;	In:	EAX = chunkname to search for
;		ESI -> start of FORM-file
;	Out:	ESI -> where chunk was found
;		CF = 1 if EAX not found
;
_formsearch:
	push	ebx ecx
	add	esi,8
	mov	ecx,dword ptr [esi-4]		; length of FORM-file
	xchg	cl,ch
	rol	ecx,16
	xchg	cl,ch
	add	ecx,esi
	add	esi,4				; skip "ILBM" / "PBM "
	xchg	al,ah				; bswap
	rol	eax,16
	xchg	al,ah
sagain:
	cmp	[esi],eax
	jne	snotmatching
	pop	ecx ebx
	clc
	ret
snotmatching:
	add	esi,8				; skip past chunklength
	mov	ebx,[esi-4]			; get chunklength
	xchg	bl,bh
	rol	ebx,16
	xchg	bl,bh
	test	bl,1				; chunk are ALWAYS even length
	jz	snopadding
	inc	ebx
snopadding:
	add	esi,ebx 			; skip to next chunk
	cmp	esi,ecx
	jb	sagain
	pop	ecx ebx
	stc
	ret

;
; ZSoft PCX
;
_processpcx:
	pushad
	mov	esi,filebufptr
	mov	ax,[esi+8]			; get picwidth
	sub	ax,[esi+4]
	inc	ax
	cwde
	mov	picwidth,eax

	mov	ax,[esi+10]			; get picheight
	sub	ax,[esi+6]
	inc	ax
	cwde
	mov	picheight,eax

        xor     ecx,ecx
	mov	cl,[esi+3]			; get bitplanes
        mov     bitplanes,ecx
	cmp	cl,8				; <256 colors ok
	jbe	ppcxbitplanesok
ppcxcolorerror:
	mov	edx,offset pcxcolormsg
	call	_putmsg
	jmp	_exit
ppcxbitplanesok:
	mov	ebx,1
	shl	ebx,cl

	movzx	eax,byte ptr [esi+65]
	mov	cplanes,eax
	mul	ebx
	mov	piccolors,eax
	cmp	eax,256
	ja	ppcxcolorerror
	mov	eax,cplanes
	movzx	ebx,word ptr [esi+66]
	mul	ebx
	mov	pcxtotalbytes,eax

	call	_allocpicmem

	mov	edi,picbufptr
	mov	ecx,picsize
	xor	al,al
	rep	stosb

	cmp	piccolors,256
	jb	ppcxbelow256c
	cmp	byte ptr [esi+1],5
	jne	ppcxnopal
	add	esi,filesize
	sub	esi,769
	cmp	byte ptr [esi],12		; check if valid pal-id
	jne	ppcxnopal
	inc	esi
	mov	edi,offset pal
	mov	ecx,768
ppcxpallop:
	lodsb
	shr	al,2
	stosb
	loop	ppcxpallop

ppcxnopal:
	mov	esi,filebufptr
	add	esi,128 			; skip past header
	mov	edi,picbufptr
	xor	edx,edx

ppcxnewsl:
	mov	ebp,pcxtotalbytes		; picwidth*bitplanes
	inc	edx
	cmp	edx,picheight
	ja	popad&clc&ret
ppcxsllop:
	lodsb

	cmp	al,192
	jae	ppcxdup
	stosb
	dec	ebp
	jz	ppcxnewsl
	js	ppcxnewsl
	jmp	ppcxsllop

ppcxdup:
	and	al,03fh
	movzx	ecx,al
	sub	ebp,ecx
	lodsb
	jecxz	ppcxnewsl
	rep	stosb
	or	ebp,ebp
	jz	ppcxnewsl
	js	ppcxnewsl
	jmp	ppcxsllop



ppcxbelow256c:
	cmp	byte ptr [esi+1],5
	jne	ppcxnopal2
	add	esi,10h
	mov	edi,offset pal
	mov	ecx,16*3
ppcxpallop2:
	lodsb
	shr	al,2
	stosb
	loop	ppcxpallop2

ppcxnopal2:
	mov	esi,filebufptr
	add	esi,128 			; skip past header
	mov	edi,picbufptr
	add	edi,picwidth

ppcxnewcplane:
	mov	temppcxline,0
	xor	ecx,ecx
tmpsubedi:
	mov	ebp,picwidth
	dec	ebp
	sub	edi,picwidth
tmp2:
	lodsb
	cmp	al,192
	jae	tmp1
	mov	dl,1
	shl	dl,cl
	call	_pcxputbyte
	jnc	tmp2
	inc	ecx
	cmp	ecx,cplanes
	jb	tmpsubedi
	add	edi,picwidth
	xor	ecx,ecx
	inc	temppcxline
	mov	eax,picheight
	cmp	temppcxline,eax
	jb	tmpsubedi
	jmp	popad&clc&ret

tmp1:
	and	al,03fh
	movzx	ebx,al
	lodsb
	or	ebx,ebx
	jz	tmp2
tmplop1:
	mov	dl,1
	shl	dl,cl
	jnc	tmptrynext
	mov	ebp,picwidth
	dec	ebp
	sub	edi,picwidth
	inc	ecx
	cmp	ecx,cplanes
	jb	tmptrynext
	add	edi,picwidth
	xor	ecx,ecx
	inc	temppcxline
	mov	eax,picheight
	cmp	temppcxline,eax
	jae	popad&clc&ret

tmptrynext:
	dec	ebx
	jnz	tmplop1
	jmp	tmp2

;
; Outputs a "PCX-byte" in AH to [EDI]
;	In:	AL = byte to output
;		DL = 2^(bitplane to write to)
;		EDI -> buffer to write to
;	Out:	EDI = EDI+8
;		EBP = EBP-8
;		CF = 1 if EBP < 0
;
_pcxputbyte:
	test	al,80h
	jz	no1
	or	byte ptr [edi],dl
no1:
	test	al,40h
	jz	no2
	or	byte ptr [edi+1],dl
no2:
	test	al,20h
	jz	no3
	or	byte ptr [edi+2],dl
no3:
	test	al,10h
	jz	no4
	or	byte ptr [edi+3],dl
no4:
	test	al,8h
	jz	no5
	or	byte ptr [edi+4],dl
no5:
	test	al,4h
	jz	no6
	or	byte ptr [edi+5],dl
no6:
	test	al,2h
	jz	no7
	or	byte ptr [edi+6],dl
no7:
	test	al,1h
	jz	no8
	or	byte ptr [edi+7],dl
no8:
	add	edi,8
	sub	ebp,8
	ret

;
; Windows BMP
;
_processbmp:
	pushad
	mov	esi,filebufptr
	cmp	dword ptr [esi+6],0
	jne	popad&stc&ret
	movzx	eax,word ptr [esi+18]
	mov	picwidth,eax
	movzx	eax,word ptr [esi+22]
	mov	picheight,eax
	cmp	word ptr [esi+26],1
	jne	popad&stc&ret

	call	_allocpicmem

	mov	eax,1
	mov	cx,[esi+28]
	shl	eax,cl
	mov	piccolors,eax
	cmp	eax,256
	ja	pbmpnopal
	add	esi,[esi+14]
	add	esi,14
	mov	edi,offset pal
	mov	ecx,eax
pbmppallop:
	lodsb
	shr	al,2
	mov	[edi+2],al
	lodsb
	shr	al,2
	mov	[edi+1],al
	lodsb
	shr	al,2
	stosb
	add	edi,2
	inc	esi
	loop	pbmppallop
	mov	esi,filebufptr

pbmpnopal:
	cmp	word ptr [esi+28],1
	je	pbmp2colors
	cmp	word ptr [esi+28],4
	je	pbmp16colors
	cmp	word ptr [esi+28],8
	jne	popad&stc&ret			; Do not support truecolor yet

	cmp	dword ptr [esi+30],0		; 256-color BMP
	je	pbmp256nocomp
	add	esi,[esi+10]			; compressed 256-color pic
	mov	edi,picbufptr
	add	edi,picsize
	sub	edi,picwidth
pbmp256complop:
	lodsb
	cmp	al,0
	je	pbmp256compspec
	movzx	ecx,al
	lodsb
	rep	stosb
	jmp	pbmp256complop

pbmp256compspec:
	lodsb
	cmp	al,1
	jb	pbmp256newline
	je	popad&clc&ret
	cmp	al,2
	je	pbmp256compdelta
	movzx	ecx,al
	rep	movsb
	test	al,1
	jz	pbmp256complop
	inc	esi
	jmp	pbmp256complop

pbmp256newline:
	sub	edi,picwidth
	sub	edi,picwidth
	jmp	pbmp256complop

pbmp256compdelta:
	jmp	pbmp256complop


pbmp256nocomp:
	add	esi,[esi+10]
	mov	edi,picbufptr
	add	edi,picsize
	sub	edi,picwidth
	mov	ecx,picheight
pbmp256lop0:
	push	ecx
	mov	ecx,picwidth
	mov	edx,ecx
	shr	ecx,2
	rep	movsd
	and	edx,3
	jz	pbmp256align4
	mov	ecx,edx
	rep	movsb
	add	esi,4
	sub	esi,edx
pbmp256align4:
	sub	edi,picwidth
	sub	edi,picwidth
	pop	ecx
	loop	pbmp256lop0
	jmp	popad&clc&ret


pbmp2colors:					; 2-color BMP
	mov	piccolors,2
	add	esi,[esi+10]
	mov	edi,picbufptr
	add	edi,picsize
	sub	edi,picwidth
	mov	ecx,picheight
pbmp2lop0:
	push	ecx
	mov	edx,picwidth
	shr	edx,3
pbmp2lop1:
	mov	cl,[esi]
	inc	esi
	mov	ebx,8
pbmp2lop2:
	shl	cl,1
	setb	al
	stosb
	dec	ebx
	jnz	pbmp2lop2
	dec	edx
	jnz	pbmp2lop1
	mov	ecx,picwidth
	and	ecx,7
	jecxz	pbmp2even
	mov	bl,[esi]
	inc	esi
pbmp2lop3:
	shl	bl,1
	setb	al
	stosb
	loop	pbmp2lop3
pbmp2even:
	sub	edi,picwidth
	sub	edi,picwidth
	test	picwidth,31
	jz	pbmp2align4
	mov	eax,picwidth
	and	eax,31
	inc	eax
	shr	eax,3
	add	esi,4
	sub	esi,eax
pbmp2align4:
	pop	ecx
	loop	pbmp2lop0
	jmp	popad&clc&ret


pbmp16colors:					; 16-color BMP
	mov	piccolors,16
	cmp	dword ptr [esi+30],0
	je	pbmp16nocomp
	mov	edx,offset bmp16msg		; compressed 16-color pic
	call	_putmsg 			; PLEASE send me one!!!
	jmp	_exit

pbmp16nocomp:
	add	esi,[esi+10]
	mov	edi,picbufptr
	add	edi,picsize
	sub	edi,picwidth
	mov	ecx,picheight
pbmp16lop0:
	push	ecx
	mov	ecx,picwidth
	shr	ecx,1
pbmp16lop1:
	lodsb
	mov	bl,al
	shr	al,4
	stosb
	mov	al,bl
	and	al,0fh
	stosb
	loop	pbmp16lop1
	test	picwidth,1
	jz	pbmp16even
	lodsb
	mov	bl,al
	shr	al,4
	stosb
pbmp16even:
	sub	edi,picwidth
	sub	edi,picwidth
	test	picwidth,7
	jz	pbmp16align4
	mov	eax,picwidth
	and	eax,7
	inc	eax
	shr	eax,1
	add	esi,4
	sub	esi,eax
pbmp16align4:
	pop	ecx
	loop	pbmp16lop0
	jmp	popad&clc&ret

;
; AutoDesk FLI/FLC
;
_processfliflc:
        pushad
	mov	fliorflc,1
	mov	esi,filebufptr
	xor	eax,eax
	mov	ax,[esi+6]			; get # frames
	mov	totframes,eax
	mov	ax,[esi+8]
	mov	picwidth,eax
	mov	ax,[esi+10]
	mov	picheight,eax
        mov     ax,[esi+16]
        mov     flispeed,eax
        mov     piccolors,256
	call	_allocpicmem
        popad
	ret

;
; Plays a fli/flc file previously loaded to mem
;
_playfliflc:
	pushad
pffplayfromfirstframe:
	mov	esi,filebufptr
	add	esi,128 		; skip header
	mov	currentframe,0
pffnextframe:
	mov	ah,01h
	int	16h
	jnz	pffend			; some key was pressed
	mov	edi,picbufptr
	mov	eax,currentframe
	cmp	eax,totframes
	jae	pffplayfromfirstframe
	mov	ebp,[esi]		; bytes in frame
	cmp	word ptr [esi+4],0f1fah ; verify magic number
	jne	pffend
	xor	edx,edx
	mov	dx,[esi+6]		; # chunks
	add	esi,16			; skip past frameheader
pffmorechunks:
        push    edx
	push	esi
	lodsd
	push	eax			; # bytes in chunk
	lodsw
	cmp	ax,11
	jne	pffnotFLI_COLOR
        lodsw
        xor     ebp,ebp
        mov     bp,ax                   ; # packets
        xor     ebx,ebx                 ; current colorindex
 pffFLI_COLORpacketlop:
        lodsb
        add     bl,al
        xor     eax,eax
        lodsb
        cmp     al,0
        jne     pffFLI_COLORnotzero
        mov     eax,256
 pffFLI_COLORnotzero:
        lea     ecx,[eax*2+eax]
        mov     dx,3c8h
        mov     al,bl
        out     dx,al
        inc     dx
        rep     outsb
        dec     ebp
        jnz     pffFLI_COLORpacketlop
	jmp	pffchunkdone
pffnotFLI_COLOR:
	cmp	ax,12
	jne	pffnotFLI_LC
        xor     eax,eax
        lodsw                           ; # lines to skip
        mul     picwidth
        add     edi,eax
        xor     eax,eax
        lodsw
        mov     ebp,eax                 ; # lines that do change
 pffFLI_LClinelop:
        push    edi
        xor     eax,eax
        lodsb
        mov     edx,eax
        or      eax,eax
        jz      pffFLI_LClinedone
 pffFLI_LCpacketlop:
        xor     eax,eax
        lodsb                           ; read skip_count
        add     edi,eax
        xor     eax,eax
        lodsb
        test    al,80h
        jz      pffFLI_LCpositive
        neg     al
        mov     ecx,eax
        lodsb
        rep     stosb
        jmp     pffFLI_LCpacketdone
 pffFLI_LCpositive:
        mov     ecx,eax
        rep     movsb
 pffFLI_LCpacketdone:
        dec     edx
        jnz     pffFLI_LCpacketlop
 pffFLI_LClinedone:
        pop     edi
        add     edi,picwidth
        dec     ebp
        jnz     pffFLI_LClinelop
	jmp	pffchunkdone
pffnotFLI_LC:
	cmp	ax,13
	jne	pffnotFLI_BLACK
	jmp	pffchunkdone
pffnotFLI_BLACK:
	cmp	ax,15
	jne	pffnotFLI_BRUN
	mov	ecx,picheight
 pffFLI_BRUNlinelop:
	push	ecx
	lodsb
	xor	edx,edx
	mov	dl,al			; # packets in this line
 pffFLI_BRUNpacketlop:
	lodsb
	test	al,80h
	jnz	pffFLI_BRUNnegative
	xor	ecx,ecx
	mov	cl,al
	lodsb
	rep	stosb
	jmp	pffFLI_BRUNpacketdone
 pffFLI_BRUNnegative:
	neg	al
	xor	ecx,ecx
	mov	cl,al
	rep	movsb
 pffFLI_BRUNpacketdone:
	dec	edx
	jnz	pffFLI_BRUNpacketlop
	pop	ecx
	dec	ecx
	jnz	pffFLI_BRUNlinelop
	jmp	pffchunkdone
pffnotFLI_BRUN:
	cmp	ax,16
	jne	pffnotFLI_COPY

	jmp	pffchunkdone
pffnotFLI_COPY:
	cmp	ax,4
	jne	pffnotFLI_256_COLOR
	lodsw
	xor	ebp,ebp
	mov	bp,ax			; tot # packets
	xor	ebx,ebx 		; current colorindex
 pffFLI_256_COLOR_lop:
	lodsb
	add	bl,al			; skip X colors
	xor	eax,eax
	lodsb
	cmp	al,0
	jne	pffnot0
	mov	eax,256
 pffnot0:
	lea	ecx,[eax*2+eax]
	mov	dx,3c8h
	mov	al,bl
	out	dx,al
	inc	edx
 pff256lop:
	lodsb
	shr	al,2
	out	dx,al
	dec	ecx
	jnz	pff256lop
	dec	ebp
	jnz	pffFLI_256_COLOR_lop
	jmp	pffchunkdone
pffnotFLI_256_COLOR:
	cmp	ax,7
	jne	pffnotFLI_DELTA
	lodsw
	xor	ebp,ebp
	mov	bp,ax			; # compressed lines to follow
 pffFLI_DELTAlinelop:
	push	edi
	lodsw
	mov	dx,ax
	test	ax,8000h
	jz	pffFLI_DELTAdontskiplines
	neg	ax
	cwde
	mul	picwidth
	pop	edi
	add	edi,eax 		; add eax to pushed edi
	jmp	pffFLI_DELTAlinelop
 pffFLI_DELTAdontskiplines:
	xor	eax,eax
	lodsb
	add	edi,eax
	lodsb
	test	al,80h
	jz	pffFLI_DELTApositive
	neg	al
	mov	ecx,eax
	lodsw
	rep	stosw
	jmp	pffFLI_DELTApacketdone
 pffFLI_DELTApositive:
	mov	ecx,eax
	rep	movsw
 pffFLI_DELTApacketdone:
	dec	dx
	jnz	pffFLI_DELTAdontskiplines
 pffFLI_DELTAlinedone:
	pop	edi
	add	edi,picwidth
	dec	ebp			; decrease lines left
	jnz	pffFLI_DELTAlinelop
	jmp	pffchunkdone
pffnotFLI_DELTA:
pffchunkdone:
	pop	ecx esi
	add	esi,ecx
	pop	edx
	dec	edx
	jnz	pffmorechunks
	inc	currentframe
        mov     ecx,flispeed
        jecxz   dontloop
        mov     dx,3dah
s1:
	in	al,dx
	test	al,8
	jnz	s1
s2:
	in	al,dx
	test	al,8
	jz	s2
        loop    s1
dontloop:
	call	_putpic
        jmp     pffnextframe
pffend:
	popad
	ret

;
; Allocates memory for pic-buffer and stores variables
;
_allocpicmem:
	pushad
	mov	eax,picwidth
	mov	ebx,picheight
	mul	ebx
	mov	picsize,eax
	mov	edx,eax
	mov	ax,0ee42h
	int	31h
	jnc	apmmemok
	mov	edx,offset memerrormsg
	call	_putmsg
	jmp	_exit
apmmemok:
	mov	picbufptr,edx
	jmp	popad&clc&ret

;
; ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ
;
_gnu:
	xor	ax,ax
	int	16h
	jmp	_exit

;
; Determines what pic-format the file is
;	Out:	CF = 1 if format not recognized
;
_checkformat:
	pushad
	mov	esi,filebufptr
	cmp	dword ptr [esi],'3XIR'          ; ColorRIX
	jne	cfnotcolorrix
	mov	picformat,0
	jmp	popad&clc&ret

cfnotcolorrix:
	cmp	dword ptr [esi],'MROF'          ; FORM
	jne	cfnotform
	cmp	dword ptr [esi+8],'MBLI'        ; FORM ILBM
	jne	cfnotformilbm
	mov	picformat,1
	jmp	popad&clc&ret
cfnotformilbm:
	cmp	dword ptr [esi+8],' MBP'        ; FORM PBM
	jne	cfnotformpbm
	mov	picformat,2
	jmp	popad&clc&ret
cfnotformpbm:
	mov	edx,offset formmsg
	call	_putmsg
	jmp	_exit

cfnotform:
	cmp	byte ptr [esi],10		; ZSoft PCX
	jne	cfnotpcx
	mov	picformat,3
	jmp	popad&clc&ret

cfnotpcx:
	cmp	word ptr [esi],'MB'             ; Windows BMP
	jne	cfnotbmp
	mov	picformat,4
	jmp	popad&clc&ret

cfnotbmp:
        cmp     word ptr [esi+4],0af11h         ; FLI/FLC
	jb	cfnotfliflc
	cmp	word ptr [esi+4],0af12h
	ja	cfnotfliflc
        mov     picformat,5
	jmp	popad&clc&ret
cfnotfliflc:

	jmp	popad&stc&ret		; Pic-format not recognized

;
; Checks what switches (if any) are given
;	Out:	CF = 1 if error
;
_checkswitches:
	pushad
	mov	ax,0ee02h
	int	31h
	add	esi,81h
	movzx	ecx,byte ptr [esi-1]
	cmp	ecx,1
	jbe	popad&stc&ret		; too short cmdline
	push	ecx esi
	add	ecx,2			; first space and last CR too
	mov	cmdlength,ecx
	mov	edi,offset cmdline
	rep	movsb
	pop	esi ecx
	mov	edi,esi
	add	esi,ecx
	mov	al,' '
	repne	scasb
csnextswitch:
	mov	eax,dword ptr [edi]
	or	eax,020202020h		; only lower-case
	cmp	eax,'niw/'
	je	csswitchwin
	cmp	eax,'niw-'
	jne	csnotswitchwin
csswitchwin:
	mov	switchwin,1
	jmp	csgnu
csnotswitchwin:
	mov	ax,word ptr [edi]
	or	ax,02020h
	cmp	ax,'v-'
	je	csswitchv
	cmp	ax,'v/'
	jne	csnotswitchv
csswitchv:
	mov	switchv,1
	jmp	csgnu

csnotswitchv:
	mov	ax,word ptr [edi]
	or	ax,02020h
	cmp	ax,'x-'
	je	csswitchx
	cmp	ax,'x/'
	jne	csnotswitchx
csswitchx:
	mov	eax,dword ptr [edi+2]
	call	_ascii2dec
	mov	switchx,eax
	jmp	csgnu

csnotswitchx:
	mov	ax,word ptr [edi]
	or	ax,02020h
	cmp	ax,'y-'
	je	csswitchy
	cmp	ax,'y/'
	jne	csnotswitchy
csswitchy:
	mov	eax,dword ptr [edi+2]
	call	_ascii2dec
	mov	switchy,eax
	jmp	csgnu

csnotswitchy:

csgnu:
	mov	al,' '
	mov	ecx,0ffffh
	repne	scasb
	cmp	edi,esi
	jb	csnextswitch
	jmp	popad&clc&ret

;
; Converts an ascii string representing a decimal number to a decimal value
;	In:	EAX = string
;	Out:	EAX = Number
;
_ascii2dec:
	push	ebx ecx
	xor	ebx,ebx
a2dlop:
	sub	al,48			; oh well, '37g6' will be '376'
	jc	a2dnodigit		;  but so what? I think that's what
	cmp	al,9			;  it was meant to be anyway...
	ja	a2dnodigit
	shl	ebx,8
	mov	bl,al
a2dnodigit:
	shr	eax,8
	jnz	a2dlop
	xchg	eax,ebx
	aad
	movzx	ebx,al
	shr	eax,16
	aad
	mov	ecx,100
	mul	ecx
	add	eax,ebx
	pop	ecx ebx
	ret

;
; Checks if a valid filename is given and allocates memory
;	Out:  CF = 1 if file-error
;
_interpretcmdline:
	pushad
icswitchfound:
	mov	edi,offset cmdline
	mov	al,' '
	repne	scasb

	mov	ecx,argnumber
	jecxz	icarg0
icalop:
	push	ecx
	mov	al,' '
	mov	ecx,0ffffh
	repe	scasb			; we don't want any spaces...
	repne	scasb
	pop	ecx
	loop	icalop

icarg0:
	cmp	byte ptr [edi],'/'
	je	icswitch
	cmp	byte ptr [edi],'-'
	jne	icnotswitch
icswitch:
	inc	argnumber
	jmp	icswitchfound
icnotswitch:
	mov	esi,edi
	mov	edi,offset filename
iclop:
	lodsb
	cmp	al,13
	je	icdone
	cmp	al,0			; NC is strange...
	je	icdone
	cmp	al,' '                  ; several args...
	je	icdone
	push	esi
	sub	esi,offset cmdline
	cmp	esi,cmdlength
	pop	esi
	ja	icbeyondcmdline
	stosb
	jmp	iclop
icbeyondcmdline:
	cmp	picshown,0
	jne	_exit&msg
	mov	edx,offset usagemsg
	call	_putmsg
	jmp	_exit
icdone:
	xor	al,al
	stosb

	cmp	findingnext,1
	jne	icfindfirst
	mov	ah,4fh
	int	21h
	jnc	icfoundfile
	inc	argnumber
	mov	findingnext,0
	jmp	icswitchfound		; misfitting name really...

icfindfirst:
	mov	ah,4eh
	mov	cx,00027h		; all entrys except volumes&dirs
	mov	edx,offset filename
	int	21h
	jnc	icfoundfile
	inc	argnumber
	jmp	icswitchfound		; still misfitting...

icfoundfile:
	mov	findingnext,1
	mov	esi,dtaaddress
	add	esi,1eh 		; filename-pos in dta
	mov	edi,offset filename
	xor	al,al
	mov	ecx,-1
	repne	scasb
notdiryet:
	dec	edi
	cmp	edi,offset filename
	jbe	copyname
	cmp	byte ptr [edi-1],'\'
	jne	notdiryet
copyname:
	lodsb
	stosb
	or	al,al
	jnz	copyname
nodir:
	mov	edx,offset filename
	mov	ax,3d00h
	int	21h
	jnc	icfileopened
	mov	edx,offset fileerrormsg
	call	_putmsg
	jmp	_exit
icfileopened:
	mov	filehandle,ax
	xchg	ax,bx
	xor	edx,edx
	mov	ax,4202h
	int	21h
	jc	popad&stc&ret
	cmp	eax,0
	jne	icnotzerobyte
	mov	edx,offset notsupportmsg
	call	_putmsg
	jmp	_exit
icnotzerobyte:
	mov	filesize,eax
	mov	edx,eax
	mov	ax,0ee42h
	int	31h
	jnc	icmemallocated
	mov	edx,offset memerrormsg
	call	_putmsg
	jmp	_exit
icmemallocated:
	mov	filebufptr,edx
	mov	ax,4200h
	mov	bx,filehandle
	xor	edx,edx
	int	21h
	jc	popad&stc&ret
	mov	ah,3fh
	mov	bx,filehandle
	mov	ecx,filesize
	mov	edx,filebufptr
	int	21h
	jc	popad&stc&ret
	mov	ah,3eh			; close the file
	int	21h
popad&clc&ret:
	popad
	clc
	ret

popad&stc&ret:
	popad
	stc
	ret

;
; Sets 80x50 and puts initmsg
;
_putinitmsg:
	pushad
	call	_set80x50
	mov	edi,textptr
	mov	ecx,80*3
	mov	ax,1e20h
	rep	stosw			; put attributes (and spaces)
	mov	ah,9
	mov	edx,offset initmsg
	int	21h
	popad
	ret

;
; Puts a msg preceed by the init-msg
;	In:	EDX -> msg to print
;
_putmsg:
	pushad
	call	_putinitmsg
	mov	ah,9
	int	21h
	popad
	ret

;
; Temporary, just part of my testing... Awesome optimizing! ;)
;	In:	EBX = number
;
_print:
	pushad
	mov	eax,ebx
	and	al,0fh
	add	al,90h
	daa
	adc	al,40h
	daa
	int	29h
	shr	ebx,4
	mov	eax,ebx
	and	al,0fh
	add	al,90h
	daa
	adc	al,40h
	daa
	int	29h
	shr	ebx,4
	mov	eax,ebx
	and	al,0fh
	add	al,90h
	daa
	adc	al,40h
	daa
	int	29h
	shr	ebx,4
	mov	eax,ebx
	and	al,0fh
	add	al,90h
	daa
	adc	al,40h
	daa
	int	29h
	shr	ebx,4
	mov	eax,ebx
	and	al,0fh
	add	al,90h
	daa
	adc	al,40h
	daa
	int	29h
	shr	ebx,4
	mov	eax,ebx
	and	al,0fh
	add	al,90h
	daa
	adc	al,40h
	daa
	int	29h
	shr	ebx,4
	mov	eax,ebx
	and	al,0fh
	add	al,90h
	daa
	adc	al,40h
	daa
	int	29h
	shr	ebx,4
	mov	eax,ebx
	and	al,0fh
	add	al,90h
	daa
	adc	al,40h
	daa
	int	29h

	mov	al,10
	int	29h
	mov	al,13
	int	29h
	popad
	ret

;
; Prints a decimal number
; In:	EAX  =	Decimal number to print
;
_printdec:
	pushad
	mov	edx,1000000000
	mov	esi,9*4
	xor	ebp,ebp
__printdecloop0:
	xor	ebx,ebx
__printdecloop1:
	inc	ebx
	sub	eax,edx
	jnc	__printdecloop1

	add	eax,edx
	dec	ebx
	jnz	__printdecwrite
	cmp	ebp,1
	jne	__printdecdivedx

__printdecwrite:
	push	eax
	mov	al,bl
	add	al,48
	int	29h
	pop	eax
	mov	ebp,1

__printdecdivedx:
	sub	esi,1*4
	js	popad&clc&ret
	mov	edx,printdeclimits[esi]
	jmp	__printdecloop0

;
; Selects dot clock and Horiz scanning rate (parts from M. Abrash code)
;	In:	AL = value to output to 3c2h
;
_setdotclock:
	pushad
	push	ax
	mov	ax,13h			; let the BIOS set standard 256-color
	int	10h			;  mode (320x200 linear)

	mov	dx,3c4h
	mov	ax,0604h
	out	dx,ax			; disable chain4 mode
	mov	ax,0100h
	out	dx,ax			; synchronous reset while setting Misc
					;  Output for safety, even though clock
					;  unchanged
	pop	ax
	mov	dx,3c2h
	out	dx,al

	add	dl,2
	mov	ax,0300h
	out	dx,ax			; undo reset (restart sequencer)

	mov	dx,3d4h 		; reprogram the CRT Controller
	mov	al,11h			; VSync End reg contains register write
	out	dx,al			;  protect bit
	inc	dx			; CRT Controller Data register
	in	al,dx			; get current VSync End register setting
	and	al,07fh 		; remove write protect on various
	out	dx,al			; CRTC registers
	popad
	ret

;
; Set x-mode width
;	In:	EBX = Width-index in list
;
_xsetwidth:
	pushad
	mov	esi,WidthTable[ebx*4]
	mov	dx,3d4h 		; CRT Controller Index
	xor	ecx,ecx
	lodsb
	mov	cl,al
	rep	outsw

	mov	dl,0c4h 		; for 128, 160 and 184-widths
	lodsw				;  from code by Type One - TFL/TDV Prod.
	mov	bh,ah
	out	dx,al
	inc	dx
	in	al,dx
	and	al,037h
	or	al,bh
	out	dx,al

	popad
	ret

;
; Set x-mode height
;	In:	EBX = Height-index in list
;
_xsetheight:
	pushad
	mov	esi,HeightTable[ebx*4]
	mov	dx,3d4h 		; CRT Controller Index
	xor	ecx,ecx
	lodsb
	mov	cl,al
	rep	outsw

	mov	ecx,8000h		; clear all videomem
	mov	edi,videoptr
	xor	ax,ax
	rep	stosw
	popad
	ret

;
; Call realmode interrupt (based on code by Adam Seychell)
;	In:	pushed dword = interrupt-number
;
_int:
	push	rmstackptr		; push realmode stackptr
	lea	esp,[esp - 8]		; ignore  CS, IP ,FS, GS
	push	rmdsandes
	pushfw
	pushad
	mov	edi,esp
	mov	ax,0300h
	xor	ecx,ecx
	movzx	ebx,byte ptr [esp+36h]	; load interruptnumber
	int	31h
	popad
	popfw
	pop	rmdsandes		; pop modified realmode DS and ES
	lea	esp,[esp+12]		; ignore SS,SP,CS,IP,FS,GS
	ret	4			; pop away parameter

;Ŀ
;Data
;
Y40     label   word
        db      10      ; number of regs to update
	dw	00d06h	; vertical total
	dw	03e07h	; overflow (bit 8 of vertical counts)
        dw      04b09h  ; cell height (2 to double-scan)
	dw	0ea10h	; v sync start
	dw	0ac11h	; v sync end and protect cr0-cr7
	dw	0df12h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	0e715h	; v blank start
	dw	00616h	; v blank end
	dw	0e317h	; turn on byte mode

Y80     label   word
        db      10      ; number of regs to update
	dw	00d06h	; vertical total
	dw	03e07h	; overflow (bit 8 of vertical counts)
        dw      04509h  ; cell height (2 to double-scan)
	dw	0ea10h	; v sync start
	dw	0ac11h	; v sync end and protect cr0-cr7
	dw	0df12h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	0e715h	; v blank start
	dw	00616h	; v blank end
	dw	0e317h	; turn on byte mode

Y120    label   word
        db      10      ; number of regs to update
	dw	00d06h	; vertical total
	dw	03e07h	; overflow (bit 8 of vertical counts)
        dw      04309h  ; cell height (2 to double-scan)
	dw	0ea10h	; v sync start
	dw	0ac11h	; v sync end and protect cr0-cr7
	dw	0df12h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	0e715h	; v blank start
	dw	00616h	; v blank end
	dw	0e317h	; turn on byte mode

Y160    label   word
        db      10      ; number of regs to update
	dw	00d06h	; vertical total
	dw	03e07h	; overflow (bit 8 of vertical counts)
        dw      04209h  ; cell height (2 to double-scan)
	dw	0ea10h	; v sync start
	dw	0ac11h	; v sync end and protect cr0-cr7
	dw	0df12h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	0e715h	; v blank start
	dw	00616h	; v blank end
	dw	0e317h	; turn on byte mode

Y200    label   word
	db	2	; number of regs to update
	dw	00014h	; turn off dword mode
	dw	0e317h	; turn on byte mode

Y240	label	word
	db	10	; number of regs to update
	dw	00d06h	; vertical total
	dw	03e07h	; overflow (bit 8 of vertical counts)
	dw	04109h	; cell height (2 to double-scan)
	dw	0ea10h	; v sync start
	dw	0ac11h	; v sync end and protect cr0-cr7
	dw	0df12h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	0e715h	; v blank start
	dw	00616h	; v blank end
	dw	0e317h	; turn on byte mode

Y256	label	word	; actually its only Y255.5
	db	8
	dw	02006h	; vertical total
	dw	03e07h	; overflow (bit 8 of vertical counts)
	dw	0ff10h	; v sync start
	dw	0fe12h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	0ff15h	; v blank start
	dw	01016h	; v blank end
	dw	0e317h	; turn on byte mode

Y282	label	word
	db	11	; number of regs to update
	dw	06206h	; vertical total
	dw	0f007h	; overflow
	dw	06109h	; cell height
	dw	0310fh	;
	dw	03710h	; v sync start
	dw	08911h	; v sync end and protect cr0-cr7
	dw	03312h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	03415h	; v blank start ; 3c
	dw	05c16h	; v blank end
	dw	0e317h	; turn on byte mode

Y308	label	word
	db	11	; number of regs to update
	dw	06206h	; vertical total
	dw	00f07h	; overflow
	dw	04009h	; cell height
	dw	0310fh	;
	dw	03710h	; v sync start
	dw	08911h	; v sync end and protect cr0-cr7
	dw	03312h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	03415h	; v blank start
	dw	05c16h	; v blank end
	dw	0e317h	; turn on byte mode

Y350	label	word
	db	10
	dw	0BF06h	; vertical total
	dw	01F07h	; overflow
	dw	04009h	; cell height
	dw	08310h	; v sync start
	dw	08511h	; v sync end and protect cr0-cr7
	dw	05D12h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	06315h	; v blank start
	dw	0BA16h	; v blank end
	dw	0e317h	; turn on byte mode

Y360	label	word
	db	8	; number of regs to update
	dw	04009h	; cell height
	dw	08810h	; v sync start
	dw	08511h	; v sync end and protect cr0-cr7
	dw	06712h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	06d15h	; v blank start
	dw	0ba16h	; v blank end
	dw	0e317h	; turn on byte mode

Y400	label	word
	db	3	; number of regs to update
	dw	04009h	; cell height
	dw	00014h	; turn off dword mode
	dw	0e317h	; turn on byte mode

Y480	label	word
	db	10	; number of regs to update
	dw	00d06h	; vertical total
	dw	03e07h	; overflow (bit 8 of vertical counts)
	dw	04009h	; cell height (2 to double-scan)
	dw	0ea10h	; v sync start
	dw	0ac11h	; v sync end and protect cr0-cr7
	dw	0df12h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	0e715h	; v blank start
	dw	00616h	; v blank end
	dw	0e317h	; turn on byte mode

Y512	label	word
	db	9
	dw	02006h	; vertical total
	dw	03e07h	; overflow (bit 8 of vertical counts)
	dw	04009h	; cell height (2 to double-scan)
	dw	0ff10h	; v sync start
	dw	0fe12h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	0ff15h	; v blank start
	dw	01016h	; v blank end
	dw	0e317h	; turn on byte mode

Y540	label	word
	db	10
	dw	04A06h	; vertical total
	dw	0F007h	; overflow (bit 8 of vertical counts)
	dw	06009h	; cell height (2 to double-scan)
	dw	02410h	; v sync start
	dw	08611h	; v sync end and protect cr0-cr7
	dw	01B12h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	02415h	; v blank start
	dw	04416h	; v blank end
	dw	0e317h	; turn on byte mode

Y564	label	word
	db	11	; number of regs to update
	dw	06206h	; vertical total
	dw	0f007h	; overflow
	dw	06009h	;
	dw	0310fh	;
	dw	03710h	; v sync start
	dw	08911h	; v sync end and protect cr0-cr7
	dw	03312h	; vertical displayed
	dw	00014h	; turn off dword mode
	dw	03415h	; v blank start
	dw	05c16h	; v blank end
	dw	0e317h	; turn on byte mode

X128	label	word
	db	7
	dw	02d00h	; horiz. total
	dw	01f01h	; horiz. disp. enable end
	dw	02002h	; horiz. blank start
	dw	09003h	; horiz. blank end
	dw	02504h	; horiz. retrace start
	dw	08d05h	; horiz. retrace end
	dw	01013h	; offset/logical width
	dw	00801h	; clock mode register (3c4h)

X160	label	word
	db	7
	dw	02d00h	; horiz. total
	dw	02701h	; horiz. disp. enable end
	dw	02802h	; horiz. blank start
	dw	09003h	; horiz. blank end
	dw	02b04h	; horiz. retrace start
	dw	08005h	; horiz. retrace start
	dw	01413h	; offset/logical width
	dw	00801h	; clock mode register (3c4h)

X184	label	word
	db	7
	dw	03200h	; horiz. total
	dw	02c01h	; horiz. disp. enable end
	dw	02d02h	; horiz. blank start
	dw	0b003h	; horiz. blank end
	dw	02f04h	; horiz. retrace start
	dw	0b405h	; horiz. retrace end
	dw	01713h	; offset/logical width
	dw	00801h	; clock mode register (3c4h)

X256	label	word
	db	7	; number of regs to update
	dw	05f00h	; horz total
	dw	03f01h	; horz displayed
	dw	04202h	; start horz blanking
	dw	09f03h	; end horz blanking
	dw	04c04h	; start h sync
	dw	00005h	; end h sync
	dw	02013h	; offset
	dw	00001h	; clock mode register (3c4h)

X320	label	word
	db	0	; number of regs to update

X352	label	word
	db	7	; number of regs to update
	dw	06800h	; horz total
	dw	05701h	; horz displayed
	dw	05802h	; start horz blanking
	dw	08B03h	; end horz blanking
	dw	05904h	; start h sync
	dw	08605h	; end h sync
	dw	02c13h	; offset
	dw	00001h	; clock mode register (3c4h)

X360	label	word
	db	7	; number of regs to update
	dw	06b00h	; horz total
	dw	05901h	; horz displayed
	dw	05a02h	; start horz blanking
	dw	08e03h	; end horz blanking
	dw	05e04h	; start h sync
	dw	08a05h	; end h sync
	dw	02d13h	; offset
	dw	00001h	; clock mode register (3c4h)

X368	label	word
	db	7
	dw	06C00h	; horz total
	dw	05B01h	; horz displayed
	dw	05C02h	; start horz blanking
	dw	08F03h	; end horz blanking
	dw	05F04h	; start h sync
	dw	08C05h	; end h sync
	dw	02E13h	; offset
	dw	00001h	; clock mode register (3c4h)


X376	label	word
	db	7	; number of regs to update
	dw	06e00h	; horz total
	dw	05d01h	; horz displayed
	dw	05e02h	; start horz blanking
	dw	09103h	; end horz blanking
	dw	06204h	; start h sync
	dw	08f05h	; end h sync
	dw	02f13h	; offset
	dw	00001h	; clock mode register (3c4h)

WidthTable      label   dword
	dd	offset X128, offset X160, offset X184, offset X256
	dd	offset X320, offset X352, offset X360, offset X368
	dd	offset X376

HeightTable	label	dword
        dd      offset Y40,  offset Y80,  offset Y120, offset Y160
	dd	offset Y200, offset Y240, offset Y256, offset Y282
	dd	offset Y308, offset Y350, offset Y360, offset Y400
	dd	offset Y480, offset Y512, offset Y540, offset Y564

dotwidthlist	db	 03h, 03h, 07h, 03h, 03h, 07h, 07h, 07h, 07h
dotheightlist   db      0e0h,0e0h,0e0h,0e0h,060h,0e0h,060h,0e0h,060h,060h,060h,060h,0e0h,060h,0e0h,0e0h

widths		label	word		; widths of supported modes
		dw	128,160,184,256,320,352,360,368,376	    ; x-modes
xmodemaxwidthnumber	equ	($-widths)/2-1		; used when forcing VGA
		dw	640,800,1024,1280		; VESA
		dd	0		; end of list

heights         dw      40,80,120,160,200,240,256,282,308,350,360,400,480,512,540,564 ; x-modes
xmodemaxheightnumber	equ	($-heights)/2-1 	; used when forcing VGA
		dw	600,768,1024				    ; VESA
                dd      0               ; end of list

initmsg         db      '  F.O ',version,' - A Viewer for Graphix (C) 1996 Mikael Klasson aka Fluff Ϳ '
                db      '     fluff@geocities.com    http://www.geocities.com/SiliconValley/3642     '
		db	'  Running under DOS32 v3.3 by Adam Seychell  ',13,10
		db	'       Formats: ColorRIX       (.SCX)  16 and 256 colors',13,10
		db	'                IFF/ILBM       (.LBM)  up to 256 colors',13,10
		db	'                IFF/PBM        (.LBM)  256 colors',13,10
		db	'                Windows BMP    (.BMP)  up to 256 colors',13,10
		db	'                ZSoft PCX      (.PCX)  up to 256 colors',13,10
		db	'                FLI / FLC      (.FL?)  256 colors',13,10,10
		db	'       Widths : 128,160,184,256,320,352,360,368,376',13,10
                db      '       Heights: 40,80,120,160,200,240,256,282,308,350,360,400,480,512,540,564',13,10
		db	'         The above sizes can be mixed together in ANY way!',13,10
		db	'       Additionally, F.O supports 640x480, 800x600, 1024x768 and 1280x1024',13,10,10
		db	'       Sizes are rounded upwards, i.e a 300x340 pic is centered in 320x350',13,10,10,36


usagemsg	db	'Usage: FO picture.ext [/WIN] [/V]',13,10
		db	'       Switches: WIN = Exit immediately in pic''s videomode.',13,10
		db	'                       For viewing nice pics when Win95 boots... ;)',13,10
		db	'                 V   = Override all videocard-tests.',13,10,36

exitmsg 	db	'Thank you for using F.O. If you''ve got any suggestions on how to improve F.O,',13,10
		db	'then please contact me! Look above or in FO.DOC for info on how to do it.',13,10
		db	'As this is FreeWare, you don''t have to be afraid of contacting me even',13,10
		db	'if you don''t have any money in your pockets... ;)',13,10
		db	'As always though, I''m extremely willing to accept donations! <g>',13,10,10,36


errormsg	db	'[ERROR] ',36

notsupportmsg	db	' file(s) were either corrupt or of unknown format!',13,10,36

bmp16msg	db	'[ERROR] F.O currently does not support packed 16-color BMP''s!',13,10
		db	'        PLEASE send me one and I''ll implement it!',13,10,36

memerrormsg	db	'[ERROR] Could not allocate enough memory!',13,10,36

fileerrormsg	db	'[ERROR] The file could not be correctly loaded!',13,10,36

picerrormsg	db	'[ERROR] Picture-file contains errors!',13,10,36

vgamsg		db	'[ERROR] It seems you dont have a compatible VGA-card!',13,10
		db	'        Use "/V" to override VGA-test.',13,10,36

vesaerrormsg	db	'[ERROR] Could not initialize correct VESA-mode! Used the best matching',13,10
                db      '        valid mode instead. Use "/V" to set the mode anyway.',13,10,36

formspecmsg	db	'[ERROR] F.O currently only supports FORM files complying to these rules:',13,10
		db	'        <= 256 colors (PBM must be 256) and not mskHasMask',13,10
		db	'        ILBM must also be byterun1-encoded.',13,10,36

formmsg 	db	'[ERROR] Unknown FORM-format, F.O only supports ILBM and PBM.',13,10,36

pcxcolormsg	db	'[ERROR] F.O only supports PCX''s with 256 or less colors (yet).',13,10,36

fliframesmsg	db	13,10,'Frames in FLI/FLC: $'
fliwidthmsg	db	13,10,'Width: $'
fliheightmsg	db	13,10,'Height: $'
flicolorsmsg	db	13,10,'Colors: $'

argnumber	dd	0		; used for processing cmdline

picshown	db	0		; 1 = at least one pic is shown

switchwin	db	0		; 1 = /win is on cmdline
switchv 	db	0		; 1 = override vga- and VESA-detection
switchx 	dd	0		; = forced screenwidth
switchy 	dd	0		; = forced screenheight

findingnext	db	0		; 1 = searching (using wildcards)

vesafailed	db	0		; 1 = tried to init vesa, but failed
picerrors	dd	0		; # file(s) wasn't recognized

align 4

picxoffset      dd      0               ; # of pixels to scroll right
picyoffset	dd	0		; # of pixels to scroll down

printdeclimits	dd	1,10,100,1000
		dd	10000,100000,1000000,10000000
		dd	100000000,1000000000

_process	label	dword			; offsets to depack-proc's
		dd	offset _processcolorrix
		dd	offset _processformilbm
		dd	offset _processformpbm
		dd	offset _processpcx
		dd	offset _processbmp
		dd	offset _processfliflc

rmstackptr	label	dword		; stackptr when calling rm-ints
		dw	8192		; offset to top of 8k-buffer
buffer8kseg	dw	?		; seg of 8k buffer in low mem

rmdsandes	label	dword		; used when calling rm-ints
rm_es		dw	?		; realmode ES
rm_ds		dw	?		; realmode DS

granularity	dd	?		; vesa-granularity

cmdlength	dd	?		; length of cmdline

vesaindex       dd      ?               ; used for indexing vesa-lists
vesapostemp	dd	?		; position in videomem
vesabanktemp	dd	?		; bank-number (used when putting)

widthtemp	dd	?		; = min(scrwidth,picwidth)

dtaaddress	dd	?		; offset to dma (psp+80h)

widthnumber	dd	?		; index in widths-list
heightnumber	dd	?		; index in heights-list

cmdline 	db	128 dup(?)	; cmdline is copied here
filesize	dd	?

scrwidth	dd	?		; width of screen
scrheight	dd	?		; height of screen
scrcolors	dd	?		; colors on screen

picwidth	dd	?		; width of picture
picheight	dd	?		; height of picture
origpicwidth	dd	?		; backup variable
origpicheight	dd	?		; backup variable
piccolors	dd	?		; colors in picture
bitplanes       dd      ?               ; bitplanes in image
cplanes 	dd	?		; colorplanes in image
picsize 	dd	?		; equals picwidth*picheight
scrsize 	dd	?		; equals scrwidth*scrheight

picformat	dd	?		; #0 = ColorRIX
					; #1 = FORM ILBM
					; #2 = FORM PBM
					; #3 = ZSoft PCX
					; #4 = Windows BMP
                                        ; #5 = FLI/FLC

filebufptr	dd	?		; ptr to buffer for file
picbufptr	dd	?		; ptr to buffer for unpacked pic

bytesperscanline dd     ?               ; bytes per scanline

videoptr	dd	?		; 0a0000h - linear address of codeseg
textptr 	dd	?		; 0b8000h - linear address of codeseg
codeaddress	dd	?		; linear address of codeseg

formpacked	dd	?		; 1 = FORM is byterun1-encoded

pcxtotalbytes	dd	?		; used by pcx-decoder

temppcxline	dd	?		; temporary!

totframes       dd      ?               ; Number of frames in animation
currentframe	dd	?		; Current framenumber (1=first)
flispeed        dd      ?               ; playbackspeed for FLI's & FLC's

pal             db      768 dup(?)      ; palette

wildname        db      81 dup(?)       ; asciz-string if wildcards were given
filename	db	81 dup(?)	; name of pic-file
filehandle	dw	?		; filehandle for pic-file

vesamode        db      ?               ; 1 = videomode is a VESA-mode
fliorflc        db      ?               ; 0 -> not a fli/flc file

	end	_main
