Attribute VB_Name = "modFastView32"
'*******************************************************
' FastView32 was written mostly by Ryan Martinsen
' Image Map Maker - written by Theo Kandiliotis - ionikh@hol.gr
' I don't know who wrote the code for Inverting Colors
'
' If you use any of this code I would appreciate it if
' you would send me any improvements made to the code or
' interface design.
' Please use credit where due.
'
' E-mail: ryan@homeonthewww.com
' Web:    http://www.homeonthewww.com/ryan/
'*******************************************************

' On Top Sub Declaration
Public Declare Sub SetWindowPos Lib "user32" (ByVal hwnd As Integer, ByVal hWndInsertAfter As Integer, ByVal x As Integer, ByVal y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer)

Dim chrs, chrsin, chrsout, idx

' Drag Drop Code Stuff
Type POINTAPI
 x As Long
 y As Long
End Type

Type msg
 hwnd As Long
 message As Long
 wParam As Long
 lParam As Long
 time As Long
 pt As POINTAPI
End Type

Public Declare Sub DragAcceptFiles Lib "shell32.dll" (ByVal hwnd As Long, ByVal fAccept As Long)
Public Declare Sub DragFinish Lib "shell32.dll" (ByVal hDrop As Long)
Public Declare Function DragQueryFile Lib "shell32.dll" Alias "DragQueryFileA" (ByVal hDrop As Long, ByVal UINT As Long, ByVal lpStr As String, ByVal ch As Long) As Long
Public Declare Function PeekMessage Lib "user32" Alias "PeekMessageA" (lpMsg As msg, ByVal hwnd As Long, ByVal wMsgFilterMin As Long, ByVal wMsgFilterMax As Long, ByVal wRemoveMsg As Long) As Long
Public Const PM_NOREMOVE = &H0
Public Const PM_NOYIELD = &H2
Public Const PM_REMOVE = &H1
Public Const WM_DROPFILES = &H233

Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Const WM_CLOSE = &H10
Const WM_SYSCOMMAND = &H112
Const SC_CLOSE = &HF060
Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long

Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Public Const SW_NORMAL = 1

'Integer that holds the total of regions on the
'image map
Public NofRegions As Integer

Public Region(100, 6)
'An array that holds all the information of all
'the regions on the image map:
'
'Region(x,y)
'
'x
'-> an integer ,the index of the region
'It's  0 <= x <= NofRegions and there can be
'up to 100 regions on one image map.
'
'Region(x,1) , Region(x,2) , Region(x,3) , Region(x,4)
'-> The coordinates of the two pixels that define
'the rectangular region
'
'Region(x,5)
'-> A string that holds the URL that the region will
'-> lead to
'
'Region(x,6)
'-> A string that holds the name of the frame in
'which the new HTML file will load in

Public ScreenRes
Public TWidth
Public THeight
Public Sub WatchForFiles()
On Error GoTo err1
'This watches for all WM_DROPFILES messages
Dim FileDropMessage As msg 'Msg Type
Dim fileDropped As Boolean 'True if Files where dropped
Dim hDrop As Long 'Pointer to the dropped file structure
Dim filename As String * 128 'the dropped filename
Dim numOfDroppedFiles As Long 'the number of dropped files
Dim curFile As Long 'the current file number
'loop to keep checking for files
'NOTE: Do any code you want to execute before this set

Do

'check for Dropped file messages
fileDropped = PeekMessage(FileDropMessage, 0, WM_DROPFILES, WM_DROPFILES, PM_REMOVE Or PM_NOYIELD)

If fileDropped Then

'get the pointer to the dropped file structure
hDrop = FileDropMessage.wParam

'get the total number of files
numOfDroppedFiles = DragQueryFile(hDrop, True, filename, 127)
For curFile = 1 To numOfDroppedFiles

'get the file name
ret = DragQueryFile(hDrop, curFile - 1, filename, 127)

'at this pointer you can do what you want with the filename

'the filename will be a full qualified path
If Right$(filename, 4) = ".htm" Or Right$(filename, 4) = ".css" Or Right$(filename, 4) = ".txt" Or Right$(filename, 4) = "html" Or Right$(filename, 4) = ".asp" Or Right$(filename, 4) = "shtm" Then
 MsgBox filename
 frmFastViewHTML.Show
 frmFastViewHTML.WebBrowser1.Navigate filename
 frmFastView.Hide
Else
 frmFastView.MousePointer = vbHourglass
 Set frmFastView.picImage = LoadPicture(filename)
 frmFastView.Width = frmFastView.picImage.Width + 95
 frmFastView.Height = frmFastView.picImage.Height + 665
 frmFastView.picGet.Height = frmFastView.picImage.Height
 frmFastView.picGet.Width = frmFastView.picImage.Width

 frmFastView.txtFilename.Text = filename
 frmFastView.txtFilename.Text = ExtractName(frmFastView.txtFilename.Text)

 frmFastView.Caption = "FastView32 - " & frmFastView.txtFilename.Text & " (" & frmFastView.picGet.ScaleWidth & " x " & frmFastView.picGet.ScaleHeight & ")"

 frmFastView.Move (Screen.Width - frmFastView.Width) \ 2, (Screen.Height - frmFastView.Height) \ 2
 frmFastView.MousePointer = Default
End If
Next curFile

'we are now done with the structure, tell windows to discard it
DragFinish (hDrop)
End If

DoEvents
Loop
Exit Sub
err1:
Exit Sub
End Sub
Private Sub Main()
If App.PrevInstance = True Then
Dim Handle As Integer, x As Integer

Handle = FindWindow(vbNullString, "FastView32 Hidden Window")
If Handle <> 0 Then x = SendMessage(Handle, WM_SYSCOMMAND, SC_CLOSE, 0&)
End If

frmFastView.Show
WatchForFiles
End Sub
Function ExtractName(chrsin As String)

If InStr(chrsin, "\") Then 'check to see if a forward slash exists
   For idx = Len(chrsin) To 1 Step -1 'step though until full name is extracted
       If Mid(chrsin, idx, 1) = "\" Then
          chrsout = Mid(chrsin, idx + 1)
          Exit For
       End If
   Next idx
ElseIf InStr(chrsin, ":") = 2 Then 'otherwise, check to see if a colon exists
   chrsout = Mid(chrsin, 3)        'if so, return the filename
Else
   chrsout = chrsin 'otherwise, return the original string
End If

ExtractName = chrsout 'return the filename to the user

End Function
Public Sub OnTop(hwnd As Long)
' OnTop hWnd

Call SetWindowPos _
(hwnd, -1, 0, 0, 0, 0, &H2 Or &H1)


' OffTop hWnd
' frmAbout.Show vbModal
' OnTop hWnd
End Sub


Public Sub OffTop(hwnd As Long)

' OffTop hWnd

Call SetWindowPos _
(hwnd, -2, 0, 0, 0, 0, &H2 Or &H1)

End Sub

