'  Public definitions for the 32-bit EGI player DLL.
'  Include this file in Visual Basic applications that use
'  EPLAY32.DLL.
'
'  Version 2.2
'  (c) Copyright ITB CompuPhase, 1996-1998

' Types
Type Rectangle
  Left As Long
  Top As Long
  Right As Long
  Bottom As Long
End Type

' Functions
Declare Function FlicClose Lib "eplay32.dll" (ByVal Flic&) As Boolean
Declare Function FlicCreateWindow Lib "eplay32.dll" (ByVal Caption$, ByVal style&, ByVal X&, ByVal Y&, ByVal WinWidth&, ByVal WinHeight&, ByVal hwndParent&, ByVal reserved&) As Long
Declare Function FlicError Lib "eplay32.dll" (ByVal Flic&) As Integer
Declare Function FlicGetData Lib "eplay32.dll" (ByVal Flic&, ByVal code%) As Long
Declare Function FlicGetHandle Lib "eplay32.dll" (ByVal Flic&, ByVal hdc&, ByVal code%) As Long
Declare Function FlicGetParam Lib "eplay32.dll" (ByVal Flic&, ByVal code%) As Integer
Declare Function FlicGetRect Lib "eplay32.dll" (ByVal Flic&, ByVal code%, RECT As Rectangle) As Boolean
Declare Function FlicNextFrame Lib "eplay32.dll" (ByVal Flic&) As Integer
Declare Function FlicOpen Lib "eplay32.dll" (ByVal Filename$) As Long
Declare Function FlicOpenEx Lib "eplay32.dll" (ByVal Filename$, ByVal Flags%, ByVal Password$) As Long
Declare Function FlicPaint Lib "eplay32.dll" (ByVal Flic&, ByVal hdc&, ByVal PaintAll As Boolean) As Integer
Declare Function FlicPlay Lib "eplay32.dll" (ByVal Flic&, ByVal hWnd&) As Boolean
'       Function FlicSetCallback cannot be supported in Visual Basic
Declare Function FlicSetHandle Lib "eplay32.dll" (ByVal Flic&, ByVal code%, ByVal handle&) As Boolean
Declare Function FlicSetParam Lib "eplay32.dll" (ByVal Flic&, ByVal code%, ByVal Value%) As Boolean
Declare Function FlicStop Lib "eplay32.dll" (ByVal Flic&) As Boolean

' Flags for FlicOpenEx
Global Const FLIC_FLAG_MEMORY      = &H0001
Global Const FLIC_FLAG_RESOURCE    = &H0002
Global Const FLIC_FLAG_UNICODE     = &H0004
Global Const FLIC_FLAG_FILEHANDLE  = &H0008
Global Const FLIC_FLAG_PASSWORD    = &H0100

' Parameters for FlicGetParam and FlicSetParam
Global Const FLIC_PARAM_ISPLAYING = 0 ' 1=FLIC file is currently playing
Global Const FLIC_PARAM_WIDTH = 1
Global Const FLIC_PARAM_HEIGHT = 2
Global Const FLIC_PARAM_NUMFRAMES = 3 ' total number of frames
Global Const FLIC_PARAM_CURFRAME = 4 ' current frame number
Global Const FLIC_PARAM_CONTINUOUS = 5 ' segment is continuous (it has a ring frame)
Global Const FLIC_PARAM_SPEED = 6 ' playback speed, set to 0 for max. speed
Global Const FLIC_PARAM_DESIGNSPEED = 7 ' design speed, read from FLIC file
Global Const FLIC_PARAM_REALSPEED = 8 ' real playback speed
Global Const FLIC_PARAM_MODE = 9 ' BitBlt mode
Global Const FLIC_PARAM_LOOP = 10 ' loop frames or only play once
Global Const FLIC_PARAM_NUMSEGMENTS = 11
Global Const FLIC_PARAM_CURSEGMENT = 12
Global Const FLIC_PARAM_XPOS = 13 ' position of the animation in the window
Global Const FLIC_PARAM_YPOS = 14
Global Const FLIC_PARAM_LABEL = 15 ' label of the current frame (-1 if none)
Global Const FLIC_PARAM_CHGPAL = 16 ' obscoleted by FLIC_PARAM_PALMODE
Global Const FLIC_PARAM_VERSION = 17 ' current version of EGI player
Global Const FLIC_PARAM_SEGLABEL = 18 ' the label of the current segment
Global Const FLIC_PARAM_DRAWFRAME = 19 ' draw the frames?
Global Const FLIC_PARAM_FRNOTIFY = 20 ' notify for each frame?
Global Const FLIC_PARAM_MASK = 21 ' masks present (0=no, 1=bitmap, 2=skip-copy, 3=both)
Global Const FLIC_PARAM_ID = 22 ' user specified id
Global Const FLIC_PARAM_MSGNUM = 23 ' value of FLIC_NOTIFY
Global Const FLIC_PARAM_KEYFREQ = 24 ' key frame interval (0 if there are no key frames)
Global Const FLIC_PARAM_SKIPDELTAS = 25 ' skip all delta frames up to the next key frame
Global Const FLIC_PARAM_PALMODE = 26 ' set the palette mode
Global Const FLIC_PARAM_IDENTPAL = 27 ' 1:1 mapping DIB colour table to logical palette?
Global Const FLIC_PARAM_SENDNOTIFY = 28 ' send notification messages?
Global Const FLIC_PARAM_COLORDEPTH = 29 ' 8=256 colours, 15, 16 or 24 = RGB
Global Const FLIC_PARAM_NUMREGRECTS = 30 ' number or rectangles that form the region
Global Const FLIC_PARAM_LASTFRAME = 31 ' last frame to play
Global Const FLIC_PARAM_PLAYWAVE = 32 ' play audio chunks?
Global Const FLIC_PARAM_SYNCHRONIZE = 33 ' speed is more important than quality
Global Const FLIC_PARAM_NEXTSEGMENT = 34 ' segment that (by design) follows this one
Global Const FLIC_PARAM_REPEATS = 35 ' number of repeats for the segment
Global Const FLIC_PARAM_DESIGNWIDTH = 36 ' design size, read from FLIC file
Global Const FLIC_PARAM_DESIGNHEIGHT = 37

' Values for FLIC_PARAM_MODE
Global Const FLIC_MODE_BITBLT = 0
Global Const FLIC_MODE_DIBTODEV = 1
Global Const FLIC_MODE_STRETCHDIB = 2
Global Const FLIC_MODE_WING = 3 ' no longer supported
Global Const FLIC_MODE_DIBSECTION = 4
Global Const FLIC_MODES = 5 ' number of modes

' Values for FLIC_PARAM_PALMODE
Global Const FLIC_PAL_ADAPT = 0 ' adapt to system palette
Global Const FLIC_PAL_ANIM = 1 ' use palette from FLIC file (default)
Global Const FLIC_PAL_SPECIFIC = 2 ' use palette set with FlicSetHandle
Global Const FLIC_PALMODES = 3 ' number of palette modes

' Values for FLIC_PARAM_SENDNOTIFY
Global Const FLIC_NOTIFY_LAST = &H1 ' notify when playing last frame
Global Const FLIC_NOTIFY_LABEL = &H2 ' notify when reaching a label
Global Const FLIC_NOTIFY_FRAME = &H4 ' notify after decoding a frame
Global Const FLIC_NOTIFY_WAVE = &H8 ' notify after decoding a wave block
Global Const FLIC_NOTIFY_USER = &H10 ' notify for user data

' Parameters for FlicGetData
Global Const FLIC_DATA_BITMAP = 0 ' pointer to the pixel data
Global Const FLIC_DATA_PALETTE = 1 ' pointer to the RGB table
Global Const FLIC_DATA_MASK = 2 ' pointer to the bitmap mask data
Global Const FLIC_DATA_BITMAPINFO = 3 ' pointer to the DIB header
Global Const FLIC_DATA_WAVEDATA = 4 ' pointer to the audio samples
Global Const FLIC_DATA_WAVEHDR = 5 ' pointer to the WAVEHDR structure
Global Const FLIC_DATA_WAVEFORMAT = 6 ' pointer to the WAVEFORMAT structure
Global Const FLIC_DATA_USERDATA = 7 ' pointer to unknown data

' Parameters for FlicGetHandle and FlicSetHandle
Global Const FLIC_HANDLE_PALETTE = 0 ' handle to the palette
Global Const FLIC_HANDLE_BITMAP = 1 ' handle to device dependent bitmap of the frame
Global Const FLIC_HANDLE_MASK = 2 ' handle to the bitmap mask
Global Const FLIC_HANDLE_WINGDC = 3 ' no longer supported (always 0)
Global Const FLIC_HANDLE_WINGBMP = 4 ' no longer supported (always 0)
Global Const FLIC_HANDLE_MUTEX = 5 ' handle to Win32 "mutex" semaphore for bitmap
Global Const FLIC_HANDLE_HWND = 6 ' handle to window passed to FlicPlay
Global Const FLIC_HANDLE_WAVE = 7 ' handle to global wave output device

' Parameters for FlicGetRect
Global Const FLIC_RECT_BOUNDING = 0 ' bounding box of frame differences */
Global Const FLIC_RECT_MASK = 1 ' bounding box of the mask */
Global Const FLIC_RECT_FIRST = 2 ' first rectangle of the region of frame differences */
Global Const FLIC_RECT_NEXT = 3 ' next rectangle of the region of frame differences */

' Returned bits for FlicNextFrame
Global Const FLIC_FRAME_PAL = &H1 ' palette needs updating
Global Const FLIC_FRAME_IMG = &H2 ' image needs updating, use FlicPaint()
Global Const FLIC_FRAME_LAST = &H4 ' last frame has played
Global Const FLIC_FRAME_RING = &H8 ' ring frame has played (reset to 2nd frame)
Global Const FLIC_FRAME_LABEL = &H10 ' a label was reached
Global Const FLIC_FRAME_WAVE = &H20 ' an audio block is ready
Global Const FLIC_FRAME_USER = &H40 ' user data block
Global Const FLIC_FRAME_DECODED = &H8000 ' frame was successfully decoded

' Returned values for FlicError
Global Const FLIC_ERR_NONE = 0
Global Const FLIC_ERR_FOPEN = 1
Global Const FLIC_ERR_FORMAT = 2
Global Const FLIC_ERR_FREAD = 3
Global Const FLIC_ERR_MEMORY = 4
Global Const FLIC_ERR_PARAM = 5
Global Const FLIC_ERR_INVALID = 6
Global Const FLIC_ERR_MUTEX = 7
Global Const FLIC_ERR_UNSUPPORTED = 8
Global Const FLIC_ERR_LOCKED = 9
Global Const FLIC_ERR_WAVEOPEN = 10

' Message posted to the owner window when a label is reached or a segment ends
Global Const FLIC_NOTIFY = &H400 + 98
' Values for wParam upon receipt of FLIC_NOTIFY
Global Const FN_LABEL = 0 ' reached a label (LOWORD(lParam)==label)
Global Const FN_LASTFRAME = 1 ' played last frame
Global Const FN_FRAME = 2 ' played (another) frame
Global Const FN_WAVE = 3 ' digitized sound block is ready
Global Const FN_USERDATA = 4 ' block of user data is ready

