(* Interface to the EGI player DLLs for Borland Delphi.
 * Include this file in Borland Delphi applications that use
 * EPLAY.DLL or EPLAY32.DLL.
 *
 * Version 2.2
 * (c) Copyright ITB CompuPhase, 1996-1998
 *)

unit EGI;

interface

{ Include Windows types }
uses WinTypes, WinProcs, messages;

const

{ Flags for FlicOpenEx() }
  FLIC_FLAG_MEMORY        =$0001;
  FLIC_FLAG_RESOURCE      =$0002;
  FLIC_FLAG_UNICODE       =$0004;
  FLIC_FLAG_FILEHANDLE    =$0008;
  FLIC_FLAG_PASSWORD      =$0100;

{ Parameters for FlicGetParam() and FlicSetParam() }
  FLIC_PARAM_ISPLAYING    = 0;  { 1=FLIC file is currently playing }
  FLIC_PARAM_WIDTH        = 1;
  FLIC_PARAM_HEIGHT       = 2;
  FLIC_PARAM_NUMFRAMES    = 3;  { total number of frames }
  FLIC_PARAM_CURFRAME     = 4;  { current frame number }
  FLIC_PARAM_CONTINUOUS   = 5;  { segment is continuous (it has a ring frame) }
  FLIC_PARAM_SPEED        = 6;  { playback speed, set to 0 for max. speed }
  FLIC_PARAM_DESIGNSPEED  = 7;  { design speed, read from FLIC file }
  FLIC_PARAM_REALSPEED    = 8;  { real playback speed }
  FLIC_PARAM_MODE         = 9;  { BitBlt mode }
  FLIC_PARAM_LOOP         =10;  { loop frames or only play once }
  FLIC_PARAM_NUMSEGMENTS  =11;
  FLIC_PARAM_CURSEGMENT   =12;
  FLIC_PARAM_XPOS         =13;  { position of the animation in the window }
  FLIC_PARAM_YPOS         =14;
  FLIC_PARAM_LABEL        =15;  { label of the current frame (-1 if none) }
  FLIC_PARAM_CHGPAL       =16;  { use current palette, don't create a new one }
  FLIC_PARAM_VERSION      =17;  { current version of EGI player }
  FLIC_PARAM_SEGLABEL     =18;  { the label of the current segment }
  FLIC_PARAM_DRAWFRAME    =19;  { draw the frames? }
  FLIC_PARAM_FRNOTIFY     =20;  { notify for each frame? }
  FLIC_PARAM_MASK         =21;  { masks present (0=no, 1=bitmap, 2=skip-copy, 3=both) }
  FLIC_PARAM_ID           =22;  { user specified id }
  FLIC_PARAM_MSGNUM       =23;  { value of FLIC_NOTIFY }
  FLIC_PARAM_KEYFREQ      =24;  { key frame interval (0 if there are no key frames) }
  FLIC_PARAM_SKIPDELTAS   =25;  { skip all delta frames up to the next key frame }
  FLIC_PARAM_PALMODE      =26;  { palette mode }
  FLIC_PARAM_IDENTPAL     =27;  { 1:1 mapping DIB colour table to palette? }
  FLIC_PARAM_SENDNOTIFY   =28;  { send notification messages? }
  FLIC_PARAM_COLORDEPTH   =29;  { 8=256 colours, 15, 16 or 24 = RGB }
  FLIC_PARAM_NUMREGRECTS  =30;  { number or rectangles that form the region }
  FLIC_PARAM_LASTFRAME    =31;  { last frame to play }
  FLIC_PARAM_PLAYWAVE     =32;  { play audio chunks? }
  FLIC_PARAM_SYNCHRONIZE  =33;  { speed is more important than quality }
  FLIC_PARAM_NEXTSEGMENT  =34;  { segment that (by design) follows this one }
  FLIC_PARAM_REPEATS      =35;  { number of repeats for the segment }
  FLIC_PARAM_DESIGNWIDTH  =36;  { design size, read from FLIC file }
  FLIC_PARAM_DESIGNHEIGHT =37;

{ Returned bits for FlicNextFrame() }
  FLIC_FRAME_PAL      = $0001;  { palette needs updating }
  FLIC_FRAME_IMG      = $0002;  { image needs updating, use FlicPaint() }
  FLIC_FRAME_LAST     = $0004;  { last frame has played }
  FLIC_FRAME_RING     = $0008;  { ring frame has played (reset to 2nd frame) }
  FLIC_FRAME_LABEL    = $0010;  { a label was reached }
  FLIC_FRAME_WAVE     = $0020;  { an audio block is ready }
  FLIC_FRAME_USERSTRING= $0040; { user data block }
  FLIC_FRAME_DECODED  = $8000;  { the frame was decoded correctly }

{ Values for FLIC_PARAM_SENDNOTIFY }
  FLIC_NOTIFY_LAST       =$01;  { notify when playing last frame }
  FLIC_NOTIFY_LABEL      =$02;  { notify when reaching a label }
  FLIC_NOTIFY_FRAME      =$04;  { notify after decoding a frame }
  FLIC_NOTIFY_WAVE       =$08;  { notify after decoding a wave block }
  FLIC_NOTIFY_USERSTRING =$10;  { notify for user data }

type

{ Values for FLIC_PARAM_MODE }
TFLIC_PARAM_MODE =
(
  FLIC_MODE_BITBLT,
  FLIC_MODE_DIBTODEV,
  FLIC_MODE_STRETCHDIB,
  FLIC_MODE_WING,               { no longer supported }
  FLIC_MODE_DIBSECTION,
  FLIC_MODES                    { number of display modes }
);

{ Values for FLIC_PARAM_PALMODE }
TFLIC_PARAM_PALMODE =
(
  FLIC_PAL_ADAPT,       { adapt to system palette }
  FLIC_PAL_ANIM,        { use the palette from the FLIC file (default) }
  FLIC_PAL_SPECIFIC,    { use the palette passed in by FlicSetHandle() }
  FLIC_PALMODES         { number of palette modes }
);

{ Parameters for FlicGetData() }
FLIC_GET_DATA =
(
  FLIC_DATA_BITMAP,     { pointer to the pixel data }
  FLIC_DATA_PALETTE,    { pointer to the RGB table }
  FLIC_DATA_MASK,       { pointer to the bitmap mask data }
  FLIC_DATA_BITMAPINFO, { pointer to the BITMAPINFO structure }
  FLIC_DATA_WAVEDATA,   { pointer to the audio samples }
  FLIC_DATA_WAVEHDR,    { pointer to the WAVEHDR structure }
  FLIC_DATA_WAVEFORMAT, { pointer to the WAVEFORMAT structure }
  FLIC_DATA_USERSTRING, { pointer to unknown data }
  FLIC_DATA_USERDATA    { pointer to user data }
);

{ Parameters for FlicGetHandle() }
FLIC_GET_HANDLE =
(
  FLIC_HANDLE_PALETTE,  { handle to the palette }
  FLIC_HANDLE_BITMAP,   { handle to device dependent bitmap of the frame }
  FLIC_HANDLE_MASK,     { handle to the bitmap mask }
  FLIC_HANDLE_WINGDC,   { handle to WinG Display Context }
  FLIC_HANDLE_WINGBMP,  { handle to WinG bitmap handle }
  FLIC_HANDLE_MUTEX,    { handle to Win32 "mutex" semaphore for bitmap }
  FLIC_HANDLE_HWND,     { handle to window passed to FlicPlay }
  FLIC_HANDLE_WAVE      { handle to global wave output device }
);

{ Parameters for FlicGetRect() }
FLIC_GET_RECT =
(
  FLIC_RECT_BOUNDING,   { bounding box of frame differences }
  FLIC_RECT_MASK,       { bounding box of the mask }
  FLIC_RECT_FIRST,      { first rectangle of the region of frame differences }
  FLIC_RECT_NEXT        { next rectangle of the region of frame differences }
);

{ Returned values for FlicError() }
FLIC_ERROR =
(
  FLIC_ERR_NONE,
  FLIC_ERR_FOPEN,
  FLIC_ERR_FORMAT,
  FLIC_ERR_FREAD,
  FLIC_ERR_MEMORY,
  FLIC_ERR_PARAM,
  FLIC_ERR_INVALID,
  FLIC_ERR_MUTEX,
  FLIC_ERR_UNSUPPORTED,
  FLIC_ERR_LOCKED,
  FLIC_ERR_WAVEOPEN
);


const

{ Message posted to the owner window when a label is reached or a segment ends }
  FLIC_COMMAND = WM_USER+97;
  FLIC_NOTIFY  = WM_USER+98;

  FN_LABEL     = 0;     { reached a label (LOWORD(lParam)==label) }
  FN_LASTFRAME = 1;     { played last frame }
  FN_FRAME     = 2;     { played (another) frame }
  FN_WAVE      = 3;     { digitized sound block is ready }
  FN_USERSTRING= 4;     { block of user data is ready }

  FC_AUTOCLOSE = 0;     { close animation when destroying window? }

type

  LPRECT = ^TRECT;
  LPVOID = ^LongInt;
  LPFLIC = ^LongInt;


{$ifdef WIN32}
        { 32-bit }
function FlicClose       (pFlic : LPFLIC) : boolean; stdcall;
function FlicCreateWindow( szCaption     : PCHAR;
                           dwStyle       : longint;
                           x, y          : integer;
                           width, height : integer;
                           hwndParent    : THandle;
                           reserved      : integer) : THandle; stdcall;
function  FlicError      (pflic : LPFLIC) : integer; stdcall;
function  FlicGetData    (pflic : LPFLIC; code : integer) : LPVOID; stdcall;
function  FlicGetHandle  (pflic : LPFLIC; hdc : HDC; code : integer) : THandle; stdcall;
function  FlicGetParam   (pflic : LPFLIC; code : integer) : integer; stdcall;
function  FlicGetRect    (pflic : LPFLIC; code : integer; lpRect : PRECT) : boolean; stdcall;
function  FlicNextFrame  (pflic : LPFLIC) : word; stdcall;
function  FlicOpen       (filename : pchar) : LPFLIC; stdcall;
function  FlicOpenEx     (filename : pchar; flags : word; password : pchar) : LPFLIC; stdcall;
procedure FlicPaint      (pflic : LPFLIC; _hdc : THandle; bPaintAll : boolean); stdcall;
function  FlicPlay       (pflic : LPFLIC; hwnd : THandle) : boolean; stdcall;
{function  FlicSetCallback(pflic : LPFLIC; callback : ???) : boolean; stdcall;}
function  FlicSetData    (pflic : LPFLIC; code: integer; data: LPVOID) : boolean; stdcall;
function  FlicSetHandle  (pflic : LPFLIC; code: integer; handle: THandle) : boolean; stdcall;
function  FlicSetParam   (pflic : LPFLIC; code: integer; value: integer) : boolean; stdcall;
function  FlicStop       (pflic : LPFLIC) : boolean; stdcall;

{$else}
        { 16-bit }
function FlicClose       (pFlic : LPFLIC) : boolean;
function FlicCreateWindow( szCaption     : PCHAR;
                           dwStyle       : longint;
                           x, y          : integer;
                           width, height : integer;
                           hwndParent    : THandle;
                           reserved      : integer) : THandle;
function  FlicError      (pflic : LPFLIC) : integer;
function  FlicGetData    (pflic : LPFLIC; code : integer) : LPVOID;
function  FlicGetHandle  (pflic : LPFLIC; hdc : HDC; code : integer) : THandle;
function  FlicGetParam   (pflic : LPFLIC; code : integer) : integer;
function  FlicGetRect    (pflic : LPFLIC; code : integer; lpRect : PRECT) : boolean;
function  FlicNextFrame  (pflic : LPFLIC) : word;
function  FlicOpen       (szFilename : pchar) : LPFLIC;
function  FlicOpenEx     (szFilename : pchar; flags : word; password : pchar) : LPFLIC;
procedure FlicPaint      (pflic : LPFLIC; _hdc : THandle; bPaintAll : boolean);
function  FlicPlay       (pflic : LPFLIC; hwnd : THandle) : boolean;
{function  FlicSetCallback(pflic : LPFLIC; callback : ???) : boolean;}
function  FlicSetData    (pflic : LPFLIC; code: integer; data: LPVOID) : boolean;
function  FlicSetHandle  (pflic : LPFLIC; code: integer; handle: THandle) : boolean;
function  FlicSetParam   (pflic : LPFLIC; code: integer; value: integer) : boolean;
function  FlicStop       (pflic : LPFLIC) : boolean;

{$endif}


implementation

{$ifdef WIN32}
        { 32-bit }
function  FlicClose        ; stdcall; external 'eplay32.dll';
function  FlicCreateWindow ; stdcall; external 'eplay32.dll';
function  FlicError        ; stdcall; external 'eplay32.dll';
function  FlicGetData      ; stdcall; external 'eplay32.dll';
function  FlicGetHandle    ; stdcall; external 'eplay32.dll';
function  FlicGetParam     ; stdcall; external 'eplay32.dll';
function  FlicGetRect      ; stdcall; external 'eplay32.dll';
function  FlicNextFrame    ; stdcall; external 'eplay32.dll';
Function  FlicOpen         ; stdcall; external 'eplay32.dll';
Function  FlicOpenEx       ; stdcall; external 'eplay32.dll';
procedure FlicPaint        ; stdcall; external 'eplay32.dll';
function  FlicPlay         ; stdcall; external 'eplay32.dll';
{function  FlicSetCallback ; stdcall; external 'eplay32.dll';}
function  FlicSetData      ; stdcall; external 'eplay32.dll';
function  FlicSetHandle    ; stdcall; external 'eplay32.dll';
function  FlicSetParam     ; stdcall; external 'eplay32.dll';
function  FlicStop         ; stdcall; external 'eplay32.dll';

{$else}
        { 16-bit }
function  FlicClose        ; external 'eplay.dll';
function  FlicCreateWindow ; external 'eplay.dll';
function  FlicError        ; external 'eplay.dll';
function  FlicGetData      ; external 'eplay.dll';
function  FlicGetHandle    ; external 'eplay.dll';
function  FlicGetParam     ; external 'eplay.dll';
function  FlicGetRect      ; external 'eplay.dll';
function  FlicNextFrame    ; external 'eplay.dll';
Function  FlicOpen         ; external 'eplay.dll';
Function  FlicOpenEx       ; external 'eplay.dll';
procedure FlicPaint        ; external 'eplay.dll';
function  FlicPlay         ; external 'eplay.dll';
{function  FlicSetCallback ; external 'eplay.dll';}
function  FlicSetData      ; external 'eplay.dll';
function  FlicSetHandle    ; external 'eplay.dll';
function  FlicSetParam     ; external 'eplay.dll';
function  FlicStop         ; external 'eplay.dll';

{$endif}

end.
